/*
 * Copyright (c) 2004-2011 Marco Maccaferri and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Marco Maccaferri - initial API and implementation
 */

package org.eclipsetrader.ui.internal.markets;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipsetrader.core.internal.markets.MarketService;

public class GeneralWizardPage extends WizardPage {

    Text name;
    MarketService marketService;

    public GeneralWizardPage(MarketService marketService) {
        super("general", "General", null);
        setDescription("Set the market's name");

        this.marketService = marketService;
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
     */
    @Override
    public void createControl(Composite parent) {
        Composite content = new Composite(parent, SWT.NONE);
        content.setLayout(new GridLayout(2, false));
        setControl(content);

        initializeDialogUnits(parent);

        Label label = new Label(content, SWT.NONE);
        label.setText("Name");
        label.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, false, 2, 1));
        name = new Text(content, SWT.BORDER);
        name.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        name.addModifyListener(new ModifyListener() {

            @Override
            public void modifyText(ModifyEvent e) {
                getContainer().updateButtons();
            }
        });

        name.setFocus();
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.wizard.WizardPage#isPageComplete()
     */
    @Override
    public boolean isPageComplete() {
        if (name.getText().equals("")) {
            return false;
        }

        if (marketService.getMarket(name.getText()) != null) {
            setErrorMessage("Another market with the same name exists. Choose another name.");
            return false;
        }

        if (getErrorMessage() != null) {
            setErrorMessage(null);
        }

        return true;
    }

    public String getMarketName() {
        return name.getText();
    }
}
