/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.NotifyInformation;
import org.tigris.subversion.svnclientadapter.Policy;
import org.tigris.subversion.svnclientadapter.SVNNotificationHandler;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;

public class JhlNotificationHandler
extends SVNNotificationHandler
implements Notify2 {
    private boolean receivedSomeChange;
    private boolean sentFirstTxdelta;
    private int updates;
    private int adds;
    private int deletes;
    private int conflicts;
    private int merges;
    private int propConflicts;
    private int propMerges;
    private int propUpdates;
    private boolean inExternal;
    private boolean holdStats;
    private String lastUpdate;
    private String lastExternalUpdate;
    private static final int COMMIT_ACROSS_WC_COMPLETED = -11;
    private static final int ENDED_ABNORMAL = -1;

    public void onNotify(NotifyInformation notifyInformation) {
        this.onNotify(notifyInformation.getPath(), notifyInformation.getAction(), notifyInformation.getKind(), notifyInformation.getMimeType(), notifyInformation.getContentState(), notifyInformation.getPropState(), notifyInformation.getRevision(), notifyInformation.getLock(), notifyInformation.getErrMsg());
    }

    private void onNotify(String string, int n, int n2, String string2, int n3, int n4, long l, Lock lock, String string3) {
        boolean bl = true;
        switch (n) {
            case -1: {
                if (this.command == 3) {
                    this.logError(Policy.bind("notify.commit.abnormal"));
                } else {
                    this.logError(Policy.bind("notify.end.abnormal"));
                }
                if (string3 != null) {
                    this.logError(string3);
                }
                bl = false;
                break;
            }
            case 7: {
                this.logMessage(Policy.bind("notify.skipped", string));
                bl = false;
                break;
            }
            case 23: {
                if (string3 == null) {
                    this.logError(Policy.bind("notify.lock.failed", string));
                } else {
                    this.logError(string3);
                }
                bl = false;
                break;
            }
            case 24: {
                if (string3 == null) {
                    this.logError(Policy.bind("notify.unlock.failed", string));
                } else {
                    this.logError(string3);
                }
                bl = false;
                break;
            }
            case 21: {
                if (lock != null && lock.getOwner() != null) {
                    this.logMessage(Policy.bind("notify.lock.other", lock.getPath(), lock.getOwner()));
                } else {
                    this.logMessage(Policy.bind("notify.lock", string));
                }
                bl = false;
                break;
            }
            case 22: {
                this.logMessage(Policy.bind("notify.unlock", string));
                bl = false;
                break;
            }
            case 8: {
                this.logMessage("D  " + string);
                this.receivedSomeChange = true;
                ++this.deletes;
                break;
            }
            case 9: {
                this.logMessage("A  " + string);
                this.receivedSomeChange = true;
                ++this.adds;
                break;
            }
            case 3: {
                this.logMessage(Policy.bind("notify.restored", string));
                break;
            }
            case 4: {
                this.logMessage(Policy.bind("notify.reverted", string));
                break;
            }
            case 5: {
                this.logError(Policy.bind("notify.revert.failed", string));
                bl = false;
                break;
            }
            case 6: {
                this.logMessage(Policy.bind("notify.resolved", string));
                break;
            }
            case 0: {
                this.logMessage("A         " + string);
                break;
            }
            case 2: {
                this.logMessage("D         " + string);
                this.receivedSomeChange = true;
                break;
            }
            case 10: {
                boolean bl2 = false;
                if (n2 == 2 && (n4 == 0 || n4 == 1 || n4 == 2)) break;
                this.receivedSomeChange = true;
                char[] cArray = new char[]{' ', ' '};
                if (n2 == 1) {
                    if (n3 == 7) {
                        cArray[0] = 67;
                        ++this.conflicts;
                        bl2 = true;
                    } else if (n3 == 6) {
                        cArray[0] = 71;
                        ++this.merges;
                        bl2 = true;
                    } else if (n3 == 5) {
                        cArray[0] = 85;
                        ++this.updates;
                    } else if (n3 == 2 && this.command == 27 && n4 < 4) break;
                }
                if (n4 == 7) {
                    cArray[1] = 67;
                    ++this.propConflicts;
                    bl2 = true;
                } else if (n4 == 6) {
                    cArray[1] = 71;
                    ++this.propMerges;
                    bl2 = true;
                } else if (n4 == 5) {
                    cArray[1] = 85;
                    ++this.propUpdates;
                }
                if (bl2) {
                    this.logError("" + cArray[0] + cArray[1] + " " + string);
                    break;
                }
                this.logMessage("" + cArray[0] + cArray[1] + " " + string);
                break;
            }
            case 12: {
                this.logMessage(Policy.bind("notify.update.external", string));
                this.inExternal = true;
                break;
            }
            case 11: {
                bl = false;
                if (l >= 0L) {
                    this.logRevision(l, string);
                    if (this.command == 8) {
                        this.logCompleted(Policy.bind("notify.export", Long.toString(l)));
                        break;
                    }
                    if (this.command == 2) {
                        this.logCompleted(Policy.bind("notify.checkout", Long.toString(l)));
                        break;
                    }
                    if (this.receivedSomeChange) {
                        if (this.holdStats) {
                            if (this.inExternal) {
                                this.lastExternalUpdate = Policy.bind("notify.update", Long.toString(l));
                                break;
                            }
                            this.lastUpdate = Policy.bind("notify.update", Long.toString(l));
                            break;
                        }
                        this.logCompleted(Policy.bind("notify.update", Long.toString(l)));
                        break;
                    }
                    this.logCompleted(Policy.bind("notify.at", Long.toString(l)));
                    break;
                }
                if (this.command == 8) {
                    this.logCompleted(Policy.bind("notify.export.complete"));
                    break;
                }
                if (this.command == 2) {
                    this.logCompleted(Policy.bind("notify.checkout.complete"));
                    break;
                }
                this.logCompleted(Policy.bind("notify.update.complete"));
                break;
            }
            case 14: {
                if (!this.skipCommand()) {
                    this.logMessage(Policy.bind("notify.status.external", string));
                }
                bl = false;
                break;
            }
            case 13: {
                bl = false;
                if (l < 0L) break;
                this.logRevision(l, string);
                if (this.skipCommand()) break;
                this.logMessage(Policy.bind("notify.status.revision", Long.toString(l)));
                break;
            }
            case 15: {
                this.logMessage(Policy.bind("notify.commit.modified", string));
                break;
            }
            case 16: {
                this.logMessage(Policy.bind("notify.commit.add", string));
                break;
            }
            case 17: {
                this.logMessage(Policy.bind("notify.commit.delete", string));
                break;
            }
            case 18: {
                this.logMessage(Policy.bind("notify.commit.replace", string));
                break;
            }
            case 19: {
                bl = false;
                if (this.sentFirstTxdelta) break;
                this.logMessage(Policy.bind("notify.commit.transmit"));
                this.sentFirstTxdelta = true;
                break;
            }
            case -11: {
                bl = false;
                this.logCompleted(Policy.bind("notify.commit", Long.toString(l)));
            }
        }
        if (bl) {
            this.notifyListenersOfChange(string, JhlConverter.convertNodeKind(n2));
        }
    }

    public void setCommand(int n) {
        this.receivedSomeChange = false;
        this.sentFirstTxdelta = false;
        this.clearStats();
        super.setCommand(n);
    }

    public void logCompleted(String string) {
        super.logCompleted(string);
        if (this.inExternal) {
            this.inExternal = false;
        } else {
            this.logStats();
        }
    }

    private void clearStats() {
        this.adds = 0;
        this.updates = 0;
        this.deletes = 0;
        this.conflicts = 0;
        this.merges = 0;
        this.propConflicts = 0;
        this.propMerges = 0;
        this.propUpdates = 0;
        this.inExternal = false;
        this.holdStats = false;
        this.lastUpdate = null;
        this.lastExternalUpdate = null;
    }

    private void logStats() {
        if (this.holdStats) {
            return;
        }
        if (this.command == 4 || this.command == 27 || this.command == 26) {
            if (this.fileStats()) {
                this.logMessage(Policy.bind("notify.stats.file.head"));
                if (this.conflicts > 0) {
                    this.logMessage(Policy.bind("notify.stats.conflict", Integer.toString(this.conflicts)));
                }
                if (this.merges > 0) {
                    this.logMessage(Policy.bind("notify.stats.merge", Integer.toString(this.merges)));
                }
                if (this.deletes > 0) {
                    this.logMessage(Policy.bind("notify.stats.delete", Integer.toString(this.deletes)));
                }
                if (this.adds > 0) {
                    this.logMessage(Policy.bind("notify.stats.add", Integer.toString(this.adds)));
                }
                if (this.updates > 0) {
                    this.logMessage(Policy.bind("notify.stats.update", Integer.toString(this.updates)));
                }
            }
            if (this.propStats()) {
                this.logMessage(Policy.bind("notify.stats.prop.head"));
                if (this.propConflicts > 0) {
                    this.logMessage(Policy.bind("notify.stats.conflict", Integer.toString(this.propConflicts)));
                }
                if (this.propMerges > 0) {
                    this.logMessage(Policy.bind("notify.stats.merge", Integer.toString(this.propMerges)));
                }
                if (this.propUpdates > 0) {
                    this.logMessage(Policy.bind("notify.stats.update", Integer.toString(this.propUpdates)));
                }
            }
        }
        this.clearStats();
    }

    private boolean fileStats() {
        return this.updates > 0 || this.adds > 0 || this.deletes > 0 || this.conflicts > 0 || this.merges > 0;
    }

    private boolean propStats() {
        return this.propUpdates > 0 || this.propConflicts > 0 || this.propMerges > 0;
    }

    public void holdStats() {
        this.holdStats = true;
    }

    public void releaseStats() {
        this.holdStats = false;
        if (this.command == 4) {
            if (this.lastExternalUpdate != null) {
                this.logCompleted(this.lastExternalUpdate);
            }
            if (this.lastUpdate != null) {
                this.logCompleted(this.lastUpdate);
            }
        }
        this.logStats();
    }
}

