package tk.stepcounter.gui;

import java.io.*;
import java.util.*;
import java.text.*;

/**
 * ݒt@Cǂݍ݁AXV邽߂̔ėpNXB
 *
 * @author  Naoki Takezoe
 * @version 1.0
 */
public class ConfigManager {
	
	private File file;
	private HashMap map;
	
	/**
	 * RXgN^
	 *
	 * @param fileName vpeBt@C̖O
	 */
	public ConfigManager(String fileName) {
		this(new File(fileName));
	}
	
	/**
	 * RXgN^
	 *
	 * @param file vpeBt@C
	 */
	public ConfigManager(File file){
		this.file = file;
		try {
			this.read();
		} catch(Exception e){
			this.map = new HashMap();
		}
	}
	
	
	/**
	 * vpeBݒ肵܂B
	 * ̃p[^݂ꍇA㏑܂B
	 *
	 * @param key   vpeBL[
	 * @param value vpeB̒l
	 */
	public void setProperty(String key,String value){
		String[] values = {value};
		setProperty(key,values);
	}
	
	/**
	 * CfbNXvpeBݒ肵܂B
	 *
	 * @param key    vpeBL[
	 * @param values vpeB̒l
	 */
	public void setProperty(String key,String[] values){
		Vector vec = new Vector();
		for(int i=0;i<values.length;i++){
			vec.add(values[i]);
		}
		this.map.put(key,vec);
	}
	
	
	/**
	 * vpeB擾܂B
	 *
	 * @param key vpeB̃L[
	 * @return    vpeB̒l
	 */
	public String getProperty(String key){
		String[] values = getPropertyValues(key);
		if(values!=null && values.length==0){ return null; }
		return values[0];
	}
	
	/**
	 * CfbNXvpeB擾܂B
	 *
	 * @param key vpeB̃L[
	 * @return    vpeB̒l
	 */
	public String[] getPropertyValues(String key){
		if(this.map.get(key)==null){ return null; }
		Vector vec = (Vector)this.map.get(key);
		String[] dim = new String[vec.size()];
		for(int i=0;i<vec.size();i++){
			dim[i] = (String)vec.get(i);
		}
		return dim;
	}
	
	/**
	 * vpeBt@Cǂݍ݂܂B
	 * CX^X̐ɓIɌĂяo܂B
	 */
	private synchronized void read() throws IOException {
		this.map = new HashMap();
		String line;
		BufferedReader reader = new BufferedReader(new FileReader(this.file));
		while((line=reader.readLine())!=null){
			// g
			line.trim();
			// #Ŏn܂s̓Rg
			if(!line.startsWith("#")){
				String[] dim = StringUtility.split(line,"=");
				if(dim.length>=2){
					String key   = dim[0].trim();
					String value = dim[1].trim();
					
					Vector values;
					if(this.map.get(key) == null){
						values = new Vector();
					} else {
						values = (Vector)this.map.get(key);
					}
					
					values.add(value);
					map.put(key,values);
				}
			}
		}
		reader.close();
	}
	
	/**
	 * vpeBt@CXVi݂Ȃ΍쐬j܂B
	 */
	public synchronized void save() throws IOException {
		BufferedWriter writer = new BufferedWriter(new FileWriter(this.file));
		// wb_o
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
		writer.write("# Date: " + formatter.format(new Date()));
		writer.newLine();
		
		// L[Zbg擾
		Set set = this.map.keySet();
		Iterator iterator = set.iterator();
		// o
		while(iterator.hasNext()){
			String key    = (String)iterator.next();
			Vector values = (Vector)this.map.get(key);
			for(int i=0;i<values.size();i++){
				writer.write(key + "=" + (String)values.get(i));
				writer.newLine();
			}
		}
		// tbV
		writer.flush();
		writer.close();
	}
}