package tk.eclipse.plugin.stepcounter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.ide.IDE;

import tk.stepcounter.CountResult;
import tk.stepcounter.StepCounter;
import tk.stepcounter.StepCounterFactory;

/**
 * JEgʂ\邽߂ViewPart
 * 
 * @see ViewPart
 */
public class StepCountView extends ViewPart {
	
	private Table table;
	private Menu popup;
	private MenuItem copy;
	private MenuItem selectAll;
	private MenuItem clear;
	private MenuItem open;
	private Clipboard clipboard;
	private static String file    = StepCounterPlugin.getResourceString("StepCountView.columnName"); //$NON-NLS-1$
	private static String type    = StepCounterPlugin.getResourceString("StepCountView.columnType"); //$NON-NLS-1$
	private static String step    = StepCounterPlugin.getResourceString("StepCountView.columnStep"); //$NON-NLS-1$
	private static String none    = StepCounterPlugin.getResourceString("StepCountView.columnNone"); //$NON-NLS-1$
	private static String comment = StepCounterPlugin.getResourceString("StepCountView.columnComment"); //$NON-NLS-1$
	private static String total   = StepCounterPlugin.getResourceString("StepCountView.columnTotal"); //$NON-NLS-1$
	private HashMap files = new HashMap();
	
	/**
	 * RXgN^
	 */
	public StepCountView() {
		super();
	}

	/**
	 * ViewPart̒g쐬B
	 * 
	 * @see ViewPart#createPartControl
	 */
	public void createPartControl(Composite parent)  {
		// e[u쐬
		table = new Table(parent,SWT.FULL_SELECTION|SWT.MULTI);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		String[] cols = {file,type,step,none,comment,total};
		for(int i=0;i<cols.length;i++){
			TableColumn col = null;
			if(i==0 || i==1){
				col = new TableColumn(table,SWT.LEFT);
			} else {
				col = new TableColumn(table,SWT.RIGHT);
			}
			col.setText(cols[i]);
			if(i==0){
				col.setWidth(250);
			} else {
				col.setWidth(80);
			}
			col.addSelectionListener(new TableHeaderListener());
		}
		
		// Nbv{[h̏
		clipboard = new Clipboard(parent.getDisplay());
		
		// e[uɃ|bvAbvj[ǉ
		popup = new Menu(table.getShell(),SWT.POP_UP);
		
		open = new MenuItem(popup,SWT.PUSH);
		open.setText(StepCounterPlugin.getResourceString("StepCountView.menuOpen")); //$NON-NLS-1$
		open.addSelectionListener(new TableOpenListener());
		
		copy  = new MenuItem(popup,SWT.PUSH);
		copy.setText(StepCounterPlugin.getResourceString("StepCountView.menuCopy")); //$NON-NLS-1$
		copy.addSelectionListener(new TableCopyListener());
		
		selectAll = new MenuItem(popup,SWT.PUSH);
		selectAll.setText(StepCounterPlugin.getResourceString("StepCountView.menuSelectAll")); //$NON-NLS-1$
		selectAll.addSelectionListener(new TableSelectAllListener());
		
		new MenuItem(popup,SWT.SEPARATOR);
		
		clear = new MenuItem(popup,SWT.PUSH);
		clear.setText(StepCounterPlugin.getResourceString("StepCountView.menuClear")); //$NON-NLS-1$
		clear.addSelectionListener(new TableClearListener());
		
		table.addMouseListener(new TableMouseListener());
	}
	
	/**
	 * JEgs
	 * 
	 * @param selection ISelection
	 */
	public void count(ISelection selection){
		// ׂč폜
		table.removeAll();
		files.clear();
		
		if(selection!=null && selection instanceof IStructuredSelection){
			IStructuredSelection iSel = (IStructuredSelection)selection;
			Iterator ite = iSel.iterator();
			long totalStep    = 0;
			long totalComment = 0;
			long totalNone    = 0;
			while(ite.hasNext()){
				Object obj = ite.next();
				CountResult result = null;
				// Java\[Xt@CiJDTj
				if(obj instanceof ICompilationUnit){
					ICompilationUnit file = (ICompilationUnit)obj;
					result = countFile((IFile)file.getResource());
				// JavapbP[WiJDTj
				} else if(obj instanceof IPackageFragment){
					IPackageFragment pkg = (IPackageFragment)obj;
					result = countPackage(pkg);
				// t@C
				} else if(obj instanceof IFile){
					result = countFile((IFile)obj);
				// fBNg
				} else if(obj instanceof IFolder){
					result = countFolder((IFolder)obj);
				}
				if(result!=null){
					totalStep    += result.getStep();
					totalNone    += result.getNon();
					totalComment += result.getComment();
				}
			}
			// vs\
			String[] data = {
				total,"", //$NON-NLS-1$
				String.valueOf(totalStep),
				String.valueOf(totalNone),
				String.valueOf(totalComment),
				String.valueOf(totalStep+totalNone+totalComment)
			};
			TableItem item = new TableItem(table,SWT.NULL);
			item.setText(data);			
		}
	}
	
	/**
	 * Pt@CJEg
	 * 
	 * @param file t@C
	 * @return ̃t@C̃JEg 
	 */
	private CountResult countFile(IFile file){
		try {
			StepCounter counter = StepCounterFactory.getCounter(file.getName());
			// ΉJE^݂ꍇ
			if(counter!=null){
				CountResult result  = counter.count(file.getLocation().makeAbsolute().toFile());
				String type  = result.getFileType();
				long comment = result.getComment();
				long none    = result.getNon();
				long step    = result.getStep();
				String[] data = {
					file.getFullPath().toString(),
					//file.getName(),
					type,
					String.valueOf(step),
					String.valueOf(none),
					String.valueOf(comment),
					String.valueOf(step+none+comment)
				};
				TableItem item = new TableItem(table,SWT.NULL);
				item.setText(data);
				files.put(file.getFullPath().toString(),file);
				return result;
			// ΉJE^݂Ȃꍇ
			} else {
				String[] data = {
					file.getFullPath().toString(),
					//file.getName(),
					StepCounterPlugin.getResourceString("StepCountView.notSupported"), //$NON-NLS-1$
					"", //$NON-NLS-1$
					"", //$NON-NLS-1$
					"", //$NON-NLS-1$
					"" //$NON-NLS-1$
				};
				TableItem item = new TableItem(table,SWT.NULL);
				item.setText(data);
				files.put(file.getFullPath().toString(),file);
				return null;
			}
		} catch(Exception ex){
			ex.printStackTrace();
			return null;
		}
	}
	
	/**
	 * tH_JEg
	 * 
	 * @param folder tH_
	 * @return tH_̃JEgv
	 */
	private CountResult countFolder(IFolder folder){
		CountResult result = new CountResult();
		try {
			IResource[] children = folder.members();
			for(int i=0;i<children.length;i++){
				if(children[i] instanceof IFile){
					CountResult count = countFile((IFile)children[i]);
					if(count!=null){
						result.setStep   (result.getStep()    + count.getStep());
						result.setNon    (result.getNon()     + count.getNon());
						result.setComment(result.getComment() + count.getComment());
					}
				} else if(children[i] instanceof IFolder){
					CountResult count = countFolder((IFolder)children[i]);
					result.setStep   (result.getStep()    + count.getStep());
					result.setNon    (result.getNon()     + count.getNon());
					result.setComment(result.getComment() + count.getComment());
				}
			}
		} catch(Exception ex){
			ex.printStackTrace();
		}
		return result;
	}
	
	/**
	 * pbP[WJEg
	 *
	 * @param pkg pbP[W
	 * @return pbP[W̃JEgv
	 */
	private CountResult countPackage(IPackageFragment pkg){
		CountResult result = new CountResult();
		try {
			ICompilationUnit[] files = pkg.getCompilationUnits();
			for(int i=0;i<files.length;i++){
				CountResult count = countFile((IFile)files[i].getResource());
				if(count!=null){
					result.setStep   (result.getStep()    + count.getStep());
					result.setNon    (result.getNon()     + count.getNon());
					result.setComment(result.getComment() + count.getComment());
				}
			}
			Object[] obj = pkg.getNonJavaResources();
			for(int i=0;i<obj.length;i++){
				CountResult count = countFile((IFile)obj[i]);
				if(count!=null){
					result.setStep   (result.getStep()    + count.getStep());
					result.setNon    (result.getNon()     + count.getNon());
					result.setComment(result.getComment() + count.getComment());
				}
			}
		} catch(Exception ex){
			ex.printStackTrace();
		}
		return result;
	}
	
	/**
	 * @see ViewPart#setFocus
	 */
	public void setFocus(){
		table.setFocus();
	}
	
	/**
	 * |bvAbvj[̏ԂXV܂B
	 */
	private void updatePopupMenu(){
		// ڂPȏ゠΁uSđIvƁuNAv
		TableItem[] items = table.getItems();
		if(items.length==0){
			selectAll.setEnabled(false);
			clear.setEnabled(false);
		} else {
			selectAll.setEnabled(true);
			clear.setEnabled(true);
		}
		// ڂPłIĂ΁uRs[v
		TableItem[] selection = table.getSelection();
		if(selection.length==0){
			copy.setEnabled(false);
		} else {
			copy.setEnabled(true);				
		}
		// t@CPłIĂ΁uJv
		open.setEnabled(false);
		for(int i=0;i<selection.length;i++){
			String filePath = selection[i].getText(0);
			if(files.get(filePath)!=null){
				open.setEnabled(true);
				break;
			}
		}
	}
	
	/**
	 * e[uőIԂɂȂĂt@CGfB^ŊJ܂B
	 */
	private void openEditor(){
		TableItem[] items = table.getSelection();
		for(int i=0;i<items.length;i++){
			try {
				String filePath = items[i].getText(0);
				if(files.get(filePath)!=null){
					IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
					// Eclipse 3.0Ή
					IDE.openEditor(window.getActivePage(),(IFile)files.get(filePath),true);
				}
			} catch(Exception ex){
				// TODO O͈ԂĂ܂c
			}
		}
	}
	
	/**
	 * e[ũwb_NbNꂽ΂Ƀ\[gsXi
	 */
	private class TableHeaderListener extends SelectionAdapter {
		public void widgetSelected(SelectionEvent e) {
			try {
				// \[gJ
				TableColumn column = (TableColumn)e.getSource();
				int sortColumn = 0;
				String name = column.getText();
				if(name.equals(file)){
					sortColumn = 0;
				} else if(name.equals(type)){
					sortColumn = 1;
				} else if(name.equals(step)){
					sortColumn = 2;
				} else if(name.equals(none)){
					sortColumn = 3;
				} else if(name.equals(comment)){
					sortColumn = 4;
				} else if(name.equals(total)){
					sortColumn = 5;
				}
				// f[^ArrayListɊi[
				TableItem[] items = table.getItems();
				ArrayList list = new ArrayList();
				for(int i=0;i<items.length;i++){
					list.add(new String[]{
						items[i].getText(0),
						items[i].getText(1),
						items[i].getText(2),
						items[i].getText(3),
						items[i].getText(4),
						items[i].getText(5)
					});
				}
				// \[g
				Object[] datas = list.toArray();
				Arrays.sort(datas,new TableComparator(sortColumn));
				// f[^ĕ\
				table.removeAll();
				for(int i=0;i<datas.length;i++){
					TableItem item = new TableItem(table,SWT.NULL);
					item.setText((String[])datas[i]);				
				}
			} catch(Exception ex){
				ex.printStackTrace();
			}
		}
	}
	
	/**
	 * e[ůes\[gComparator
	 */
	private class TableComparator implements Comparator {
		
		private int index = 0;
		
		/**
		 * RXgN^
		 * 
		 * @param index \[gJ̃CfbNX
		 */
		public TableComparator(int index){
			this.index = index;
		}
		
		/* ( Javadoc)
		 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
		 */
		public int compare(Object obj1, Object obj2) {
			String[] data1 = (String[])obj1;
			String[] data2 = (String[])obj2;
			// vs͏Ɉԉ
			if(data1[0].equals(total)){
				return 1;
			} else if(data2[0].equals(total)){
				return -1;
			}
			// l\[g
			if(index>=2){
				long value1 = 0;
				long value2 = 0;
				if(data1[index]!=null && !data1[index].equals("")){ //$NON-NLS-1$
					value1 = Long.parseLong(data1[index]);
				}
				if(data2[index]!=null && !data2[index].equals("")){ //$NON-NLS-1$
					value2 = Long.parseLong(data2[index]);
				}
				if(value1==value2){
					return 0;
				} else if(value1 > value2){
					return -1;
				} else {
					return 1;
				}
			}
			// \[g
			String value1 = data1[index];
			String value2 = data2[index];
			return value1.compareTo(value2);
		}
	}
	
	/** |bvAbvj[\邽߂̃}EXXi */
	private class TableMouseListener extends MouseAdapter {
		public void mouseUp(MouseEvent e) {
			if(e.button==3){
				updatePopupMenu();
				popup.setVisible(true);
			}
		}
		public void mouseDoubleClick(MouseEvent e) {
			openEditor();
		}
	}
	
	/** e[uőIꂽt@CJ߂̃Xi */
	private class TableOpenListener extends SelectionAdapter {
		public void widgetSelected(SelectionEvent e) {
			openEditor();
		}
	}
	
	/** e[ȗI𕔕Nbv{[hɃRs[邽߂̃Xi */
	private class TableCopyListener extends SelectionAdapter {
		public void widgetSelected(SelectionEvent e) {
			TableItem[] items = table.getSelection();
			if(items.length==0){
				return;
			}
			StringBuffer sb = new StringBuffer();
			for(int i=0;i<items.length;i++){
				sb.append(items[i].getText(0));
				sb.append("\t"); //$NON-NLS-1$
				sb.append(items[i].getText(1));
				sb.append("\t"); //$NON-NLS-1$
				sb.append(items[i].getText(2));
				sb.append("\t"); //$NON-NLS-1$
				sb.append(items[i].getText(3));
				sb.append("\t"); //$NON-NLS-1$
				sb.append(items[i].getText(4));
				sb.append("\t"); //$NON-NLS-1$
				sb.append(items[i].getText(5));
				sb.append("\n"); //$NON-NLS-1$
			}
			TextTransfer transfer = TextTransfer.getInstance();
			clipboard.setContents(new Object[]{sb.toString()},new Transfer[]{transfer});
		}
	}
	
	/** e[ȗSĂ̍sI邽߂̃Xi */
	private class TableSelectAllListener extends SelectionAdapter {
		public void widgetSelected(SelectionEvent e) {
			table.selectAll();
		}
	}
	
	/** e[u̕\eNA邽߂̃Xi */
	private class TableClearListener extends SelectionAdapter {
		public void widgetSelected(SelectionEvent e) {
			table.removeAll();
		}
	}
}
