/*
 * Decompiled with CFR 0.152.
 */
package tk.stepcounter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import tk.stepcounter.AreaComment;
import tk.stepcounter.CountResult;
import tk.stepcounter.StepCounter;

public class DefaultStepCounter
implements StepCounter {
    private Vector lineComment = new Vector();
    private Vector areaComment = new Vector();
    private String fileType = "UNDEF";

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void addLineComment(String str) {
        this.lineComment.add(str);
    }

    public String[] getLineComment() {
        String[] dim = new String[this.lineComment.size()];
        int i = 0;
        while (i < this.lineComment.size()) {
            dim[i] = (String)this.lineComment.get(i);
            ++i;
        }
        return dim;
    }

    public void addAreaComment(AreaComment area) {
        this.areaComment.add(area);
    }

    public AreaComment[] getAreaComment() {
        AreaComment[] dim = new AreaComment[this.areaComment.size()];
        int i = 0;
        while (i < this.areaComment.size()) {
            dim[i] = (AreaComment)this.areaComment.get(i);
            ++i;
        }
        return dim;
    }

    public CountResult count(File file) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        long step = 0L;
        long non = 0L;
        long comment = 0L;
        boolean areaFlag = false;
        AreaComment lastAreaComment = new AreaComment();
        while ((line = reader.readLine()) != null) {
            String trimLine = line.trim();
            if (!areaFlag) {
                if (this.nonCheck(trimLine)) {
                    ++non;
                    continue;
                }
                if (this.lineCommentCheck(trimLine)) {
                    ++comment;
                    continue;
                }
                lastAreaComment = this.areaCommentStartCheck(line, comment);
                if (lastAreaComment != null) {
                    ++comment;
                    areaFlag = true;
                    continue;
                }
                ++step;
                continue;
            }
            ++comment;
            if (!this.areaCommentEndCheck(line, lastAreaComment)) continue;
            areaFlag = false;
        }
        reader.close();
        return new CountResult(file.getName(), this.getFileType(), step, non, comment);
    }

    private boolean nonCheck(String line) {
        return line.equals("");
    }

    private boolean lineCommentCheck(String line) {
        String[] dim = this.getLineComment();
        int i = 0;
        while (i < dim.length) {
            if (line.startsWith(dim[i])) {
                return true;
            }
            ++i;
        }
        AreaComment[] area = this.getAreaComment();
        int i2 = 0;
        while (i2 < area.length) {
            String start = area[i2].getStartString();
            String end = area[i2].getEndString();
            int index = line.indexOf(start);
            if (index == 0 && line.indexOf(end, index) == line.length() - end.length()) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private AreaComment areaCommentStartCheck(String line, long comment) {
        AreaComment[] area = this.getAreaComment();
        int i = 0;
        while (i < area.length) {
            String start = area[i].getStartString();
            String end = area[i].getEndString();
            int index = line.indexOf(start);
            if (index >= 0 && line.indexOf(end, index) < 0) {
                return area[i];
            }
            ++i;
        }
        return null;
    }

    private boolean areaCommentEndCheck(String line, AreaComment area) {
        String end = area.getEndString();
        return line.indexOf(end) >= 0;
    }

    private static String replace(String s, String s1, String s2) {
        if (s == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            if (s.indexOf(s1, i) == i) {
                sb.append(s2);
                i = i + s1.length() - 1;
            } else {
                sb.append(s.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }
}

