﻿#ifndef ABSTRACTPIANOROLL_H
#define ABSTRACTPIANOROLL_H

#include <QAbstractItemView>

namespace stand
{
namespace view
{

class ViewSettings;

class AbstractPianoroll : public QAbstractItemView
{
    Q_OBJECT
public:
    explicit AbstractPianoroll(QWidget *parent = 0);
    virtual ~AbstractPianoroll();

    inline const QWidget *const_widget() const
    {
        return _widget;
    }

    inline ViewSettings *settings()
    {
        return _settings;
    }

    void setSettings(ViewSettings *s);

signals:
    void widgetResized(int w, int h);

public slots:
    void releaseSettings();

private slots:
    void setMeasure();

protected:
    void scrollContentsBy(int dx, int dy);
    bool eventFilter(QObject *, QEvent *);
    void resizeEvent(QResizeEvent *event);
    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    ViewSettings *_settings;
    bool _settingsIsDeletable;
    QWidget *_widget;

    virtual int length();

private:
    void _setWidget(QWidget *w);
    void _drawBeat(QPainter *p, QPaintEvent *e);
    void _drawStripe(QPainter *p, QPaintEvent *e);
    void _updateWidgetPosition();
    void _updateScrollBars();
    QPoint _old;
    QSlider *_h, *_v;

    int _length;
    bool _barMoved;
    QPoint _clickedPos;
};

}
}

#endif // ABSTRACTPIANOROLL_H
