#ifndef TASK_TASK_H
#define TASK_TASK_H

#include <QObject>

namespace stand
{
namespace utility
{
namespace task
{

class Task : public QObject
{
    Q_OBJECT
public:
    explicit Task(QObject *parent = 0);

    virtual QString text() const
    {
        return QString();
    }

signals:
    void progress(int);
    void finished(bool);
    void canceled();

public slots:
    void run();
    void cancel();

protected:
    virtual bool exec() = 0;
    virtual void onCancel()
    {
    }

    inline bool isCanceled() const
    {
        return _isCanceled;
    }

private:
    bool _isCanceled;
};

}
}
}

#endif // TASK_TASK_H
