#include "TaskTest.h"
#include <QMutex>
#include <QWaitCondition>

#include "../utility/task/Worker.h"
#include "../utility/task/Manager.h"

using namespace stand::utility::task;

TestTask::TestTask(QObject *parent) :
    Task(parent)
{
}

bool TestTask::exec()
{
    QMutex * wmutex = new QMutex();
    wmutex->lock();
    QWaitCondition work;
    work.wait(wmutex, 10);
    wmutex->unlock();
    delete wmutex;
    return true;
}

TaskTest::TaskTest(QObject *parent) :
    QObject(parent)
{
}

void TaskTest::testTaskTest()
{
    TestTask *task = new TestTask(this);
    task->run();
    delete task;
}

void TaskTest::testWorkerTest()
{
    QList<Task *> tasks;
    for(int i = 0; i < 1; i++)
    {
        tasks.push_back(new TestTask(this));
    }
    Worker *w = new Worker(tasks, this);

    w->run();

    delete w;
    qDeleteAll(tasks);
}

void TaskTest::finished()
{
    condition.wakeAll();
}

void TaskTest::testManagerTest()
{
    QList<Task *> tasks;
    for(int i = 0; i < 4; i++)
    {
        tasks.push_back(new TestTask(this));
    }
    Manager *m = new Manager(tasks, 4);

    connect(m, SIGNAL(finished()), this, SLOT(finished()), Qt::DirectConnection);

    wait.lock();
    m->start();
    condition.wait(&wait);
    wait.unlock();

    delete m;
    qDeleteAll(tasks);
}
