#include "TimeComputingTaskTest.h"

#include <QTest>

#include "helper/TimeComputingTask.h"
#include "Utility.h"

using namespace stand::gui::helper;
using namespace stand::model;
using namespace stand::utility;

TimeComputingTaskTest::TimeComputingTaskTest(QObject *parent) :
    QObject(parent)
{
}

void TimeComputingTaskTest::executionTest()
{
    QFETCH(int, tick1);
    QFETCH(double, val1);
    QFETCH(int, tick2);
    QFETCH(double, val2);
    QFETCH(int, tick3);
    QFETCH(double, val3);
    QFETCH(int, tick4);
    QFETCH(double, val4);
    QFETCH(double, framePeriod);
    QFETCH(double, msEnd);
    QFETCH(bool, resultFlag);
    QList<ControlItem::Point> l;
    ControlItem::Point p1 = {tick1, val1}, p2 = {tick2, val2}, p3 = {tick3, val3}, p4 = {tick4, val4};
    l.push_back(p1);
    l.push_back(p2);
    l.push_back(p3);
    l.push_back(p4);
    stand::gui::helper::TimeComputingTask task(l, framePeriod, msEnd, this);
    QCOMPARE(task.exec(), resultFlag);
}

void TimeComputingTaskTest::executionTest_data()
{
    QTest::addColumn<int>("tick1");
    QTest::addColumn<double>("val1");
    QTest::addColumn<int>("tick2");
    QTest::addColumn<double>("val2");
    QTest::addColumn<int>("tick3");
    QTest::addColumn<double>("val3");
    QTest::addColumn<int>("tick4");
    QTest::addColumn<double>("val4");
    QTest::addColumn<double>("framePeriod");
    QTest::addColumn<double>("msEnd");
    QTest::addColumn<bool>("resultFlag");

    //                        tick1,  val1,  tick2,  val2,   tick3,  val3 ,  tick4,  val4,   fp, msend,  rest,  resi;
    QTest::newRow("ZeroData") << 0 <<120.0<< 480 << 120.0<<   960 << 120.0<< 480*3<<120.0<<2.0<<6000.0<< true;
    QTest::newRow("Simple")   << 0 <<120.0<< 480 << 120.0<<   960 << 120.0<< 480*3<<120.0<<2.0<<6000.0<< true;
    QTest::newRow("Invalid1") <<INT_MIN<<120.0<<480<<-60.0<<  960 << 120.0<< 480*3<<120.0<<2.0<<6000.0<< false;
}

void TimeComputingTaskTest::datadrivenTest()
{
    QFETCH(int, tick1);
    QFETCH(double, val1);
    QFETCH(int, tick2);
    QFETCH(double, val2);
    QFETCH(int, tick3);
    QFETCH(double, val3);
    QFETCH(int, tick4);
    QFETCH(double, val4);
    QFETCH(double, framePeriod);
    QFETCH(double, msEnd);
    QFETCH(int, resultTick);
    QFETCH(int, resultIndex);
    QList<ControlItem::Point> l;
    ControlItem::Point p1 = {tick1, val1}, p2 = {tick2, val2}, p3 = {tick3, val3}, p4 = {tick4, val4};
    l.push_back(p1);
    l.push_back(p2);
    l.push_back(p3);
    l.push_back(p4);
    stand::gui::helper::TimeComputingTask task(l, framePeriod, msEnd, this);
    bool f = task.exec();
    QVERIFY2(resultIndex < task.data().size(), "index out of range");
    if(f && resultIndex < task.data().size())
    {
        QCOMPARE(task.data()[resultIndex], resultTick);
    }
}


void TimeComputingTaskTest::datadrivenTest_data()
{
    QTest::addColumn<int>("tick1");
    QTest::addColumn<double>("val1");
    QTest::addColumn<int>("tick2");
    QTest::addColumn<double>("val2");
    QTest::addColumn<int>("tick3");
    QTest::addColumn<double>("val3");
    QTest::addColumn<int>("tick4");
    QTest::addColumn<double>("val4");
    QTest::addColumn<double>("framePeriod");
    QTest::addColumn<double>("msEnd");
    QTest::addColumn<int>("resultTick");
    QTest::addColumn<int>("resultIndex");

    //                        tick1,  val1,  tick2,  val2,   tick3,  val3 ,  tick4,  val4,   fp, msend,  rest,  resi;
    QTest::newRow("ZeroData") << 0 <<120.0<< 480 << 120.0<<   960 << 120.0<< 480*3<<120.0<<2.0<<6000.0<< 0    << 0  ;
    QTest::newRow("Simple1")  << 0 <<120.0<< 480 << 120.0<<   960 << 120.0<< 480*3<<120.0<<2.0<<6000.0<< 480  << (int)(MsFromTick(480, 120.0) / 2);
    QTest::newRow("Simple1")  << 0 <<102.0<< 480 << 102.0<<   960 << 102.0<< 480*3<<102.0<<2.0<<6000.0<< 480  << ((int)MsFromTick(480, 102) + 1) / 2;
    QTest::newRow("Simple2")  <<INT_MIN<<120.0<<480 << 120.0<<   960 << 120.0<< 480*3<<120.0<<2.0<<6000.0<<480  << 250;
    QTest::newRow("Simple3")  <<INT_MIN<<120.0<<480 << 120.0<<   960 << 120.0<< 480*3<<120.0<<2.0<<6000.0<<960  << 500;
    QTest::newRow("Simple4")  <<INT_MIN<<120.0<<480 << 120.0<<   960 << 120.0<< 480*3<<120.0<<2.0<<6000.0<<960 * 4  << 2000;
    QTest::newRow("Invalid1") <<INT_MIN<<120.0<<480<<-60.0<<  960 << 120.0<< 480*3<<120.0<<2.0<<6000.0<< 240  << (int)(MsFromTick(240, 120.0) / 2);
    QTest::newRow("RealData1") <<INT_MIN<<102.0<<-800<<102.0<<-420<<102.0<<21120<<118.0<< 2.0<<30000.0 << 480 * 16 <<(int)(MsFromTick(480 * 16, 102.0) / 2.0);
    QTest::newRow("RealData2") <<INT_MIN<<102.0<<-800<<102.0<<-420<<102.0<<21120<<118.0<< 2.0<<30000.0 << 1920 * 8 <<(int)(MsFromTick(1920 * 8, 102.0) / 2.0);
    QTest::newRow("RealData3") <<INT_MIN<<102.0<<-800<<102.0<<-420<<102.0<<21120<<118.0<< 2.0<<30000.0 << 1920 * 11 <<(int)(MsFromTick(1920 * 11, 102.0) / 2.0);
    QTest::newRow("RealData4") <<INT_MIN<<102.0<<-800<<102.0<<-420<<102.0<<21120<<118.0<< 2.0<<30000.0 << 1920 * 12 <<(int)((MsFromTick(1920 * 11, 102.0) + MsFromTick(1920, 118.0)) / 2.0);
}
