#ifndef VSQTEXTIMPORTER_H
#define VSQTEXTIMPORTER_H

#include "Importer.h"

#include <QQueue>
#include <QTextCodec>
#include <QHash>

class QTextStream;

namespace stand
{
namespace sequence
{
namespace importer
{

class VsqTextImporter : public Importer
{
public:
    VsqTextImporter(QTextCodec *codec = 0);
    virtual ~VsqTextImporter();

    void setCodec(QTextCodec *codec = 0);

    bool pop(QString &oper);
    virtual bool open(const QString &path);
    bool eof() const;
    void close();
    bool isOpen() const;

protected:
    void setQueue(QTextStream &stream);
    QQueue<QString> _queue;
    QTextCodec *_codec;

    QHash<QString, QString> _dictionary;
private:
    void _setDefaultObjects();

    void _readEventList(const QString &line);
    void _readControl(const QString &line);
    void _readMeasure(const QString &line);
    void _readEvent(const QString &line);
    void _readLyric(const QString &line);

    QHash<QString, void (VsqTextImporter::*)(const QString &)> _factories;
    QHash<QString, int> _eventTicks;

    int _trackId;
    int _eventId;
    QString _currentParse;
    QString _currentObjectName;
};

}
}
}

#endif // VSQTEXTIMPORTER_H
