#include "Tempo.h"

#include "../configure.h"

using namespace stand::sequence;

Tempo::Tempo() :
    ControlCurve(DefaultBeatsPerMinutes)
{
    clear(120.0);
}

Tempo::~Tempo()
{
}

double Tempo::msAt(int tick) const
{
    double ret = 0;
    int i;
    int currentTick = 0;
    if(tick < 0)
    {
        ret += tick / (double)DefaultTicksPerBeat * 60.0 / _data[0].val;
        return ret;
    }
    for(i = 0; i < _data.size(); i++)
    {
        if(tick < _data[i].tickEnd)
        {
            double beat = (tick - currentTick) / (double)DefaultTicksPerBeat;
            ret += beat * 60.0 / _data[i].val;
            break;
        }
        double beat = (_data[i].tickEnd - currentTick) / (double)DefaultTicksPerBeat;
        ret += beat * 60.0 / _data[i].val;
        currentTick = _data[i].tickEnd;
    }
    return ret * 1000.0;
}

int Tempo::tickAt(double ms) const
{
    int ret = 0;
    double current = 0.0;
    double val = ms / 1000.0 * (double)DefaultTicksPerBeat / 60.0;
    int currentTick = 0;
    if(ms < 0)
    {
        ret += val * _data[0].val;
        return ret;
    }
    for(int i = 0; i < _data.size(); i++)
    {
        double end = current;
        end += (_data[i].tickEnd - currentTick) / _data[i].val;
        if(val < end)
        {
            double diff = val - current;
            ret += diff * _data[i].val;
            break;
        }
        current = end;
        currentTick = _data[i].tickEnd;
        ret = _data[i].tickEnd;
    }
    return ret;
}

