#ifndef LYRICHANDLE_H
#define LYRICHANDLE_H

#include "AbstractHandle.h"

#include <QString>
#include <QHash>

namespace stand
{
namespace sequence
{

class AbstractEvent;

class LyricHandle : public AbstractHandle
{
public:
    LyricHandle();
    ~LyricHandle();

    importer::Interpreter *interpret(const QString &line);

    inline const QString &lyric() const
    {
        return _lyric;
    }

    inline void setLyric(const QString &l)
    {
        _lyric = l;
    }

    inline const QString &pronounce() const
    {
        return _pronounce;
    }

    inline void setPronounce(const QString &p)
    {
        _pronounce = p;
    }

    const QString toString() const;


private:
    importer::Interpreter *_setLyric(const QString &val);
    importer::Interpreter *_setPronounce(const QString &val);

    QString _lyric;
    QString _pronounce;

    static QHash<QString, importer::Interpreter *(LyricHandle::*)(const QString &)> Factories;
};

}
}

#endif // LYRICHANDLE_H
