#ifndef UTAUCORPUSIMPORTER_H
#define UTAUCORPUSIMPORTER_H

#include <QList>
#include <QDir>
#include "Importer.h"

namespace stand
{
namespace io
{
namespace utau
{
class UtauLibrary;
class PrefixMap;
class CharacterSettings;
struct UtauPhoneme;
}
}
namespace model
{
namespace importer
{

class UtauCorpusImporter : public Importer
{
private:
public:
    virtual bool import(TreeItem *root, const QString &filepath) const;

private:
    class LibraryNode
    {
    public:
        struct Item
        {
            const stand::io::utau::UtauPhoneme *phoneme;
            int note;
            QDir directory;
            QString prefix;
        };

        LibraryNode();
        ~LibraryNode();

        void read(const QString &filepath);

        QList<Item> phonemes(const QStringList &prefix, const QString &key);

        stand::io::utau::UtauLibrary *library;
        QList<LibraryNode *> children;
    };

    static TreeItem *_createItem(TreeItem *root, QList<LibraryNode::Item> phonemes, const QString &alias, QDir dir);
    static QStringList _getAllAlias(const QStringList &prefix, LibraryNode *root);
    static void _setRoot(TreeItem *root, stand::io::utau::CharacterSettings *settings);
    static void _setItem(TreeItem *item, LibraryNode::Item phoneme, QDir rootdir);
};

}
}
}

#endif // UTAUCORPUSIMPORTER_H
