#ifndef TREEITEM_H
#define TREEITEM_H

#include <QObject>
#include <QList>
#include <QVariant>
#include <qdom.h>

namespace stand
{
namespace model
{
namespace xml
{
class TreeXmlFactory;
}

class TreeItem : public QObject
{
    Q_OBJECT
public:
    explicit TreeItem(const QString &name, TreeItem *parent = 0);
    virtual ~TreeItem();

    QDomElement domElement(QDomDocument &doc);

    virtual int columnCount() const
    {
        return std::max(1, _data.size());
    }

    virtual QVariant data(int column, int role) const;

    virtual void setData(int column, const QVariant &d, int role);

    virtual Qt::ItemFlags flags() const
    {
        return _flags;
    }
    virtual void setFlags(Qt::ItemFlags f)
    {
        _flags = f;
    }

    inline void appendChild(TreeItem *child)
    {
        _children.push_back(child);
    }

    inline TreeItem *child(int row) const
    {
        return _children.value(row);
    }

    int row() const
    {
        if(_parent)
        {
            return _parent->_children.indexOf(const_cast<TreeItem *>(this));
        }
        return 0;
    }

    inline int childCount() const
    {
        return _children.count();
    }

    inline TreeItem *parent()
    {
        return _parent;
    }

    void setParent(TreeItem *p)
    {
        _parent = p;
    }

    inline const QString &name() const
    {
        return _name;
    }

    inline void setName(const QString name)
    {
        _name = name;
    }

    inline bool insertRow(int row, TreeItem *item)
    {
        if(row > _children.size())
        {
            return false;
        }
        _children.insert(row - 1, item);
        return true;
    }

    inline void removeRow(int row)
    {
        if(row < _children.size())
        {
            _children.removeAt(row);
        }
    }

    TreeItem *findChildItem(const QString &key);

    void setDomNode(QDomNode &node, const xml::TreeXmlFactory *factory);
protected:
    virtual void setUpDomElement(QDomDocument &doc, QDomElement &element);

private:
    TreeItem *_parent;
    QList<TreeItem *> _children;
    QList<QVariant> _data;
    QString _name;
    Qt::ItemFlags _flags;
};

}
}

#endif // TREEITEM_H
