#ifndef EVENTITEM_H
#define EVENTITEM_H

#include "TreeItem.h"

namespace stand
{
namespace model
{

class EventItem : public TreeItem
{
    Q_OBJECT
public:
    explicit EventItem(const QString &name, TreeItem *parent);
    virtual ~EventItem();
    virtual int columnCount() const;
    virtual QVariant data(int column, int role) const;
    virtual void setData(int column, const QVariant &d, int role);

    enum Role
    {
        TickData        = 0,
        LengthData      = 1,
        NoteData        = 2,
        VelocityData    = 3,
        LyricData       = 4,
        PronounceData   = 5,
        DisplayData     = 6
    };
    const static int DataCount = 7;

    inline int tick() const
    {
        return _tick;
    }
    inline int length() const
    {
        return _length;
    }
    inline unsigned char note() const
    {
        return _note;
    }
    inline unsigned char velocity() const
    {
        return _velocity;
    }
    inline void setLyric(const QString &lyric)
    {
        _lyric = lyric;
    }

    inline const QString &lyric() const
    {
        return _lyric;
    }
    inline const QString &pronounce() const
    {
        return _pronounce;
    }

    QString toString() const;

protected:
    virtual void setUpDomElement(QDomDocument &doc, QDomElement &element);

private:
    int _tick;
    int _length;
    unsigned char _note;
    unsigned char _velocity;
    QString _lyric;
    QString _pronounce;
};

}
}

#endif // EVENTITEM_H
