﻿#ifndef GMMDATA_H
#define GMMDATA_H

namespace stand
{
namespace math
{

class GmmData
{
public:
    GmmData(int dim = 0, int length = 0);
    ~GmmData();

    double **data()
    {
        return _data;
    }

    int dim() const
    {
        return _dim;
    }

    int length() const
    {
        return _length;
    }

    bool empty() const
    {
        return (_dim <= 0 || _length <= 0 || !_data);
    }

private:
    void _create(int dim, int length);
    void _destroy();

    int _dim;
    int _length;
    double **_data;
};

}
}

#endif // GMMDATA_H
