#ifndef MIDIFILE_H
#define MIDIFILE_H

#include <vector>
#include <stdio.h>

namespace stand
{
namespace io
{
namespace midi
{

class MidiChunk;
class MidiEvent;

class MidiFile
{
public:
    MidiFile();
    virtual ~MidiFile();

    bool read(const char *path);

    inline bool empty() const
    {
        return _tracks.empty();
    }

    inline int size() const
    {
        return _tracks.size();
    }

    inline const std::vector<MidiEvent *> *track(int index) const
    {
        if(index >= 0 && index < size())
        {
            return &(_tracks[index]);
        }
        return NULL;
    }

    inline int formatId() const
    {
        return _formatId;
    }

    inline int timeBase() const
    {
        return _timeBase;
    }

    static const char *getDeltaTime(int &d, const char *p);

private:
    void _destroy();
    void _interpret(MidiChunk *chunk, int index);

    char _header[5];
    short _formatId;
    short _numTracks;
    short _timeBase;

    std::vector<MidiChunk *> _chunks;
    std::vector<std::vector<MidiEvent *> > _tracks;
};

}
}
}

#endif // MIDIFILE_H
