/*
 *
 *    WaveBuffer.h
 *                              (c) HAL 2010-, kbinani 2012
 *
 *  This class provides I/O functions for wave files.
 * It keeps raw wave as a 64-bit array buffer.
 *
 * These files are distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */
#ifndef __WaveBuffer_h__
#define __WaveBuffer_h__

#include <iostream>
#include <string>
#include <vector>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <stdint.h>

#include <qglobal.h>

namespace stand
{
namespace io
{
class RiffChunk;

class WaveBuffer{
public:
    struct Format {
        int16_t  formatID;
        uint16_t numChannels;
        uint32_t samplesPerSecond;
        uint32_t bytesPerSecond;
        uint16_t blockAlign;
        uint16_t bitsPerSample;
    };

    WaveBuffer(unsigned int l = 0);
    WaveBuffer(const double *w, unsigned int l);
    WaveBuffer(const char* filename);
    ~WaveBuffer();

    bool read(const char* filename);
    bool write(const char* filename);

    void setHeader(const Format &f)
    {
        _header = f;
    }

    void setWave(const double *w, unsigned int l);

    // 外から書けないようにしておく．
    const double *data() const
    {
        return _data;
    }

    unsigned int length() const
    {
        return _length;
    }

    bool empty() const
    {
        return (!_data || _length == 0);
    }

    const Format *header() const
    {
        return &_header;
    }

    void setLength(unsigned int l)
    {
        _createBuffer(l);
    }

    double normalize();
    static const Format DefaultFormat;

private:
    void _setHeader(const RiffChunk *c);
    void _setData(const RiffChunk *c);
    void _createBuffer(unsigned int l);
    void _destroy();

    void _writeData8(qint8 *p);
    void _writeData16(qint8 *p);
    void _writeData24(qint8 *p);
    void _writeData32(qint8 *p);

    Format _header;
    double *_data;
    unsigned int _length;
};
}
}

#endif
