#include "TimeComputingTask.h"
#include "Utility.h"

using namespace stand::gui::helper;
using namespace stand::model;
using namespace stand::utility;

TimeComputingTask::TimeComputingTask(const QList<stand::utility::ControlPoint> &contour, double framePeriod, double msEnd, QObject *parent) :
    Task(parent), _tempo(QList<stand::utility::ControlPoint>())
{
    set(contour, framePeriod, msEnd);
}

void TimeComputingTask::set(const QList<stand::utility::ControlPoint> &contour, double framePeriod, double msEnd)
{
    _tempo = contour;
    _framePeriod = std::max(1.0, framePeriod);
    msEnd = std::max(1.0, msEnd);
    _lastIndex = msEnd / _framePeriod + 0.5; // 四捨五入…？切り上げ…？
}

bool TimeComputingTask::exec()
{
    if(_tempo.empty())
    {
        qDebug("TimeComputingTask::exec(); // Tempo contour has no data.");
        return false;
    }

    _data.clear();
    _data.resize(_lastIndex);
    _data[0] = 0;

    int c = 1;
    int i = 0;
    int currentTick = 0;
    double currentTempo = _tempo[0].value;
    double currentMs = 0;

    // 負値は飛ばそう．
    for(; i < _tempo.size() && _tempo[i].tick < currentTick; i++)
    {
        currentTempo = _tempo[i].value;
    }

    for(; i < _tempo.size() && c < _lastIndex; i++)
    {
        if(currentTempo <= 0.0)
        {
            qDebug("TimeComputingTask::exec(); // invalid parameters");
            qDebug(" Tempo change at %d[ticks] is invalid value; %f", currentTick, currentTempo);
            return false;
        }
        double nextMs = currentMs + MsFromTick(_tempo[i].tick - currentTick, currentTempo);
        for(double ms = c * framePeriod(); ms < nextMs; c++, ms = c * framePeriod())
        {
            double diff = ms - currentMs;
            _data[c] = currentTick + TicksFromMs(diff, currentTempo);
        }
        currentMs = nextMs;
        currentTempo = _tempo[i].value;
        currentTick = _tempo[i].tick;
    }
    for(double ms; c < _lastIndex; c++)
    {
        ms = c * framePeriod();
        _data[c] = TicksFromMs(ms - currentMs, currentTempo) + currentTick;
    }

    return true;
}
