#ifndef ECHOES_DICTIONARY_H
#define ECHOES_DICTIONARY_H

#include <QList>
#include <QPair>

namespace stand
{
namespace model
{
class SequenceModel;
}
namespace echoes
{

class Data;
class Alignment;
class Analyzer;

class Dictionary
{
public:
    explicit Dictionary();
    virtual ~Dictionary();

    bool analyze(Analyzer *analyzer, const stand::model::SequenceModel *sequence, int trackId, int f0ControlId, int volumeControlId);

    const QPair<Alignment, Data> &at(int i) const;
    const Data &find(const Alignment &key) const;
    inline int size() const
    {
        return _dict.size();
    }

    bool read(const QString &path);
    bool write(const QString &path) const;


private:
    void _destroy();
    QList<QPair<Alignment, Data> > _dict;

    const static Data _NullData;
};

}
}

#endif // ECHOES_DICTIONARY_H
