#include "Dictionary.h"

#include <QtAlgorithms>

#include "TreeItem.h"
#include "Analyzer.h"
#include "Alignment.h"
#include "Data.h"

#include "../configure.h"

using namespace stand::echoes;
using namespace stand::model;

const Data Dictionary::_NullData = Data();

Dictionary::Dictionary()
{
}

Dictionary::~Dictionary()
{
    _destroy();
}

void Dictionary::_destroy()
{
    _dict.clear();
}

bool Dictionary::analyze(Analyzer *analyzer, const SequenceModel *sequence, int trackId, int f0ControlId, int volumeControlId)
{
    qDebug("stand::echoes::Dictionary::analyze(0x%x, 0x%x, %d, %d, %d);", analyzer, sequence, trackId, f0ControlId, volumeControlId);
    if(!sequence || !analyzer)
    {
        qDebug(" error; sequence is null.");
        return false;
    }

    Analyzer::Item item;
    item.sequence = sequence;
    item.trackId = trackId;
    item.f0ControlId = f0ControlId;
    item.volumeControlId = volumeControlId;
    return analyzer->analyze(_dict, item);
}

const Data &Dictionary::find(const Alignment &key) const
{
/*    QList<QPair<Alignment, Data> >::const_iterator it = qUpperBound(_dict, QPair<Alignment, Data>(key, Data()));
    if(it == _dict.end())
    {
        return _NullData;
    }
    return (*it).second;*/
    if(_dict.empty())
    {
        return _NullData;
    }
    for(int i = 0; i < _dict.size(); i++)
    {
        if(_dict[i].first >= key)
        {
            return _dict[i].second;
        }
    }
    return _dict.last().second;
}

const QPair<Alignment, Data> &Dictionary::at(int i) const
{
    return _dict[i];
}

bool Dictionary::write(const QString &path) const
{
    qDebug("stand::echoes::Dictionary::write(%s);", path.toUtf8().data());

    FILE *fp = fopen(path.toLocal8Bit().data(), "wb");

    if(!fp)
    {
        qWarning(" Error; file could not be open.");
        return false;
    }

    fprintf(fp, "stnd");
    int s = size();
    fwrite(&s, sizeof(int), 1, fp);
    for(int i = 0; i < _dict.size(); i++)
    {
        _dict[i].first.write(fp);
        _dict[i].second.write(fp);
    }
    fclose(fp);

    return true;
}

bool Dictionary::read(const QString &path)
{
    qDebug("stand::echoes::Dictionary::read(%s);", path.toUtf8().data());

    FILE *fp = fopen(path.toLocal8Bit().data(), "rb");

    if(!fp)
    {
        qWarning(" Error; file could not be open.");
        return false;
    }
    _destroy();

    bool ret = true;

    char buf[4];
    fread(buf, sizeof(char), 4, fp);
    if(buf[0] != 's' || buf[1] != 't' || buf[2] != 'n' || buf[3] != 'd')
    {
        qWarning(" Error; invalid header.");
        fclose(fp);
        return false;
    }
    int c;
    fread(&c, sizeof(int), 1, fp);
    while(!feof(fp) && ret && c > 0)
    {
        _dict.append(QPair<Alignment, Data>());
        ret &= _dict.last().first.read(fp);
        ret &= _dict.last().second.read(fp);
        c--;
    }

    fclose(fp);

    return ret;
}

