#include <stdio.h>

#include "ControlItem.h"
#include "Data.h"

using namespace stand::echoes;

void Data::_allValueInit()
{
    _f0 = _volume = NULL;
    _ticks = NULL;
    _changeIndex = _length = 0;
}

Data::Data()
{
    _allValueInit();
}

Data::~Data()
{
    _destroy();
}

void Data::_destroy()
{
    delete[] _f0;
    delete[] _volume;
    delete[] _ticks;
    _allValueInit();
}

void Data::setLength(int length)
{
    if(length <= 0)
    {
        qDebug("Data::setLength(%d); // invalid args.", length);
        return;
    }
    _destroy();
    _f0 = new double[length];
    _volume = new double[length];
    _ticks = new int[length];
    _length = length;
}

bool Data::operator ==(const Data &b) const
{
    if(isEmpty() || b.isEmpty())
    {
        return (isEmpty() == b.isEmpty());
    }
    if(length() != b.length() || framePeriod() != b.framePeriod() || changeIndex() != b.changeIndex())
    {
        return false;
    }
    for(int i = 0; i < length(); i++)
    {
        if(f0()[i] != b.f0()[i] || volume()[i] != b.volume()[i] || ticks()[i] != b.ticks()[i])
        {
            return false;
        }
    }
    return true;
}

bool Data::operator !=(const Data &b) const
{
    return !((*this) == b);
}

bool Data::operator <(const Data &) const
{
    return false;
}

bool Data::operator <=(const Data &b) const
{
    return (*this) == b;
}

bool Data::operator >(const Data &) const
{
    return false;
}

bool Data::operator >=(const Data &b) const
{
    return (*this) == b;
}

Data::Data(const Data &b)
{
    _allValueInit();
    *this = b;
}

Data &Data::operator =(const Data &b)
{
    _destroy();
    _length = b.length();
    _framePeriod = b.framePeriod();
    _changeIndex = b.changeIndex();
    _f0 = new double[_length];
    _volume = new double[_length];
    _ticks = new int[_length];
    for(int i = 0; i < _length; i++)
    {
        _f0[i] = b.f0()[i];
    }
    for(int i = 0; i < _length; i++)
    {
        _volume[i] = b.volume()[i];
    }
    for(int i = 0; i < _length; i++)
    {
        _ticks[i] = b.ticks()[i];
    }
    return *this;
}

void Data::write(FILE *fp) const
{
    if(isEmpty())
    {
        return;
    }
    int size = sizeof(int) * 2 + sizeof(double) + sizeof(double) * _length * 2 + sizeof(int) * _length;
    fwrite(&size, sizeof(int), 1, fp);
    fwrite(&_length, sizeof(int), 1, fp);
    fwrite(&_changeIndex, sizeof(int), 1, fp);
    fwrite(&_framePeriod, sizeof(double), 1, fp);
    fwrite(_f0, sizeof(double), _length, fp);
    fwrite(_volume, sizeof(double), _length, fp);
    fwrite(_ticks, sizeof(int), _length, fp);
}

bool Data::read(FILE *fp)
{
    _destroy();
    int size, actual = 0;
    fread(&size, sizeof(int), 1, fp);
    if(size <= 0)
    {
        qDebug("stand::echoes::Data(); // invalid size: %d bytes required.", size);
        return false;
    }
    fread(&_length, sizeof(int), 1, fp);
    if(_length <= 0)
    {
        qDebug("stand::echoes::Data(); // invalid memory allocation: %d bytes", _length);
        _allValueInit();
        return false;
    }
    _f0 = new double[_length];
    _volume = new double[_length];
    _ticks = new int[_length];
    fread(&_changeIndex, sizeof(int), 1, fp);
    fread(&_framePeriod, sizeof(double), 1, fp);
    actual += fread(_f0, sizeof(double), _length, fp);
    actual += fread(_volume, sizeof(double), _length, fp);
    actual += fread(_ticks, sizeof(int), _length, fp);
    if(_length * 3 != actual)
    {
        qWarning("stand::echoes::Data::read();");
        qWarning(" Error; %d bytes read while %d bytes required.", actual, _length * 3);
        return false;
    }

    return true;
}



