#ifndef ECHOES_COMPUTER_H
#define ECHOES_COMPUTER_H

#include <QList>

namespace stand
{
namespace model
{
class EventItem;
class ControlItem;
}
namespace echoes
{

class Dictionary;

class Computer
{
public:
    struct Contours
    {
        stand::model::ControlItem *f0;
        stand::model::ControlItem *volume;
        QList<stand::model::EventItem *> events;
        const Dictionary *dictionary;

        int beginTick;
        int endTick;
        int step;
    };

    bool compute(const Contours &contours) const;

protected:
    virtual bool exec(const Contours &contours) const = 0;
};

}
}

#endif // ECHOES_COMPUTER_H
