#include "Computer.h"

using namespace stand::echoes;
using namespace stand::model;

bool Computer::compute(const Contours &contours) const
{
    qDebug("stand::echoes::Computer::compute();");
    qDebug(" f0 contours = 0x%x, volume envelope = 0x%x, dictionary = 0x%x", contours.f0, contours.volume, contours.dictionary);
    qDebug(" events have %d item(s).", contours.events.size());
    qDebug(" compute between %d to %d [ticks]", contours.beginTick, contours.endTick);

    if(!contours.f0 || !contours.volume || !contours.dictionary || contours.events.empty() || contours.step <= 0
            || contours.beginTick < 0 || contours.endTick < 0 || contours.beginTick >= contours.endTick)
    {
        qDebug(" Error; invalid args.");
        return false;
    }
    return exec(contours);
}
