#include "TrackDelegate.h"

#include "../model/EventItem.h"
#include "../model/SequenceModel.h"
#include "command/LyricChangeCommand.h"
#include "SequenceModel.h"

#include <QPainter>
#include <QUndoStack>
#include <QLineEdit>

using namespace stand::delegate;
using namespace stand::model;

TrackDelegate::TrackDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

TrackDelegate::~TrackDelegate()
{
}

QWidget *TrackDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &/*index*/) const
{
    QLineEdit *editor = new QLineEdit(parent);
    editor->setGeometry(option.rect);
    editor->setFixedSize(option.rect.width(), option.rect.height());
    editor->show();
    editor->raise();
    return editor;
}

void TrackDelegate::setEditorData(QWidget *editor, const QModelIndex &index) const
{
    stand::model::TreeItem *item = (stand::model::TreeItem *)(index.internalPointer());
    QLineEdit *l = dynamic_cast<QLineEdit *>(editor);
    if(!l)
    {
        return;
    }
    l->setText(item->data(stand::model::EventItem::LyricData,0).toString());
    l->show();
    l->raise();
}

void TrackDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
{
    stand::model::SequenceModel *m = dynamic_cast<stand::model::SequenceModel *>(model);
    if(!m)
    {
        return;
    }
    QLineEdit *l = dynamic_cast<QLineEdit *>(editor);
    if(!l)
    {
        return;
    }
    SequenceModel *sequence = dynamic_cast<SequenceModel *>(model);
    if(!sequence)
    {
        return;
    }
    command::LyricChangeCommand *c = new command::LyricChangeCommand(l->text(), index, model);
    sequence->undoStack()->push(c);
}

void TrackDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    stand::model::TreeItem *item = (stand::model::TreeItem *)(index.internalPointer());
    if(!index.isValid() || !item)
    {
        return;
    }

    painter->save();

    painter->fillRect(option.rect, option.palette.background());
    painter->drawRect(option.rect);

    QFont f(painter->font());
    QRect r(option.rect);
    r.setX(r.x() + 1);
    r.setY(r.y() + 2);
    r.setWidth(r.width() - 2);
    r.setHeight(r.height() - 2);
    f.setPixelSize(option.rect.height() - 4);
    painter->setFont(f);
    painter->drawText(r, Qt::AlignLeft | Qt::AlignVCenter, item->data(stand::model::EventItem::DisplayData, 0).toString());

    painter->restore();
}

