﻿#ifndef PITCHDELEGATE_H
#define PITCHDELEGATE_H

#include <QObject>
#include <QColor>

class QPainter;
class QPaintEvent;

namespace stand
{
namespace model
{
class ControlItem;
}
namespace view
{
class ViewSettings;
}
namespace delegate
{

class PitchDelegate : public QObject
{
    Q_OBJECT
public:
    explicit PitchDelegate(stand::view::ViewSettings *s, const QColor color, QObject *parent = 0);
    virtual ~PitchDelegate();

    void setSettings(stand::view::ViewSettings *s);
    stand::view::ViewSettings *settings();

    void setColor(QColor c);
    inline const QColor &color() const
    {
        return _color;
    }

    virtual void paint(QPainter *p, QPaintEvent *e, stand::model::ControlItem *c);

public slots:
    void releaseSettings();
private:
    stand::view::ViewSettings *_settings;
    bool _settingsIsDeletable;
    QColor _color;
};

}
}

#endif // PITCHDELEGATE_H
