#include "PitchDelegate.h"

#include "../view/ViewSettings.h"
#include "../model/ControlItem.h"

#include <QPainter>
#include <QPaintEvent>

using namespace stand::delegate;

PitchDelegate::PitchDelegate(stand::view::ViewSettings *s, const QColor color, QObject *parent) :
    QObject(parent)
{
    _settings = NULL;
    _settingsIsDeletable = false;
    _color = color;
    setSettings(s);
}

PitchDelegate::~PitchDelegate()
{
    if(_settingsIsDeletable)
    {
        delete _settings;
    }
}

void PitchDelegate::releaseSettings()
{
    disconnect(this, SLOT(releaseSettings()));
    _settings = NULL;
    _settings = new stand::view::ViewSettings(1, 16, 64, this);
    _settingsIsDeletable = true;
}

void PitchDelegate::setSettings(stand::view::ViewSettings *s)
{
    if(_settings)
    {
        if(_settingsIsDeletable)
        {
            delete _settings;
        }
    }

    _settingsIsDeletable = false;
    _settings = s;
    if(!s)
    {
        _settings = new stand::view::ViewSettings(1, 16, 64, this);
        _settingsIsDeletable = true;
    }
    else
    {
        connect(s, SIGNAL(AboutToDelete()), this, SLOT(releaseSettings()));
    }
}

void PitchDelegate::paint(QPainter *p, QPaintEvent *e, stand::model::ControlItem *c)
{
    const QList<stand::utility::ControlPoint> &items = c->contour();

    QPen pen(_color);
    p->setPen(pen);

    int index = 0;
    double prev = 0.0;
    for(int i = e->rect().left(); i <= e->rect().right(); i++)
    {
        int tick = _settings->tickAt(i);
        while(index < items.size() - 1 && items[index+1].tick <= tick)
        {
            index++;
        }
        double val = items[index].value;
        if(val != 0.0 && prev != 0.0)
        {
            int y1 = _settings->yAt(prev);
            int y2 = _settings->yAt(val);
            p->drawLine(i - 1, y1, i, y2);
        }
        prev = val;
    }
}
