﻿#ifndef FILEOPENDELEGATE_H
#define FILEOPENDELEGATE_H

#include <QItemDelegate>
#include <QLineEdit>

namespace stand
{
namespace delegate
{

class FileopenDelegate : public QItemDelegate
{
    Q_OBJECT
public:
    explicit FileopenDelegate(const QString &caption = QString(), const QString &dir = QString(), const QString &filter = QString(), QObject *parent = 0);

    QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const;
    void setEditorData(QWidget *editor, const QModelIndex &index) const;
    void setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const;

    void updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const;

signals:

public slots:

private:
    QString _caption;
    QString _dir;
    QString _filter;
};

}
}

#endif // FILEOPENDELEGATE_H
