QT       += core
QT       += gui
QT       += multimedia
QT       += xml

include(dependency.pri)
TEMPLATE = lib
DESTDIR  = $${LIB_DIR}
TARGET   = $${LIB_PREFIX}stand$${LIB_SUFFIX}

CONFIG   += mobility
CONFIG   += staticlib
MOBILITY = multimedia

SOURCES += \
    io/WaveBuffer.cpp \
    io/RiffFile.cpp \
    io/RiffChunk.cpp \
    io/audio/StreamDevice.cpp \
    io/audio/AudioTrack.cpp \
    io/audio/RawWaveTrack.cpp \
    io/audio/AudioMixer.cpp \
    utility/Utility.cpp \
    math/SmootMatching.cpp \
    math/NormalDistribution.cpp \
    math/Matrix.cpp \
    math/MathSet.cpp \
    math/GmmSet.cpp \
    math/GmmData.cpp \
    sequence/importer/SimpleImporter.cpp \
    sequence/VibratoHandle.cpp \
    sequence/Track.cpp \
    sequence/Tempo.cpp \
    sequence/SingerEvent.cpp \
    sequence/Sequence.cpp \
    sequence/NoteEvent.cpp \
    sequence/LyricHandle.cpp \
    sequence/ControlCurve.cpp \
    sequence/importer/VsqTextImporter.cpp \
    sequence/Measure.cpp \
    io/midi/MidiFile.cpp \
    io/midi/MidiChunk.cpp \
    io/midi/MidiEvent.cpp \
    io/midi/MetaEvent.cpp \
    io/midi/ExclusiveEvent.cpp \
    sequence/importer/VsqImporter.cpp \
    math/Pca.cpp \
    io/utau/UtauLibrary.cpp \
    io/utau/PrefixMap.cpp \
    io/utau/CharacterSettings.cpp \
    utility/MessageHandler.cpp \
    math/dsp/tandem_ap.cpp \
    math/dsp/synthesis_ap.cpp \
    math/dsp/synthesis.cpp \
    math/dsp/star.cpp \
    math/dsp/platinum.cpp \
    math/dsp/matlabfunctions.cpp \
    math/dsp/fft.cpp \
    math/dsp/dio.cpp \
    delegate/TrackDelegate.cpp \
    delegate/PitchDelegate.cpp \
    delegate/NoteDelegate.cpp \
    delegate/FileopenDelegate.cpp \
    delegate/ComboboxDelegate.cpp \
    utility/task/Task.cpp \
    utility/task/Worker.cpp \
    utility/envelope/VolumeComputer.cpp \
    utility/envelope/F0Computer.cpp \
    utility/envelope/Envelope.cpp \
    utility/task/Manager.cpp \
    gui/EditorWindow.cpp \
    gui/EditorWidgetConstructor.cpp \
    gui/EditorWidget.cpp \
    gui/CorpusWidget.cpp \
    gui/helper/WaveAnalysisTask.cpp \
    gui/helper/TimeComputingTask.cpp \
    gui/helper/EnvelopeComputingTask.cpp \
    model/TreeItemModel.cpp \
    model/TreeItem.cpp \
    model/TrackItem.cpp \
    model/SequenceModel.cpp \
    model/PhonemeItem.cpp \
    model/MeasureItem.cpp \
    model/EventItem.cpp \
    model/CorpusModel.cpp \
    model/ControlItem.cpp \
    model/xml/TreeXmlFactory.cpp \
    model/xml/SequenceXmlFactory.cpp \
    model/xml/CorpusXmlFactory.cpp \
    model/importer/UtauCorpusImporter.cpp \
    view/ViewSettings.cpp \
    view/ViewArea.cpp \
    view/TrackView.cpp \
    view/TrackSelector.cpp \
    view/TrackNameView.cpp \
    view/SingerView.cpp \
    view/PianoView.cpp \
    view/MeasureView.cpp \
    view/ControlView.cpp \
    view/ControlSelector.cpp \
    view/ControlArea.cpp \
    view/AbstractPianoroll.cpp \
    view/helper/PitchPainter.cpp \
    echoes/Dictionary.cpp \
    echoes/Data.cpp \
    echoes/Alignment.cpp \
    echoes/Analyzer.cpp \
    math/dsp/common.cpp \
    echoes/Echoes.cpp \
    echoes/Computer.cpp \
    echoes/helper/Helper.cpp \
    delegate/command/LyricChangeCommand.cpp

HEADERS  += \
    io/audio/StreamDevice.h \
    io/audio/AudioTrack.h \
    io/audio/RawWaveTrack.h \
    io/audio/AudioMixer.h \
    configure.h \
    io/WaveBuffer.h \
    io/RiffFile.h \
    io/RiffChunk.h \
    utility/Utility.h \
    math/SmootMatching.h \
    math/NormalDistribution.h \
    math/Matrix.h \
    math/MathSet.h \
    math/GmmSet.h \
    math/GmmData.h \
    sequence/importer/SimpleImporter.h \
    sequence/importer/Interpreter.h \
    sequence/importer/Importer.h \
    sequence/VibratoHandle.h \
    sequence/Track.h \
    sequence/Tempo.h \
    sequence/SingerEvent.h \
    sequence/Sequence.h \
    sequence/NoteEvent.h \
    sequence/LyricHandle.h \
    sequence/ControlCurve.h \
    sequence/AbstractHandle.h \
    sequence/AbstractEvent.h \
    sequence/importer/Exporter.h \
    sequence/importer/VsqTextImporter.h \
    sequence/Measure.h \
    io/midi/MidiFile.h \
    io/midi/MidiChunk.h \
    io/midi/MidiEvent.h \
    io/midi/MetaEvent.h \
    io/midi/ExclusiveEvent.h \
    sequence/importer/VsqImporter.h \
    math/Pca.h \
    io/utau/UtauPhoneme.h \
    io/utau/UtauLibrary.h \
    io/utau/PrefixMap.h \
    io/utau/CharacterSettings.h \
    utility/MessageHandler.h \
    math/dsp/world.h \
    math/dsp/fft.h \
    delegate/TrackDelegate.h \
    delegate/PitchDelegate.h \
    delegate/NoteDelegate.h \
    delegate/FileopenDelegate.h \
    delegate/ComboboxDelegate.h \
    utility/task/Task.h \
    utility/task/Worker.h \
    utility/envelope/VolumeComputer.h \
    utility/envelope/F0Computer.h \
    utility/envelope/EnvelopeComputer.h \
    utility/envelope/Envelope.h \
    utility/task/Manager.h \
    gui/EditorWindow.h \
    gui/EditorWidget.h \
    gui/CorpusWidget.h \
    gui/helper/WaveAnalysisTask.h \
    gui/helper/EnvelopeComputingTask.h \
    gui/helper/TimeComputingTask.h \
    model/xml/TreeXmlFactory.h \
    model/xml/SequenceXmlFactory.h \
    model/xml/CorpusXmlFactory.h \
    view/ViewSettings.h \
    view/ViewArea.h \
    view/TrackView.h \
    view/TrackSelector.h \
    view/TrackNameView.h \
    view/SingerView.h \
    view/PianoView.h \
    view/MeasureView.h \
    view/ControlView.h \
    view/ControlSelector.h \
    view/ControlArea.h \
    view/AbstractPianoroll.h \
    view/helper/PitchPainter.h \
    model/TreeItemModel.h \
    model/TreeItem.h \
    model/TrackItem.h \
    model/SequenceModel.h \
    model/PhonemeItem.h \
    model/MeasureItem.h \
    model/EventItem.h \
    model/CorpusModel.h \
    model/ControlItem.h \
    echoes/Dictionary.h \
    echoes/Data.h \
    echoes/Alignment.h \
    echoes/Analyzer.h \
    echoes/Computer.h \
    echoes/Echoes.h \
    utility/ControlPoint.h \
    echoes/helper/Helper.h \
    delegate/command/LyricChangeCommand.h

FORMS    += \
    gui/EditorWindow.ui

RESOURCES += \
    gui/EditorWindow.qrc \
    gui/EditorWindow.qrc
