/*
 EasySFTP - Copyright (C) 2010 Kuri-Applications

 AddrCBox.cpp - declarations of CAddressComboBox and CVirtualAddressComboBox
 */

#pragma once

#define ACBN_FIRST       (1)
#define ACBN_TEXTRETURN  (ACBN_FIRST + 1)

class CAddressComboBox :
	public CMyWindow
{
public:
	CAddressComboBox(void);
	virtual ~CAddressComboBox(void);

	HWND Create(int x, int y, int cx, int cy, HWND hWndParent, UINT uID);

	void ChangeCurrentFolder(PCIDLIST_ABSOLUTE lpidl);
	PCIDLIST_ABSOLUTE GetSelectedFolder() const;
	PCIDLIST_ABSOLUTE FindItemFromDisplayName(LPCWSTR lpszDisplayName) const;
	void RestoreTextBox();
	HWND GetEditWindow() const;

public:
	IShellFolder* m_pFolderRoot;
	IShellFolder* m_pFolder;
	HIMAGELIST m_himlSystemSmall;

protected:
	CMyWindow* m_pWndComboBox;
	_StringW m_strRealPath;
	bool m_bUseDisplayName;
	int m_nCurSel;

	virtual void FillData(void* pData) const;
	virtual void DeleteData(void* pData) const;
	void UpdateRealPath(LPCWSTR lpszRealPath);

	void SendNotify(int code);

	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT OnCreate(WPARAM wParam, LPARAM lParam);
	LRESULT OnCommand(WPARAM wParam, LPARAM lParam);
	LRESULT OnEnable(WPARAM wParam, LPARAM lParam);
	LRESULT OnSize(WPARAM wParam, LPARAM lParam);
	LRESULT OnSetFont(WPARAM wParam, LPARAM lParam);
	LRESULT OnSetFocus(WPARAM wParam, LPARAM lParam);
	LRESULT OnSetCurSel(WPARAM wParam, LPARAM lParam);
	LRESULT OnMeasureItem(WPARAM wParam, LPARAM lParam);
	LRESULT OnDrawItem(WPARAM wParam, LPARAM lParam);
	LRESULT OnDeleteItem(WPARAM wParam, LPARAM lParam);

	friend class CAddressComboBoxMain;
	friend class CAddressComboEditBox;
	friend class CAddressComboLBox;
};

class CVirtualAddressComboBox : public CAddressComboBox
{
public:
	CVirtualAddressComboBox();

	void ChangeCurrentFolder(LPCWSTR lpszDirectoryAbsolute);
	LPCWSTR GetSelectedFolder() const;
	void Empty();

public:
	WCHAR m_wchDelimiter;
	_StringW m_strDirectory;

protected:
	virtual void FillData(void* pData) const;
	virtual void DeleteData(void* pData) const;
};
