﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections;

namespace EAAddinDSM
{
    abstract class Model
    {
        protected ArrayList observer_;

        public Model()
        {
            observer_ = new ArrayList();
        }

        public bool attach(Observer observer)
        {
            if (observer_.Contains(observer))
            {
                return false;
            }
            else
            {
                try
                {
                    observer_.Add(observer);
                    return true;
                }
                catch (System.NotSupportedException e)
                {
                    throw e;
                }
            }
        }

        public bool detach(Observer observer)
        {
            if (observer_.Contains(observer))
            {
                try
                {
                    observer_.Remove(observer);
                    return true;
                }
                catch (System.NotSupportedException e)
                {
                    throw e;
                }
            }
            else
            {
                return false;
            }
        }

        public void update()
        {
            foreach (Observer observer in observer_)
            {
                observer.update();
            }
        }
    }
}
