﻿// In the original BSD license, both occurrences of the phrase "COPYRIGHT HOLDERS AND CONTRIBUTORS"
// in the disclaimer read "REGENTS AND CONTRIBUTORS".
//
// Here is the license template:
//
// Copyright (c) 2010, Masanori Usami
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are permitted provided
// that the following conditions are met:
//
//  * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
//    in the documentation and/or other materials provided with the distribution.
//  * Neither the name of the <ORGANIZATION> nor the names of its contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
// BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
// OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.using System;

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;

namespace EAAddinDSM
{
    public partial class DSMDialog : Form, Observer
    {
        private EventArgs resizeEA = null;
        private DSMModel dsm_;
        private DSMController controller_;

        public DSMDialog()
        {
            InitializeComponent();
        }

        public bool initialize(EA.Repository repository, EA.Diagram diagram, string type)
        {
            try
            {
                dsm_ = new DSMModel(repository, diagram, type);
                if (dsm_.attach(this))
                {
                    controller_ = new DSMController(ref dsm_);
                    if (controller_.initialize())
                    {
                        setDialogFormat();
                        update();
                        return true;
                    }
                }
                return false;
            }
            catch (System.NotSupportedException e)
            {
                throw e;
            }
        }

        public bool initialize(EA.Repository repository, EA.Package package, string type)
        {
            try
            {
                dsm_ = new DSMModel(repository, package, type);
                if (dsm_.attach(this))
                {
                    controller_ = new DSMController(ref dsm_);
                    if (controller_.initialize())
                    {
                        setDialogFormat();
                        update();
                        return true;
                    }
                }
                return false;
            }
            catch (System.NotSupportedException e)
            {
                throw e;
            }
        }

        private void setDialogFormat()
        {
            grid_.AutoSize = true;
            grid_.SelectionMode = DataGridViewSelectionMode.CellSelect;
            grid_.ColumnHeadersVisible = false;
        }
        
        protected override void OnResize(EventArgs e)
        {
            if (resizeEA == null)
            {
                resizeEA = e;
                Application.Idle += new EventHandler(OnIdle);
            }
        }

        private void OnIdle(object s, EventArgs e)
        {
            if (resizeEA != null)
            {
                grid_.Height = Size.Height - 58;
                grid_.Width = Size.Width - 8;

                base.OnResize(resizeEA);
                resizeEA = null;
                Application.Idle -= new EventHandler(OnIdle);
            }
        }

        public void update()
        {
            int[,] dsm = dsm_.getDSM();
            ArrayList nameList = dsm_.getElementNameList();

            grid_.ColumnCount = nameList.Count + 1;
            grid_.RowCount = nameList.Count + 1;
            grid_.Columns[0].SortMode = DataGridViewColumnSortMode.NotSortable;
            grid_.Columns[0].DefaultCellStyle = grid_.ColumnHeadersDefaultCellStyle;
            grid_.Rows[0].DefaultCellStyle = grid_.ColumnHeadersDefaultCellStyle;
            for (int i = 1; i <= nameList.Count; i++)
            {
                grid_.Rows[i].HeaderCell.Value = (string)nameList[i - 1];
                grid_.Rows[i].Cells[0].Value = i.ToString();
                grid_.Rows[i].Frozen = true;
                grid_.Columns[i].SortMode = DataGridViewColumnSortMode.NotSortable;
                grid_.Rows[0].Cells[i].Value = i.ToString();
                for (int j = 0; j < nameList.Count; j++)
                {
                    string value;
                    if ((i - 1) == j)
                    {
                        value = "-";
                        grid_.Rows[i].Cells[j + 1].Style.BackColor = Color.DarkGray;
                    }
                    else
                    {
                        if (dsm[i - 1, j] != 0 && (i - 1) < j)
                        {
                            grid_.Rows[i].Cells[j + 1].Style.BackColor = Color.DarkOrange;
                        }
                        else if (dsm[i - 1, j] != 0 && (i - 1) > j)
                        {
                            grid_.Rows[i].Cells[j + 1].Style.BackColor = Color.DarkCyan;
                        }
                        else
                        {
                            grid_.Rows[i].Cells[j + 1].Style.BackColor = Color.White;
                        }
                        value = dsm[i - 1, j].ToString();
                    }
                    grid_.Rows[i].Cells[j + 1].Value = value;
                    grid_.Rows[i].Cells[j + 1].ReadOnly = true;
                }
            }
        }

        private void menuItemPartitioning__Click(object sender, EventArgs e)
        {
            controller_.partitioning();
        }

        private void menuItemClose__Click(object sender, EventArgs e)
        {
            Close();
        }

        private void menuItemSave__Click(object sender, EventArgs e)
        {
            string path = null;
            SaveFileDialog saveFileDialog = new SaveFileDialog();

            saveFileDialog.Filter = "txt files (*.csv)|*.txt|All files (*.*)|*.*";
            saveFileDialog.FilterIndex = 2;
            saveFileDialog.RestoreDirectory = true;

            if (saveFileDialog.ShowDialog() == DialogResult.OK)
            {
                path = saveFileDialog.FileName;
                controller_.save(path);
                MessageBox.Show("ファイル:" + path + "にDSMを出力しました。");
            }
            else
            {
                MessageBox.Show("保存先ファイルが指定されませんでした。\nDSMは保存されません。");
            }
        }

    }
}
