#define WINVER 0x0500                                  /* o[W` Windows2000ȏ */
#define _WIN32_WINNT WINVER

#include "ruby.h"
#ifndef RUBY_ST_H
#include "st.h"
#endif

#define DXRUBY_EXTERN 1
#include "dxruby.h"
#include "image.h"
#include "font.h"

VALUE cImage;        /* C[WNX       */

/* F */
struct DXRubyColor {
    unsigned char blue;
    unsigned char green;
    unsigned char red;
    unsigned char alpha;
};


/*--------------------------------------------------------------------
   Texture[h
 ---------------------------------------------------------------------*/
static struct DXRubyTexture *Image_textureload( char *filename, D3DXIMAGE_INFO *psrcinfo)
{
    HRESULT hr;
    struct DXRubyTexture *texture;

    /* eNX`擾 */
    texture = (struct  DXRubyTexture *)malloc( sizeof( struct DXRubyTexture ) );

    if( texture == NULL )
    {
        rb_raise( eDXRubyError, "摜p̎擾Ɏs܂ - Image_textureload" );
    }

    /* t@CǂݍŃeNX`IuWFNg쐬 */
    hr = D3DXCreateTextureFromFileEx( g_pD3DDevice, filename,psrcinfo->Width, psrcinfo->Height, 1, 0, D3DFMT_A8R8G8B8, D3DPOOL_MANAGED,
                                      D3DX_DEFAULT,  D3DX_DEFAULT, 0,
                                      0, 0, &texture->pD3DTexture);

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "t@C̓ǂݍ݂Ɏs܂ - %s", filename );
    }

    return texture;
}


/*--------------------------------------------------------------------
   C[WIuWFNgdup/clone
 ---------------------------------------------------------------------*/
VALUE Image_initialize_copy( VALUE self, VALUE obj )
{
    struct DXRubyImage *srcimage;
    struct DXRubyImage *dstimage;
    struct DXRubyTexture *texture;
    D3DLOCKED_RECT srctrect;
    D3DLOCKED_RECT dsttrect;
    int i, j;
    RECT srcrect;
    RECT dstrect;
    HRESULT hr;
    D3DSURFACE_DESC desc;
    int *psrc;
    int *pdst;

    if( TYPE(obj) != T_DATA || RDATA(obj)->dfree != Image_release )
    {
        rb_raise( eDXRubyError, "wrong argument type" );
    }

    Data_Get_Struct( self, struct DXRubyImage, dstimage );
//    DXRUBY_CHECK_DISPOSE( dstimage, texture );
    Data_Get_Struct( obj, struct DXRubyImage, srcimage );
    DXRUBY_CHECK_DISPOSE( srcimage, texture );

    g_iRefAll++;

    /* eNX`擾 */
    texture = (struct  DXRubyTexture *)malloc( sizeof( struct DXRubyTexture ) );
    if( texture == NULL )
    {
        rb_raise( eDXRubyError, "摜p̎擾Ɏs܂ - Image_dup" );
    }

    /* eNX`IuWFNg쐬 */
    hr = D3DXCreateTexture( g_pD3DDevice, srcimage->width, srcimage->height,
                            1, 0, D3DFMT_A8R8G8B8, D3DPOOL_MANAGED,
                            &texture->pD3DTexture);
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "eNX`̍쐬Ɏs܂ - Image_dup" );
    }

    texture->refcount = 1;

    texture->pD3DTexture->lpVtbl->GetLevelDesc(texture->pD3DTexture, 0, &desc );
    texture->width = desc.Width;
    texture->height = desc.Height;

    dstimage->texture = texture;
    dstimage->x = 0;
    dstimage->y = 0;
    dstimage->width = srcimage->width;
    dstimage->height =srcimage-> height;

    /* C[WRs[ */
    dstrect.left = 0;
    dstrect.top = 0;
    dstrect.right = srcimage->width;
    dstrect.bottom = srcimage->height;
    srcrect.left = srcimage->x;
    srcrect.top = srcimage->y;
    srcrect.right = srcimage->x + srcimage->width;
    srcrect.bottom = srcimage->y + srcimage->height;

    dstimage->texture->pD3DTexture->lpVtbl->LockRect( dstimage->texture->pD3DTexture, 0, &dsttrect, &dstrect, 0 );
    srcimage->texture->pD3DTexture->lpVtbl->LockRect( srcimage->texture->pD3DTexture, 0, &srctrect, &srcrect, D3DLOCK_READONLY );

    for( i = 0; i < srcimage->height; i++)
    {
        psrc = (int*)((char *)srctrect.pBits + i * srctrect.Pitch);
        pdst = (int*)((char *)dsttrect.pBits + i * dsttrect.Pitch);
        for( j = 0; j < srcimage->width; j++)
        {
            *(pdst++) = *(psrc++);
        }
    }

    dstimage->texture->pD3DTexture->lpVtbl->UnlockRect( dstimage->texture->pD3DTexture, 0 );
    srcimage->texture->pD3DTexture->lpVtbl->UnlockRect( srcimage->texture->pD3DTexture, 0 );

    return self;
}


/*********************************************************************
 * ImageNX
 *
 * `p̉摜ێNXB
 * t@CnloadƓǂݍ܂AWindow::drawɓnĕ`悷B
 *********************************************************************/

/*--------------------------------------------------------------------
   QƂȂȂƂGCĂ΂֐
 ---------------------------------------------------------------------*/
static void Image_free( struct DXRubyImage *image )
{
    /* eNX`IuWFNg̊J */
    image->texture->refcount--;
    if( image->texture->refcount == 0 )
    {
        RELEASE( image->texture->pD3DTexture );
        free( image->texture );
        image->texture = NULL;
    }
}

void Image_release( struct DXRubyImage *image )
{
    if( image->texture )
    {
        Image_free( image );
    }
    free( image );
    image = NULL;

    g_iRefAll--;
    if( g_iRefAll == 0 )
    {
        CoUninitialize();
    }
}

/*--------------------------------------------------------------------
   ImageNXdisposeB
 ---------------------------------------------------------------------*/
VALUE Image_dispose( VALUE self )
{
    struct DXRubyImage *image = DXRUBY_GET_STRUCT( Image, self );
    DXRUBY_CHECK_DISPOSE( image, texture );
    Image_free( image );
    return self;
}


/*--------------------------------------------------------------------
   ImageNXdisposed?B
 ---------------------------------------------------------------------*/
static VALUE Image_check_disposed( VALUE self )
{
    if( DXRUBY_GET_STRUCT( Image, self )->texture == NULL )
    {
        return Qtrue;
    }

    return Qfalse;
}

/*--------------------------------------------------------------------
   ImageNXdelayed_disposeB
 ---------------------------------------------------------------------*/
static VALUE Image_delayed_dispose( VALUE self )
{
    struct DXRubyRenderTarget *rt = DXRUBY_GET_STRUCT( RenderTarget, g_WindowInfo.render_target );
    struct DXRubyImage *image = DXRUBY_GET_STRUCT( Image, self );
    DXRUBY_CHECK_DISPOSE( image, texture );

    rb_ary_push( rt->array, self );

    return self;
}


/*--------------------------------------------------------------------
   ImageNXallocateBmۂׂinitializeOɌĂ΂B
 ---------------------------------------------------------------------*/
VALUE Image_allocate( VALUE klass )
{
    VALUE obj;
    struct DXRubyImage *image;

    /* DXRubyImagẽ擾ImageIuWFNg */
    image = malloc(sizeof(struct DXRubyImage));
    if( image == NULL ) rb_raise( eDXRubyError, "̎擾Ɏs܂ - Image_allocate" );
    obj = Data_Wrap_Struct(klass, 0, Image_release, image);

    /* Ƃ肠eNX`IuWFNgNULLɂĂ */
    image->texture = NULL;

    return obj;
}


/*--------------------------------------------------------------------
    C[W̃f[^ݒ(pbox`)
 ---------------------------------------------------------------------*/
static void fill( int x1, int y1, int x2, int y2, int col, struct DXRubyImage *image )
{
    D3DLOCKED_RECT texrect;
    int x, y;
    RECT rect;
    int *p;

    rect.left = x1 + image->x;
    rect.top = y1 + image->y;
    rect.right = x2 + image->x + 1;
    rect.bottom = y2 + image->y + 1;
    image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &texrect, &rect, 0 );
    for( y = 0; y <= y2 - y1; y++ )
    {
        p = (int*)((char *)texrect.pBits + y * texrect.Pitch);
        for( x = 0; x <= x2 - x1; x++ )
        {
            *(p++) = col;
        }
    }
    image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );
    return;
}


/*--------------------------------------------------------------------
    z񂩂F擾
 ---------------------------------------------------------------------*/
int array2color( VALUE color )
{
    int col;

    Check_Type(color, T_ARRAY);

    if( RARRAY_LEN( color ) == 3 )
    {
        col = D3DCOLOR_ARGB(255, NUM2INT(rb_ary_entry(color, 0)), NUM2INT(rb_ary_entry(color, 1)), NUM2INT(rb_ary_entry(color, 2)));
    }
    else
    {
        col = D3DCOLOR_ARGB(NUM2INT(rb_ary_entry(color, 0)), NUM2INT(rb_ary_entry(color, 1)), 
                            NUM2INT(rb_ary_entry(color, 2)), NUM2INT(rb_ary_entry(color, 3)));
    }
    return col;
}


/*--------------------------------------------------------------------
   ImageNXInitialize
 ---------------------------------------------------------------------*/
VALUE Image_initialize( int argc, VALUE *argv, VALUE obj )
{
    struct DXRubyImage *image;
    struct DXRubyTexture *texture;
    HRESULT hr;
    D3DSURFACE_DESC desc;
    VALUE vwidth, vheight, vary;
    int col = 0, width, height;

    g_iRefAll++;

    rb_scan_args( argc, argv, "21", &vwidth, &vheight, &vary );

    width = NUM2INT( vwidth );
    height = NUM2INT( vheight );

    if( width <= 0 || height <= 0 )
    {
        rb_raise( eDXRubyError, "ImageIuWFNg̍쐬Ɏs܂ - Image_initialize" );
    }

    if( vary != Qnil )
    {
        Check_Type( vary, T_ARRAY );
        col = array2color( vary );
    }

    /* eNX`擾 */
    texture = (struct  DXRubyTexture *)malloc( sizeof( struct DXRubyTexture ) );

    if( texture == NULL )
    {
        rb_raise( eDXRubyError, "摜p̎擾Ɏs܂ - Image_initialize" );
    }

    /* eNX`IuWFNg쐬 */
    hr = D3DXCreateTexture( g_pD3DDevice, width, height,
                                      1, 0, D3DFMT_A8R8G8B8, D3DPOOL_MANAGED,
                                      &texture->pD3DTexture);

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "eNX`̍쐬Ɏs܂ - Image_initialize" );
    }

    texture->refcount = 1;

    texture->pD3DTexture->lpVtbl->GetLevelDesc(texture->pD3DTexture, 0, &desc );
    texture->width = desc.Width;
    texture->height = desc.Height;

    /* ImageIuWFNgݒ */
    Data_Get_Struct( obj, struct DXRubyImage, image );

    image->texture = texture;
    image->x = 0;
    image->y = 0;
    image->width = width;
    image->height = height;

    fill( 0, 0, width - 1, height - 1, col, image );

    return obj;
}


/*--------------------------------------------------------------------
   ImageNXload
 ---------------------------------------------------------------------*/
static VALUE Image_load( int argc, VALUE *argv, VALUE klass )
{
    struct DXRubyImage *image;
    struct DXRubyTexture *texture;
    D3DXIMAGE_INFO srcinfo;
    D3DSURFACE_DESC desc;
    HRESULT hr;
    VALUE vfilename, vx, vy, vwidth, vheight, obj, vsjisstr;
    int x, y, width, height;

    /* foCXIuWFNg̏`FbN */
    if( g_pD3DDevice == NULL )
    {
        rb_raise( eDXRubyError, "DirectX GraphicsĂ܂" );
    }

    rb_scan_args( argc, argv, "14", &vfilename, &vx, &vy, &vwidth, &vheight );

    Check_Type(vfilename, T_STRING);

    /* t@C擾 */
#ifdef HAVE_RB_ENC_STR_NEW
    if( rb_enc_get_index( vfilename ) != 0 )
    {
        vsjisstr = rb_funcall( vfilename, rb_intern( "encode" ), 1, rb_str_new2( sys_encode ) );
    }
    else
    {
        vsjisstr = vfilename;
    }
#else
    vsjisstr = vfilename;
#endif

    hr = D3DXGetImageInfoFromFile( RSTRING_PTR( vsjisstr ), &srcinfo );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "t@C̓ǂݍ݂Ɏs܂ - %s", RSTRING_PTR( vsjisstr ) );
    }

    if( vx == Qnil )
    {
        x = 0;
        y = 0;
        width = srcinfo.Width;
        height = srcinfo.Height;
    }
    else
    {
        x = NUM2INT( vx );
        y = vy == Qnil ? 0 : NUM2INT( vy );
        if( x < 0 || x >= srcinfo.Width || y < 0 || y >= srcinfo.Height )
        {
            rb_raise( eDXRubyError, "摜̌_ʒuُlł(x=%d,y=%d, tex_width=%d,tex_height=%d) - Image_load", x, y, srcinfo.Width, srcinfo.Height );
        }
        width = vwidth == Qnil ? srcinfo.Width - x : NUM2INT( vwidth );
        height = vheight == Qnil ? srcinfo.Height - y : NUM2INT( vheight );
        if( srcinfo.Width - x < width || x + width > srcinfo.Width || srcinfo.Height - y < height || y + height > srcinfo.Height ||
            width < 0 || height < 0 )
        {
            rb_raise( eDXRubyError, "摜̃TCYُlł - Image_load" );
        }
    }

    /* eNX`[h */
    texture = Image_textureload( RSTRING_PTR( vsjisstr ), &srcinfo );
    texture->refcount = 1;

    texture->pD3DTexture->lpVtbl->GetLevelDesc(texture->pD3DTexture, 0, &desc );
    texture->width = desc.Width;
    texture->height = desc.Height;

    /* ImageIuWFNgݒ */
    image = malloc(sizeof(struct DXRubyImage));
    if( image == NULL ) rb_raise( eDXRubyError, "̎擾Ɏs܂ - Image_load" );
    obj = Data_Wrap_Struct(cImage, 0, Image_release, image);

    image->texture = texture;
    image->x = x;
    image->y = y;
    image->width = width;
    image->height = height;

    g_iRefAll++;

    return obj;
}


/*--------------------------------------------------------------------
   ImageNXloadFromFileInMemory
 ---------------------------------------------------------------------*/
static VALUE Image_loadFromFileInMemory( VALUE klass, VALUE vstr )
{
    struct DXRubyImage *image;
    struct DXRubyTexture *texture;
    D3DXIMAGE_INFO srcinfo;
    D3DSURFACE_DESC desc;
    HRESULT hr;
    VALUE obj;
    int size, x, y, width, height;

    /* foCXIuWFNg̏`FbN */
    if( g_pD3DDevice == NULL )
    {
        rb_raise( eDXRubyError, "DirectX GraphicsĂ܂" );
    }

    Check_Type(vstr, T_STRING);

    /* t@C擾 */
    size = RSTRING_LEN( vstr );

    hr = D3DXGetImageInfoFromFileInMemory( RSTRING_PTR( vstr ), size, &srcinfo );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "C[Wf[^̓ǂݍ݂Ɏs܂ - Image_loadFromFileInMemory" );
    }

    /* eNX`擾 */
    texture = (struct  DXRubyTexture *)malloc( sizeof( struct DXRubyTexture ) );

    if( texture == NULL )
    {
        rb_raise( eDXRubyError, "摜p̎擾Ɏs܂ - Image_loadFromFileInMemory" );
    }

    /* t@CǂݍŃeNX`IuWFNg쐬 */
    hr = D3DXCreateTextureFromFileInMemoryEx( g_pD3DDevice, RSTRING_PTR( vstr ), size, srcinfo.Width, srcinfo.Height, 1, 0, D3DFMT_A8R8G8B8, D3DPOOL_MANAGED,
                                      D3DX_DEFAULT,  D3DX_DEFAULT, 0,
                                      0, 0, &texture->pD3DTexture);

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "C[Wf[^̓ǂݍ݂Ɏs܂ - Image_loadFromFileInMemory" );
    }

    texture->refcount = 1;

    texture->pD3DTexture->lpVtbl->GetLevelDesc(texture->pD3DTexture, 0, &desc );
    texture->width = desc.Width;
    texture->height = desc.Height;

    /* ImageIuWFNgݒ */
    image = malloc(sizeof(struct DXRubyImage));
    if( image == NULL ) rb_raise( eDXRubyError, "̎擾Ɏs܂ - Image_loadFromFileInMemory" );
    obj = Data_Wrap_Struct(cImage, 0, Image_release, image);

    image->texture = texture;
    image->x = 0;
    image->y = 0;
    image->width = srcinfo.Width;
    image->height = srcinfo.Height;

    g_iRefAll++;

    return obj;
}


/*--------------------------------------------------------------------
   ImageIuWFNg̕쐬
 ---------------------------------------------------------------------*/
static VALUE Image_loadToArray( int argc, VALUE *argv, VALUE klass )
{
    VALUE vfilename, vx, vy, vswitch;
    VALUE vimage, ary[3];

    rb_scan_args( argc, argv, "31", &vfilename, &vx, &vy, &vswitch );

    vimage = Image_load( 1, &vfilename, cImage );
    ary[0] = vx;
    ary[1] = vy;
    ary[2] = vswitch;
    return Image_sliceToArray( 3, ary, vimage );
}


/*--------------------------------------------------------------------
   z񂩂C[W
 ---------------------------------------------------------------------*/
static VALUE Image_createFromArray( VALUE klass, VALUE vwidth, VALUE vheight, VALUE array )
{
    struct DXRubyImage *image;
    struct DXRubyTexture *texture;
    HRESULT hr;
    int i, j, x, y;
    D3DLOCKED_RECT LockedRect;
    VALUE obj;
    int width, height;
    D3DSURFACE_DESC desc;

    /* foCXIuWFNg̏`FbN */
    if( g_pD3DDevice == NULL )
    {
        rb_raise( eDXRubyError, "DirectX GraphicsĂ܂" );
    }

    width = NUM2INT( vwidth );
    height = NUM2INT( vheight );
    Check_Type(array, T_ARRAY);

    if( width <= 0 || height <= 0 ) rb_raise( eDXRubyError, "摜̃TCYw肪ُlł(width=%d,height=%d) - Image_loadToArray", width, height );

    /* eNX`擾 */
    texture = (struct  DXRubyTexture *)malloc( sizeof( struct DXRubyTexture ) );
    if( texture == NULL )
    {
        rb_raise( eDXRubyError, "摜p̎擾Ɏs܂ - Image_textureload" );
    }

    /* eNX`TCYo */
    for( x = 1; x < width;  x = x * 2 );
    for( y = 1; y < height; y = y * 2 );

    /* eNX`IuWFNg쐬 */
    hr = D3DXCreateTexture( g_pD3DDevice, x, y,
                            1, 0, D3DFMT_A8R8G8B8, D3DPOOL_MANAGED,
                            &texture->pD3DTexture);
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "eNX`̍쐬Ɏs܂ - Image_initialize" );
    }

    /* eNX`bN */
    hr = texture->pD3DTexture->lpVtbl->LockRect( texture->pD3DTexture, 0, &LockedRect, NULL, 0 );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "T[tFCX̃bNɎs܂ - LockRect" );
    }

    /*  */
    for( i = 0; i < height; i++ )
    {
        for( j = 0; j < width * 4; j += 4 )
        {
            int a1 = NUM2INT(rb_ary_entry(array, j + i * width * 4));
            int a2 = NUM2INT(rb_ary_entry(array, j + i * width * 4 + 1));
            int a3 = NUM2INT(rb_ary_entry(array, j + i * width * 4 + 2));
            int a4 = NUM2INT(rb_ary_entry(array, j + i * width * 4 + 3));
            *((int*)((char *)LockedRect.pBits + j + i * LockedRect.Pitch)) = D3DCOLOR_ARGB(a1, a2, a3, a4);
        }
    }

    /* eNX`AbN */
    texture->pD3DTexture->lpVtbl->UnlockRect( texture->pD3DTexture, 0 );

    texture->refcount = 1;
    texture->pD3DTexture->lpVtbl->GetLevelDesc( texture->pD3DTexture, 0, &desc );
    texture->width = desc.Width;
    texture->height = desc.Height;

    /* DXRubyImagẽ擾ImageIuWFNg */
    image = malloc(sizeof(struct DXRubyImage));
    if( image == NULL ) rb_raise( eDXRubyError, "̎擾Ɏs܂ - Image_createFromArray" );
    obj = Data_Wrap_Struct(cImage, 0, Image_release, image);

    image->texture = texture;
    image->x = 0;
    image->y = 0;
    image->width = width;
    image->height = height;

    g_iRefAll++;

    return obj;
}


/*--------------------------------------------------------------------
   ImageIuWFNgslice
 ---------------------------------------------------------------------*/
static VALUE Image_slice_instance( int argc, VALUE *argv, VALUE vsrcimage )
{
    struct DXRubyImage *srcimage;
    struct DXRubyImage *image;
    struct DXRubyTexture *texture;
    D3DXIMAGE_INFO srcinfo;
    HRESULT hr;
    VALUE vx, vy, vwidth, vheight, obj;
    int x, y, width, height;

    rb_scan_args( argc, argv, "04", &vx, &vy, &vwidth, &vheight );

    Data_Get_Struct( vsrcimage, struct DXRubyImage, srcimage );
    DXRUBY_CHECK_DISPOSE( srcimage, texture );

    if( vx == Qnil )
    {
        x = 0;
        y = 0;
        width = srcimage->width;
        height = srcimage->height;
    }
    else
    {
        x = NUM2INT( vx );
        y = vy == Qnil ? 0 : NUM2INT( vy );
        if( x < 0 || x >= srcimage->width || y < 0 || y >= srcimage->height )
        {
            rb_raise( eDXRubyError, "摜̌_ʒuُlł(x=%d,y=%d, tex_width=%d,tex_height=%d) - Image_slice", x, y, srcimage->width, srcimage->height );
        }
        width = vwidth == Qnil ? srcimage->width - x : NUM2INT( vwidth );
        height = vheight == Qnil ? srcimage->height - y : NUM2INT( vheight );
        if( srcimage->width - x < width || x + width > srcimage->width || srcimage->height - y < height || y + height > srcimage->height ||
            width < 0 || height < 0 )
        {
            rb_raise( eDXRubyError, "摜̃TCYُlł - Image_slice" );
        }
    }

    /* eNX`[h */
    texture = srcimage->texture;
    texture->refcount += 1;

    /* ImageIuWFNgݒ */
    image = malloc(sizeof(struct DXRubyImage));
    if( image == NULL ) rb_raise( eDXRubyError, "̎擾Ɏs܂ - Image_slice" );
    obj = Data_Wrap_Struct(cImage, 0, Image_release, image);

    image->texture = texture;
    image->x = x + srcimage->x;
    image->y = y + srcimage->y;
    image->width = width;
    image->height = height;

    g_iRefAll++;

    /* ImagẽRs[ */
    return Image_initialize_copy( Image_allocate( cImage ), obj );
}


/*--------------------------------------------------------------------
   ImgaeIuWFNgsliceToArray
 ---------------------------------------------------------------------*/
VALUE Image_sliceToArray( int argc, VALUE *argv, VALUE self )
{
    struct DXRubyImage *srcimage;
    struct DXRubyTexture *texture;
    HRESULT hr;
    int x, y, i, j;
    VALUE array, obj;
    VALUE vx, vy, vswitch;

    rb_scan_args( argc, argv, "21", &vx, &vy, &vswitch );

    x = NUM2INT( vx );
    y = NUM2INT( vy );

    if( x <= 0 || y <= 0 ) rb_raise( eDXRubyError, "摜̐w肪ُlł(x=%d,y=%d) - Image_sliceToArray", x, y );

    /* Imagẽ`FbN */
    Data_Get_Struct( self, struct DXRubyImage, srcimage );
    DXRUBY_CHECK_DISPOSE( srcimage, texture );

    /* ImagẽRs[ */
    obj = Image_initialize_copy( Image_allocate( cImage ), self );

    /* Rs[Imageslice */
    Data_Get_Struct( obj, struct DXRubyImage, srcimage );
    DXRUBY_CHECK_DISPOSE( srcimage, texture );

    texture = srcimage->texture;
    texture->refcount += x * y;

    /* Rubyz쐬 */
    array = rb_ary_new();

    if( RTEST(vswitch) )
    {
        for( i = 0; i < y; i++ )
        {
            for( j = 0; j < x; j++ )
            {
                /* DXRubyImagẽ擾ImageIuWFNg */
                struct DXRubyImage *image = malloc(sizeof(struct DXRubyImage));
                if( image == NULL ) rb_raise( eDXRubyError, "̎擾Ɏs܂ - Image_sliceToArray" );
                obj = Data_Wrap_Struct(cImage, 0, Image_release, image);

                image->texture = texture;
                image->x = srcimage->x + j * srcimage->width / x;
                image->y = srcimage->y + i * srcimage->height / y;
                image->width = srcimage->width / x;
                image->height = srcimage->height / y;

                rb_ary_push( array, obj );
                g_iRefAll++;
            }
        }
    }
    else
    {
        for( i = 0; i < y; i++ )
        {
            for( j = 0; j < x; j++ )
            {
                VALUE ary[4] = {INT2FIX(srcimage->x + j * srcimage->width / x),
                                INT2FIX(srcimage->y + i * srcimage->height / y),
                                INT2FIX(srcimage->width / x),
                                INT2FIX(srcimage->height / y)};
                rb_ary_push( array, Image_slice_instance( 4, ary, obj ) );
            }
        }
    }
    return array;
}


/*--------------------------------------------------------------------
   C[W̃f[^擾
 ---------------------------------------------------------------------*/
static VALUE Image_getPixel( VALUE obj, VALUE vx, VALUE vy )
{
    struct DXRubyImage *image;
    VALUE ary[4];
    struct DXRubyColor a;
    D3DLOCKED_RECT texrect;
    int x, y;
    RECT rect;

    x = NUM2INT( vx );
    y = NUM2INT( vy );

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    if( x < 0 || x >= image->width || y < 0 || y >= image->height )
    {
        ary[0] = ary[1] = ary[2] = ary[3] = INT2FIX( 0 );
        return rb_ary_new4( 4, ary );
    }

    rect.left = x + image->x;
    rect.top = y + image->y;
    rect.right = x + image->x + 1;
    rect.bottom = y + image->y + 1;
    image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &texrect, &rect, D3DLOCK_READONLY );

    a = *(struct DXRubyColor *)texrect.pBits;

    image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );

    ary[0] = INT2FIX( a.alpha );
    ary[1] = INT2FIX( a.red );
    ary[2] = INT2FIX( a.green );
    ary[3] = INT2FIX( a.blue );

    return rb_ary_new4( 4, ary );
}


/*--------------------------------------------------------------------
   C[W̃f[^ݒ
 ---------------------------------------------------------------------*/
static VALUE Image_setPixel( VALUE obj, VALUE vx, VALUE vy, VALUE color )
{
    struct DXRubyImage *image;
    int a1, a2, a3, a4;
    D3DLOCKED_RECT texrect;
    int x, y;
    RECT rect;

    x = NUM2INT( vx );
    y = NUM2INT( vy );
    Check_Type(color, T_ARRAY);

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    if( x < 0 || x >= image->width || y < 0 || y >= image->height )
    {
        return obj;
    }

    rect.left = x + image->x;
    rect.top = y + image->y;
    rect.right = x + image->x + 1;
    rect.bottom = y + image->y + 1;
    image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &texrect, &rect, 0 );

    *((int*)((char *)texrect.pBits)) = array2color( color );

    image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );

    return color;
}


/*--------------------------------------------------------------------
   C[W̐Fr
 ---------------------------------------------------------------------*/
static VALUE Image_compare( VALUE obj, VALUE vx, VALUE vy, VALUE color )
{
    struct DXRubyImage *image;
    DWORD a;
    D3DLOCKED_RECT texrect;
    int x, y, col;
    int a1, a2, a3, a4;
    RECT rect;

    x = NUM2INT( vx );
    y = NUM2INT( vy );
    Check_Type(color, T_ARRAY);

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    if( x < 0 || x >= image->width || y < 0 || y >= image->height )
    {
        return INT2FIX( 0 );
    }

    col = array2color( color );

    rect.left = x + image->x;
    rect.top = y + image->y;
    rect.right = x + image->x + 1;
    rect.bottom = y + image->y + 1;
    image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &texrect, &rect, D3DLOCK_READONLY );

    a = *(LPDWORD)texrect.pBits;

    image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );

    if( RARRAY_LEN( color ) == 3 )
    {
        
        if( (a & 0x00ffffff) == ((DWORD)col & 0x00ffffff) )
        {
            return Qtrue;
        }
        else
        {
            return Qfalse;
        }
    }
    else
    {
        if( a == (DWORD)col )
        {
            return Qtrue;
        }
        else
        {
            return Qfalse;
        }
    }
}


/*--------------------------------------------------------------------
    C[W̃f[^ݒ(box`hԂȂ)
 ---------------------------------------------------------------------*/
static VALUE Image_box( VALUE obj, VALUE vx1, VALUE vy1, VALUE vx2, VALUE vy2, VALUE color )
{
    struct DXRubyImage *image;
    D3DLOCKED_RECT texrect;
    int x, y, x1, y1, x2, y2;
    int col;
    RECT rect;

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    x1 = NUM2INT( vx1 );
    y1 = NUM2INT( vy1 );
    x2 = NUM2INT( vx2 );
    y2 = NUM2INT( vy2 );

    /* ォE̎wɏC */
    if( x1 > x2 )
    {
        x = x2;
        x2 = x1;
        x1 = x;
    }
    if( y1 > y2 )
    {
        y = y2;
        y2 = y1;
        y1 = y;
    }

    /* ͈͊O̎w͖ */
    if( x1 > image->width - 1 || x2 < 0 || y1 > image->height - 1 || y2 < 0)
    {
        return obj;
    }

    /* Nbv */
    if( x1 < 0 )
    {
        x1 = 0;
    }
    if( x2 > image->width - 1 )
    {
        x2 = image->width - 1;
    }
    if( y1 < 0 )
    {
        y1 = 0;
    }
    if( y2 > image->height - 1 )
    {
        y2 = image->height - 1;
    }

    Check_Type(color, T_ARRAY);
    col = array2color( color );

    rect.left = x1 + image->x;
    rect.top = y1 + image->y;
    rect.right = x2 + image->x + 1;
    rect.bottom = y2 + image->y + 1;
    image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &texrect, &rect, 0 );
    for( y = 0; y <= y2 - y1; y++ )
    {
        *((int*)((char *)texrect.pBits + y * texrect.Pitch)) = col;
        *((int*)((char *)texrect.pBits + (x2 - x1)* 4 + y * texrect.Pitch)) = col;
    }
    for( x = 0; x <= x2 - x1; x++ )
    {
        *((int*)((char *)texrect.pBits + x * 4)) = col;
        *((int*)((char *)texrect.pBits + x * 4 + (y2 - y1) * texrect.Pitch)) = col;
    }
    image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );

    return obj;
}


/*--------------------------------------------------------------------
    C[W̃f[^ݒ(box`hԂ)
 ---------------------------------------------------------------------*/
static VALUE Image_boxFill( VALUE obj, VALUE vx1, VALUE vy1, VALUE vx2, VALUE vy2, VALUE color )
{
    struct DXRubyImage *image;
    int x, y, x1, y1, x2, y2;
    int col;

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    x1 = NUM2INT( vx1 );
    y1 = NUM2INT( vy1 );
    x2 = NUM2INT( vx2 );
    y2 = NUM2INT( vy2 );

    /* ォE̎wɏC */
    if( x1 > x2 )
    {
        x = x2;
        x2 = x1;
        x1 = x;
    }
    if( y1 > y2 )
    {
        y = y2;
        y2 = y1;
        y1 = y;
    }

    /* ͈͊O̎w͖ */
    if( x1 > image->width - 1 || x2 < 0 || y1 > image->height - 1 || y2 < 0)
    {
        return obj;
    }

    /* Nbv */
    if( x1 < 0 )
    {
        x1 = 0;
    }
    if( x2 > image->width - 1 )
    {
        x2 = image->width - 1;
    }
    if( y1 < 0 )
    {
        y1 = 0;
    }
    if( y2 > image->height - 1 )
    {
        y2 = image->height - 1;
    }

    Check_Type(color, T_ARRAY);
    col = array2color( color );

    fill( x1, y1, x2, y2, col, image );

    return obj;
}


/*--------------------------------------------------------------------
    C[W̃f[^ݒ(SFœhԂ)
 ---------------------------------------------------------------------*/
static VALUE Image_clear( VALUE obj )
{
    struct DXRubyImage *image;

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    fill( 0, 0, image->width-1, image->height-1, 0, image );

    return obj;
}


/*--------------------------------------------------------------------
    C[W̃f[^ݒ(ShԂ)
 ---------------------------------------------------------------------*/
static VALUE Image_fill( VALUE obj, VALUE color )
{
    struct DXRubyImage *image;
    int col;

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    Check_Type(color, T_ARRAY);
    col = array2color( color );

    fill( 0, 0, image->width-1, image->height-1, col, image );

    return obj;
}


/*--------------------------------------------------------------------
    C[W̃J[L[ݒB͎̂wF𓧖ɁB
 ---------------------------------------------------------------------*/
static VALUE Image_setColorKey( VALUE obj, VALUE color )
{
    struct DXRubyImage *image;
    int col;
    D3DLOCKED_RECT texrect;
    int x, y;
    RECT rect;
    int *p;

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    Check_Type(color, T_ARRAY);
    col = array2color( color ) & 0x00ffffff;

    rect.left = image->x;
    rect.top = image->y;
    rect.right = image->x + image->width;
    rect.bottom = image->y + image->height;
    image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &texrect, &rect, 0 );
    for( y = 0; y < image->height; y++ )
    {
        p = (int*)((char *)texrect.pBits + y * texrect.Pitch);
        for( x = 0; x < image->width; x++ )
        {
            if( (*p & 0x00ffffff) == col )
            {
                *p = col;
            }
            p++;
        }
    }
    image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );

    return obj;
}


/*--------------------------------------------------------------------
    C[W̃f[^ݒ(circlepline`)
 ---------------------------------------------------------------------*/
static void Image_circle_line( int x1, int x2, int y, RECT *rect, int col, D3DLOCKED_RECT *texrect )
{
    int x;
    int *p;

    if( y < 0 || y >= rect->bottom - rect->top )
    {
        return;
    }

    /* Nbv */
    if( x1 < 0 )
    {
        x1 = 0;
    }
    if( x2 > rect->right - rect->left - 1 )
    {
        x2 = rect->right - rect->left - 1;
    }
    if( x1 > x2 )
    {
        return;
    }

    p = (int*)((char *)texrect->pBits + y * texrect->Pitch + x1 * 4);
    for( x = 0; x <= x2 - x1; x++ )
    {
        *(p++) = col;
    }
}


/*--------------------------------------------------------------------
    C[W̃f[^ݒ(circle`hԂ)
 ---------------------------------------------------------------------*/
static VALUE Image_circleFill( VALUE obj, VALUE vx0, VALUE vy0, VALUE vr, VALUE color )
{
    struct DXRubyImage *image;
    int x0, y0, F, x, y;
    float r;
    int col;
    D3DLOCKED_RECT texrect;
    RECT rect;
    HRESULT hr;
    int tempx, tempy;

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    x0 = NUM2INT( vx0 );
    y0 = NUM2INT( vy0 );
    r  = NUM2FLOAT( vr );

    Check_Type(color, T_ARRAY);
    col = array2color( color );

    rect.left = x0 < r ? image->x : x0 + image->x - r;
    rect.top = y0 < r ? image->y : y0 + image->y - r;
    rect.right = x0 + r >= image->width ? image->x + image->width : x0 + image->x + r + 1;
    rect.bottom = y0 + r >= image->height ? image->y + image->height : y0 + image->y + r + 1;
    if( rect.left >= rect.right || rect.top >= rect.bottom )
    {
        return obj;
    }

    hr = image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &texrect, &rect, 0 );

    {//http://dencha.ojaru.jp/programs_07/pg_graphic_09a2.html
        int tempx = -rect.left + (int)image->x;
        int tempy = -rect.top + (int)image->y;
        int xm = x0, ym = y0;
        int diameter = r*2;

        LONG    cx = 0, cy=diameter/2+1;
        double d;
        int dx, dy;
        d = -diameter*diameter + 4*cy*cy -4*cy +2;
        dx = 4;
        dy = -8*cy+8;
        if( (diameter & 1) == 0 )
        {
            xm--;
            ym--;
        }

        for( cx = 0; cx <= cy; cx++ )
        {
            if( d > 0 )
            {
                d += dy;
                dy += 8;
                cy--;
            }
            Image_circle_line( tempx - cx + x0, tempx + cx + xm, tempy - cy + y0, &rect, col, &texrect );
            Image_circle_line( tempx - cy + x0, tempx + cy + xm, tempy - cx + y0, &rect, col, &texrect );
            Image_circle_line( tempx - cy + x0, tempx + cy + xm, tempy + cx + ym, &rect, col, &texrect );
            Image_circle_line( tempx - cx + x0, tempx + cx + xm, tempy + cy + ym, &rect, col, &texrect );

            d += dx;
            dx+=8;
        }
    }

    image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );

    return obj;
}


/*--------------------------------------------------------------------
    C[W̃f[^ݒ(ppixel`)
 ---------------------------------------------------------------------*/
static void Image_circle_pixel( int x, int y, RECT *rect, int col, D3DLOCKED_RECT *texrect )
{
    if( x < 0 || x >= rect->right - rect->left || y < 0 || y >= rect->bottom - rect->top )
    {
        return;
    }

    *((int*)((char *)texrect->pBits + x * 4 + y * texrect->Pitch)) = col;

    return;
}


/*--------------------------------------------------------------------
    C[W̃f[^ݒ(circle`hԂȂ)
 ---------------------------------------------------------------------*/
static VALUE Image_circle( VALUE obj, VALUE vx0, VALUE vy0, VALUE vr, VALUE color )
{
    struct DXRubyImage *image;
    D3DLOCKED_RECT texrect;
    int x0, y0, F, x, y;
    float r;
    int col;
    RECT rect;

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    x0 = NUM2INT( vx0 );
    y0 = NUM2INT( vy0 );
    r  = NUM2FLOAT( vr );

    Check_Type(color, T_ARRAY);
    col = array2color( color );

    rect.left = x0 < r ? image->x : x0 + image->x - r;
    rect.top = y0 < r ? image->y : y0 + image->y - r;
    rect.right = x0 + r >= image->width ? image->x + image->width : x0 + image->x + r + 1;
    rect.bottom = y0 + r >= image->height ? image->y + image->height : y0 + image->y + r + 1;
    if( rect.left >= rect.right || rect.top >= rect.bottom )
    {
        return obj;
    }

    image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &texrect, &rect, 0 );

    {//http://dencha.ojaru.jp/programs_07/pg_graphic_09a2.html
        int tempx = -rect.left + (int)image->x;
        int tempy = -rect.top + (int)image->y;
        int xm = x0, ym = y0;
        int diameter = r*2;

        LONG    cx = 0, cy=diameter/2+1;
        double d;
        int dx, dy;
        d = -diameter*diameter + 4*cy*cy -4*cy +2;
        dx = 4;
        dy = -8*cy+8;
        if( (diameter & 1) == 0 )
        {
            xm--;
            ym--;
        }

        for( cx = 0; cx <= cy; cx++ )
        {
            if( d > 0 )
            {
                d += dy;
                dy += 8;
                cy--;
            }
            Image_circle_pixel( tempx - cy + x0, tempy - cx + y0, &rect, col, &texrect );
            Image_circle_pixel( tempx - cx + x0, tempy - cy + y0, &rect, col, &texrect );

            Image_circle_pixel( tempx + cx + xm, tempy - cy + y0, &rect, col, &texrect );
            Image_circle_pixel( tempx + cy + xm, tempy - cx + y0, &rect, col, &texrect );

            Image_circle_pixel( tempx + cy + xm, tempy + cx + ym, &rect, col, &texrect );
            Image_circle_pixel( tempx + cx + xm, tempy + cy + ym, &rect, col, &texrect );

            Image_circle_pixel( tempx - cx + x0, tempy + cy + ym, &rect, col, &texrect );
            Image_circle_pixel( tempx - cy + x0, tempy + cx + ym, &rect, col, &texrect );

            d += dx;
            dx+=8;
        }
    }

    image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );

    return obj;
}


/*--------------------------------------------------------------------
    C[W̃f[^ݒ(line`)
 ---------------------------------------------------------------------*/
static VALUE Image_line( VALUE obj, VALUE vx1, VALUE vy1, VALUE vx2, VALUE vy2, VALUE color )
{
    struct DXRubyImage *image;
    D3DLOCKED_RECT texrect;
    int x1, y1, x2, y2, xp, yp;
    int col;
    int c, d, dx, dy, i;
    RECT rect;

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    x1 = NUM2INT( vx1 );
    y1 = NUM2INT( vy1 );
    x2 = NUM2INT( vx2 );
    y2 = NUM2INT( vy2 );

    Check_Type(color, T_ARRAY);
    col = array2color( color );

    rect.left = (x1 < x2 ? x1 : x2) < image->x ? image->x : (x1 < x2 ? x1 : x2);
    rect.top = (y1 < y2 ? y1 : y2) < image->y ? image->y : (y1 < y2 ? y1 : y2);
    rect.right = (x1 > x2 ? x1 : x2) >= image->width ? image->x + image->width : image->x + (x1 > x2 ? x1 : x2) + 1;
    rect.bottom = (y1 > y2 ? y1 : y2) >= image->height ? image->y + image->height : image->y + (y1 > y2 ? y1 : y2) + 1;
    if( rect.left >= rect.right || rect.top >= rect.bottom )
    {
        return obj;
    }

    x1 = x1 - rect.left + image->x;
    x2 = x2 - rect.left + image->x;
    y1 = y1 - rect.top + image->y;
    y2 = y2 - rect.top + image->y;

    image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &texrect, &rect, 0 );

    dx = x2 > x1 ? x2 - x1 : x1 - x2;
    dy = y2 > y1 ? y2 - y1 : y1 - y2;

    /* u[nASYɂ` */
    if( dx < dy )
    {
        xp = x1 < x2 ? 1 : -1;
        d = y1 < y2 ? 1 : -1;
        c = dy;
        for( i = 0; i <= dy; i++ )
        {
            if( x1 >= 0 && x1 < (int)rect.right - rect.left  && y1 >= 0 && y1 < (int)rect.bottom - rect.top )
            {
                *((int*)((char *)texrect.pBits + x1 * 4 + y1  * texrect.Pitch)) = col;
            }
            y1 = y1 + d;
            c = c + dx*2;
            if( c >= dy*2 )
            {
                c = c - dy*2;
                x1 = x1 + xp;
            }
        }
    }
    else
    {
        yp = y1 < y2 ? 1 : -1;
        d = x1 < x2 ? 1 : -1;
        c = dx;
        for( i = 0; i <= dx; i++ )
        {
            if( x1 >= 0 && x1 < (int)rect.right - rect.left  && y1 >= 0 && y1 < (int)rect.bottom - rect.top )
            {
                *((int*)((char *)texrect.pBits + x1 * 4 + y1  * texrect.Pitch)) = col;
            }
            x1 = x1 + d;
            c = c + dy*2;
            if( c >= dx*2 )
            {
                c = c - dx*2;
                y1 = y1 + yp;
            }
        }
    }

    image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );

    return obj;
}


/*--------------------------------------------------------------------
    C[WOp``
 ---------------------------------------------------------------------*/
static VALUE Image_triangle( VALUE obj, VALUE vx1, VALUE vy1, VALUE vx2, VALUE vy2, VALUE vx3, VALUE vy3, VALUE color )
{
    Image_line( obj, vx1, vy1, vx2, vy2, color );
    Image_line( obj, vx2, vy2, vx3, vy3, color );
    Image_line( obj, vx3, vy3, vx1, vy1, color );

    return obj;
}


static void Image_triangle_line( int x1, int y1, int x2, int y2, int *buf_x_min, int *buf_x_max, RECT *rect )
{
    int dx, dy, c, d, xp, yp, i;

    dx = x2 > x1 ? x2 - x1 : x1 - x2;
    dy = y2 > y1 ? y2 - y1 : y1 - y2;

    /* u[nASYɂ` */
    if( dx < dy )
    {
        xp = x1 < x2 ? 1 : -1;
        d = y1 < y2 ? 1 : -1;
        c = dy;
        for( i = 0; i <= dy; i++ )
        {
            if( y1 >= 0 && y1 < (int)rect->bottom - rect->top )
            {
                if( x1 < buf_x_min[y1] )
                {
                    buf_x_min[y1] = x1;
                }
                if( x1 > buf_x_max[y1] )
                {
                    buf_x_max[y1] = x1;
                }
            }
            y1 = y1 + d;
            c = c + dx*2;
            if( c >= dy*2 )
            {
                c = c - dy*2;
                x1 = x1 + xp;
            }
        }
    }
    else
    {
        yp = y1 < y2 ? 1 : -1;
        d = x1 < x2 ? 1 : -1;
        c = dx;
        for( i = 0; i <= dx; i++ )
        {
            if( y1 >= 0 && y1 < (int)rect->bottom - rect->top )
            {
                if( x1 < buf_x_min[y1] )
                {
                    buf_x_min[y1] = x1;
                }
                if( x1 > buf_x_max[y1] )
                {
                    buf_x_max[y1] = x1;
                }
            }
            x1 = x1 + d;
            c = c + dy*2;
            if( c >= dx*2 )
            {
                c = c - dx*2;
                y1 = y1 + yp;
            }
        }
    }
}

/*--------------------------------------------------------------------
    C[WOp``(hԂ)
 ---------------------------------------------------------------------*/
static VALUE Image_triangle_fill( VALUE obj, VALUE vx1, VALUE vy1, VALUE vx2, VALUE vy2, VALUE vx3, VALUE vy3, VALUE color )
{
    struct DXRubyImage *image;
    D3DLOCKED_RECT texrect;
    int x[3], y[3]; /* _ */
    int col;
    RECT rect;
    int i;
    int xv1, yv1, xv2, yv2; /* E{[ */

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    x[0] = NUM2INT( vx1 );
    y[0] = NUM2INT( vy1 );
    x[1] = NUM2INT( vx2 );
    y[1] = NUM2INT( vy2 );
    x[2] = NUM2INT( vx3 );
    y[2] = NUM2INT( vy3 );

    Check_Type(color, T_ARRAY);
    col = array2color( color );

    /* eNX`bNpE{[쐬 */
    xv1 = xv2 = x[2];
    yv1 = yv2 = y[2];
    for( i = 0; i < 2; i++ )
    {
        if( xv1 > x[i] )
        {
            xv1 = x[i];
        }
        if( xv2 < x[i] )
        {
            xv2 = x[i];
        }
        if( yv1 > y[i] )
        {
            yv1 = y[i];
        }
        if( yv2 < y[i] )
        {
            yv2 = y[i];
        }
    }

    rect.left = xv1 < image->x ? image->x : xv1;
    rect.top = yv1 < image->y ? image->y : yv1;
    rect.right = xv2 >= image->width ? image->x + image->width : xv2 + 1;
    rect.bottom = yv2 >= image->height ? image->y + image->height : image->y + yv2 + 1;
    if( rect.left >= rect.right || rect.top >= rect.bottom )
    {
        return obj;
    }

    image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &texrect, &rect, 0 );

    {
        int *buf_x_min, *buf_x_max;
        buf_x_min = alloca( sizeof(int) * (rect.bottom - rect.top) );
        buf_x_max = alloca( sizeof(int) * (rect.bottom - rect.top) );

        for( i = 0; i < rect.bottom - rect.top; i++ )
        {
            buf_x_min[i] = image->width;
            buf_x_max[i] = -1;
        }

        Image_triangle_line( x[0] - rect.left + image->x, y[0] - rect.top + image->y, x[1] - rect.left + image->x, y[1] - rect.top + image->y, buf_x_min, buf_x_max, &rect );
        Image_triangle_line( x[1] - rect.left + image->x, y[1] - rect.top + image->y, x[2] - rect.left + image->x, y[2] - rect.top + image->y, buf_x_min, buf_x_max, &rect );
        Image_triangle_line( x[2] - rect.left + image->x, y[2] - rect.top + image->y, x[0] - rect.left + image->x, y[0] - rect.top + image->y, buf_x_min, buf_x_max, &rect );

        for( i = 0; i < rect.bottom - rect.top; i++ )
        {
//            printf("y = %d, left = %d, right = %d\n", i, buf_x_min[i], buf_x_max[i]);
            Image_circle_line( buf_x_min[i], buf_x_max[i], i, &rect, col, &texrect );
        }
    }

    image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );

    return obj;
}


/*--------------------------------------------------------------------
   C[WIuWFNgԃf[^]
 ---------------------------------------------------------------------*/
static VALUE Image_copyRect( int argc, VALUE *argv, VALUE obj )
{
    struct DXRubyImage *srcimage;
    struct DXRubyImage *dstimage;
    D3DLOCKED_RECT srctrect;
    D3DLOCKED_RECT dsttrect;
    VALUE vx, vy, data, vx1, vy1, vwidth, vheight;
    int x, y, x1, y1, width, height;
    int i, j;
    RECT srcrect;
    RECT dstrect;
    int *psrc;
    int *pdst;

    rb_scan_args( argc, argv, "34", &vx, &vy, &data, &vx1, &vy1, &vwidth, &vheight );

    Data_Get_Struct( obj, struct DXRubyImage, dstimage );
    DXRUBY_CHECK_DISPOSE( dstimage, texture );
    DXRUBY_CHECK_TYPE( Image, data );
    Data_Get_Struct( data, struct DXRubyImage, srcimage );
    DXRUBY_CHECK_DISPOSE( srcimage, texture );

    if( dstimage == srcimage ) rb_raise( eDXRubyError, "`挳ƐɓImageIuWFNgw肳Ă܂ - Image_copyRect" );

    x = NUM2INT( vx );
    y = NUM2INT( vy );
    x1 = vx1 == Qnil ? 0 : NUM2INT( vx1 );
    y1 = vy1 == Qnil ? 0 : NUM2INT( vy1 );
    width = vwidth == Qnil ? srcimage->width - x1 : NUM2INT( vwidth );
    height = vheight == Qnil ? srcimage->height - y1 : NUM2INT( vheight );

    /* 摜̃NbsO */
    if( x < 0 )
    {
        x1 -= x;
        width -= x;
        x = 0;
    }
    if( y < 0 )
    {
        y1 -= y;
        height -= y;
        y = 0;
    }
    if( x1 < 0 )
    {
        x -=x1;
        width -= x1;
        x1 = 0;
    }
    if( y1 < 0 )
    {
        y -=y1;
        height -= y1;
        y1 = 0;
    }
    if( x + width > dstimage->width )
    {
        width -= x + width - dstimage->width;
    }
    if( y + height > dstimage->height )
    {
        height -= y + height - dstimage->height;
    }
    if( x1 + width > srcimage->width )
    {
        width -= x1 + width - srcimage->width;
    }
    if( y1 + height > srcimage->height )
    {
        height -= y1 + height - srcimage->height;
    }

    /* ͈͊O */
    if( x >= dstimage->width || y >= dstimage->height || x1 >= srcimage->width || y1 >= srcimage->height ||
        width < 0 || height < 0 )
    {
        return obj;
    }

    dstrect.left = x + dstimage->x;
    dstrect.top = y + dstimage->y;
    dstrect.right = x + dstimage->x + width;
    dstrect.bottom = y + dstimage->y + height;
    srcrect.left = x1 + srcimage->x;
    srcrect.top = y1 + srcimage->y;
    srcrect.right = x1 + srcimage->x + width;
    srcrect.bottom = y1 + srcimage->y + height;

    dstimage->texture->pD3DTexture->lpVtbl->LockRect( dstimage->texture->pD3DTexture, 0, &dsttrect, &dstrect, 0 );
    srcimage->texture->pD3DTexture->lpVtbl->LockRect( srcimage->texture->pD3DTexture, 0, &srctrect, &srcrect, D3DLOCK_READONLY );

    for( i = 0; i < height; i++)
    {
        psrc = (int*)((char *)srctrect.pBits + i * srctrect.Pitch);
        pdst = (int*)((char *)dsttrect.pBits + i * dsttrect.Pitch);
        for( j = 0; j < width; j++)
        {
            *(pdst++) = *(psrc++);
        }
    }

    dstimage->texture->pD3DTexture->lpVtbl->UnlockRect( dstimage->texture->pD3DTexture, 0 );
    srcimage->texture->pD3DTexture->lpVtbl->UnlockRect( srcimage->texture->pD3DTexture, 0 );

    return obj;
}


/*--------------------------------------------------------------------
   C[WIuWFNgԃf[^]
 ---------------------------------------------------------------------*/
static VALUE Image_draw( int argc, VALUE *argv, VALUE obj )
{
    struct DXRubyImage *srcimage;
    struct DXRubyImage *dstimage;
    D3DLOCKED_RECT srctrect;
    D3DLOCKED_RECT dsttrect;
    VALUE vx, vy, data, vx1, vy1, vwidth, vheight;
    int x, y, x1, y1, width, height;
    int i, j;
    RECT srcrect;
    RECT dstrect;
    int *psrc;
    int *pdst;

    rb_scan_args( argc, argv, "34", &vx, &vy, &data, &vx1, &vy1, &vwidth, &vheight );

    Data_Get_Struct( obj, struct DXRubyImage, dstimage );
    DXRUBY_CHECK_DISPOSE( dstimage, texture );
    DXRUBY_CHECK_TYPE( Image, data );
    Data_Get_Struct( data, struct DXRubyImage, srcimage );
    DXRUBY_CHECK_DISPOSE( srcimage, texture );

    if( dstimage == srcimage ) rb_raise( eDXRubyError, "`挳ƐɓImageIuWFNgw肳Ă܂ - Image_draw" );

    x = NUM2INT( vx );
    y = NUM2INT( vy );
    x1 = vx1 == Qnil ? 0 : NUM2INT( vx1 );
    y1 = vy1 == Qnil ? 0 : NUM2INT( vy1 );
    width = vwidth == Qnil ? srcimage->width - x1 : NUM2INT( vwidth );
    height = vheight == Qnil ? srcimage->height - y1 : NUM2INT( vheight );

    /* 摜̃NbsO */
    if( x < 0 )
    {
        x1 -= x;
        width -= x;
        x = 0;
    }
    if( y < 0 )
    {
        y1 -= y;
        height -= y;
        y = 0;
    }
    if( x1 < 0 )
    {
        x -=x1;
        width -= x1;
        x1 = 0;
    }
    if( y1 < 0 )
    {
        y -=y1;
        height -= y1;
        y1 = 0;
    }
    if( x + width > dstimage->width )
    {
        width -= x + width - dstimage->width;
    }
    if( y + height > dstimage->height )
    {
        height -= y + height - dstimage->height;
    }
    if( x1 + width > srcimage->width )
    {
        width -= x1 + width - srcimage->width;
    }
    if( y1 + height > srcimage->height )
    {
        height -= y1 + height - srcimage->height;
    }

    /* ͈͊O */
    if( x >= dstimage->width || y >= dstimage->height || x1 >= srcimage->width || y1 >= srcimage->height ||
        width < 0 || height < 0 )
    {
        return obj;
    }

    dstrect.left = x + dstimage->x;
    dstrect.top = y + dstimage->y;
    dstrect.right = x + dstimage->x + width;
    dstrect.bottom = y + dstimage->y + height;
    srcrect.left = x1 + srcimage->x;
    srcrect.top = y1 + srcimage->y;
    srcrect.right = x1 + srcimage->x + width;
    srcrect.bottom = y1 + srcimage->y + height;

    dstimage->texture->pD3DTexture->lpVtbl->LockRect( dstimage->texture->pD3DTexture, 0, &dsttrect, &dstrect, 0 );
    srcimage->texture->pD3DTexture->lpVtbl->LockRect( srcimage->texture->pD3DTexture, 0, &srctrect, &srcrect, D3DLOCK_READONLY );

    for( i = 0; i < height; i++)
    {
        psrc = (int*)((char *)srctrect.pBits + i * srctrect.Pitch);
        pdst = (int*)((char *)dsttrect.pBits + i * dsttrect.Pitch);
        for( j = 0; j < width; j++)
        {
            struct DXRubyColor s = *((struct DXRubyColor*)(psrc));

            if( s.alpha == 255 )
            {
                *((struct DXRubyColor*)(pdst)) = s;
            }
            else if( s.alpha != 0 )
            {
                struct DXRubyColor d = *((struct DXRubyColor*)(pdst));
                int alpha = (255 - s.alpha) * d.alpha + s.alpha * 255;

                s.red = (((int)s.alpha * (int)s.red * 255) + (int)d.alpha * (int)d.red * (255 - s.alpha) ) / alpha;
                s.green = (((int)s.alpha * (int)s.green * 255) + (int)d.alpha * (int)d.green * (255 - s.alpha) ) / alpha;
                s.blue = (((int)s.alpha * (int)s.blue * 255) + (int)d.alpha * (int)d.blue * (255 - s.alpha) ) / alpha;
                s.alpha = alpha / 255;

                *((struct DXRubyColor*)(pdst)) = s;
            }
            psrc++;
            pdst++;
        }
    }

    dstimage->texture->pD3DTexture->lpVtbl->UnlockRect( dstimage->texture->pD3DTexture, 0 );
    srcimage->texture->pD3DTexture->lpVtbl->UnlockRect( srcimage->texture->pD3DTexture, 0 );

    return obj;
}


static void get_color( VALUE vcolor, int *cr, int *cg, int *cb )
{
    Check_Type(vcolor, T_ARRAY);
    if( RARRAY_LEN(vcolor) == 4 )
    {
        *cr = NUM2INT(rb_ary_entry(vcolor, 1));
        *cg = NUM2INT(rb_ary_entry(vcolor, 2));
        *cb = NUM2INT(rb_ary_entry(vcolor, 3));
    }
    else
    {
        *cr = NUM2INT(rb_ary_entry(vcolor, 0));
        *cg = NUM2INT(rb_ary_entry(vcolor, 1));
        *cb = NUM2INT(rb_ary_entry(vcolor, 2));
    }
}
static void drawfont_sub( int blackboxX, int blackboxY, int baseX, int baseY, int pitch,  char *buf, D3DLOCKED_RECT *dsttrect, int cr, int cg, int cb, int width, int height )
{
    int v, u, xx, yy;

    for( v = 0; v < blackboxY; v++ )
    {
        int yy = baseY + v;
        if( yy < 0 )
        {
            continue;
        }
        if( yy >= height )
        {
            break;
        }
        for( u = 0; u < blackboxX; u++ )
        {
            int xx, src;

            xx = baseX + u;
            if( xx < 0 )
            {
                continue;
            }
            if( xx >= width )
            {
                break;
            }

            src = (int)buf[ u + v * pitch ] * 255 / 64;

            if( src == 255 )
            {
                *((LPDWORD)((char*)dsttrect->pBits + xx * 4 + yy * dsttrect->Pitch)) = D3DCOLOR_ARGB(0xff, cr, cg, cb);
            }
            else if( src != 0 )
            {
                struct DXRubyColor d = *((struct DXRubyColor*)((char*)dsttrect->pBits + xx * 4 + yy * dsttrect->Pitch));
                struct DXRubyColor data;
                int temp = (255 - src) * d.alpha + src * 255;

                data.alpha = temp / 255;
                data.red = (src * cr * 255 + (int)d.alpha * d.red * (255 - src)) / temp;
                data.green = (src * cg * 255 + (int)d.alpha * d.green * (255 - src)) / temp;
                data.blue = (src * cb * 255 + (int)d.alpha * d.blue * (255 - src)) / temp;

                *((struct DXRubyColor*)((char*)dsttrect->pBits + xx * 4 + yy * dsttrect->Pitch)) = data;
            }
        }
    }
}
/*--------------------------------------------------------------------
   C[WɃtHg`
 ---------------------------------------------------------------------*/
static VALUE Image_drawFont( int argc, VALUE *argv, VALUE obj )
{
    struct DXRubyFont *font;
    struct DXRubyImage *image;
    VALUE vx, vy, vcolor, vstr, data;
    int cr=255, cg=255, cb=255, x, y;
    LPDIRECT3DSURFACE9 pD3DSurface;
    HDC hDC;
    RECT rc;
    HRESULT hr;
    D3DLOCKED_RECT srctrect;
    D3DLOCKED_RECT dsttrect;
    int i, j;
    int h;
    RECT srcrect;
    RECT dstrect;
    TEXTMETRIC tm;
    GLYPHMETRICS gm;

    LPWSTR widestr;
    VALUE vwidestr;
    MAT2 mat2 = {{0,1},{0,0},{0,0},{0,1}};

    /* 擾 */
    rb_scan_args( argc, argv, "41", &vx, &vy, &vstr, &data, &vcolor);

    Check_Type(vstr, T_STRING);

    /* ̃tHgIuWFNg璆go */
    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );
    DXRUBY_CHECK_TYPE( Font, data );
    Data_Get_Struct( data, struct DXRubyFont, font );
    DXRUBY_CHECK_DISPOSE( font, pD3DXFont );

    x = NUM2INT( vx );
    y = NUM2INT( vy );
    if( vcolor != Qnil )
    {
        get_color( vcolor, &cr, &cg, &cb );
    }

    if( x >= image->width || y >= image->height )
    {
        return obj;
    }

    /* `敶UTF16LE */
#ifdef HAVE_RB_ENC_STR_NEW
    if( rb_enc_get_index( vstr ) != 0 )
    {
        vwidestr = rb_funcall( vstr, rb_intern( "encode" ), 1, rb_str_new2( "UTF-16LE" ) );
    }
    else
    {
        char *buf;
        int bufsize;
        bufsize = MultiByteToWideChar(CP_ACP, 0, RSTRING_PTR( vstr ), RSTRING_LEN( vstr ), 0, 0);
        buf = alloca(bufsize * 2);
        MultiByteToWideChar(CP_ACP, 0, RSTRING_PTR( vstr ), RSTRING_LEN( vstr ), (LPWSTR)buf, bufsize);
        vwidestr = rb_str_new( buf, bufsize*2 );
    }
#else
    {
        char *buf;
        int bufsize;
        bufsize = MultiByteToWideChar(CP_ACP, 0, RSTRING_PTR( vstr ), RSTRING_LEN( vstr ), 0, 0);
        buf = alloca(bufsize * 2);
        MultiByteToWideChar(CP_ACP, 0, RSTRING_PTR( vstr ), RSTRING_LEN( vstr ), (LPWSTR)buf, bufsize);
        vwidestr = rb_str_new( buf, bufsize*2 );
    }
#endif
    widestr = alloca( RSTRING_LEN( vwidestr ) + 2 );
    ZeroMemory( widestr, RSTRING_LEN( vwidestr ) + 2 );
    memcpy( widestr, RSTRING_PTR( vwidestr ), RSTRING_LEN( vwidestr ) );

    hDC = GetDC( g_hWnd );
    SelectObject( hDC, font->hFont );
    GetTextMetrics( hDC, &tm );

    dstrect.left = image->x;
    dstrect.top = image->y;
    dstrect.right = image->x + image->width;
    dstrect.bottom = image->y + image->height;

    image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &dsttrect, &dstrect, 0 );

    for( i = 0; i < RSTRING_LEN( vwidestr ) / 2; i++ )
    {
        int bufsize = GetGlyphOutlineW( hDC, *(widestr + i), GGO_GRAY8_BITMAP,
                                        &gm, 0, NULL, &mat2 );

        if( bufsize > 0 )
        {
            unsigned char *buf = alloca( bufsize );
            int v, u;

            GetGlyphOutlineW( hDC, *(widestr + i), GGO_GRAY8_BITMAP, 
                              &gm, bufsize, (LPVOID)buf, &mat2 );

            drawfont_sub( gm.gmBlackBoxX, gm.gmBlackBoxY, x + gm.gmptGlyphOrigin.x, y + tm.tmAscent - gm.gmptGlyphOrigin.y, (gm.gmBlackBoxX + 3) & 0xfffc, buf, &dsttrect, cr, cg, cb, image->width, image->height );
        }
        x += gm.gmCellIncX;
        if( x >= image->width )
        {
            break;
        }
    }

    image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );

    ReleaseDC( g_hWnd, hDC );
    return obj;
}


/* fast_int_hypot from http://demo.and.or.jp/makedemo/effect/math/hypot/fast_hypot.c */
int fast_int_hypot(int lx, int ly)
{
	int len1, len2,t,length;

/*	lx = abs(lx); */
/*	ly = abs(ly); */
	if(lx<0) lx = -lx;
	if(ly<0) ly = -ly;
	/*
		CWD
		XOR EAX,EDX
		SUB EAX,EDX
	*/
	
	if (lx >= ly)
	{
		len1 = lx ; len2 = ly;
	}
	else
	{
		len1 = ly ; len2 = lx;
	}

	t = len2 + (len2 >> 1) ;
	length = len1 - (len1 >> 5) - (len1 >> 7) + (t >> 2) + (t >> 6) ;
	return length;
}
/*--------------------------------------------------------------------
   C[WɃtHg`捂@\
 ---------------------------------------------------------------------*/
VALUE Image_drawFontEx( int argc, VALUE *argv, VALUE obj )
{
    struct DXRubyFont *font;
    struct DXRubyImage *image;
    VALUE vx, vy, vcolor, vstr, vfont, voption;
    VALUE vedge;
    VALUE vshadow;
    int edge_width, edge_level, shadow_x, shadow_y, shadow_edge;
    int cr=255, cg=255, cb=255, x, y;
    int br=0, bg=0, bb=0;
    int sr=0, sg=0, sb=0;
    LPDIRECT3DSURFACE9 pD3DSurface;
    HDC hDC;
    RECT rc;
    HRESULT hr;
    D3DLOCKED_RECT srctrect;
    D3DLOCKED_RECT dsttrect;
    int i, j;
    RECT srcrect;
    RECT dstrect;
    TEXTMETRIC tm;
    GLYPHMETRICS gm;

    LPWSTR widestr;
    VALUE vwidestr;
    MAT2 mat2 = {{0,1},{0,0},{0,0},{0,1}};

    /* 擾 */
    if( argc < 4 || argc > 5 ) rb_raise( rb_eArgError, "wrong number of arguments (%d for %d..%d)", argc, 4, 5 );

    vx = argv[0];
    vy = argv[1];
    vstr = argv[2];
    vfont = argv[3];

    x = NUM2INT( vx );
    y = NUM2INT( vy );

    Check_Type(vstr, T_STRING);

    /* ̃tHgIuWFNg璆go */
    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );
    DXRUBY_CHECK_TYPE( Font, vfont );
    Data_Get_Struct( vfont, struct DXRubyFont, font );
    DXRUBY_CHECK_DISPOSE( font, pD3DXFont );

    if( argc < 5 || argv[4] == Qnil )
    {
        voption = rb_hash_new();
    }
    else
    {
        Check_Type( argv[4], T_HASH );
        voption = argv[4];
    }

    /* ̐F */
    vcolor = hash_lookup( voption, symbol_color );
    if( vcolor != Qnil )
    {
        get_color( vcolor, &cr, &cg, &cb );
    }

    /* GbWIvV */
    vedge = hash_lookup( voption, symbol_edge );
    if( vedge == Qnil || vedge == Qfalse )
    {
        edge_width = 0;
        edge_level = 0;
    }
    else
    {
        VALUE vedge_color, vedge_width, vedge_level;
        vedge_color = hash_lookup( voption, symbol_edge_color );
        if( vedge_color != Qnil )
        {
            get_color( vedge_color, &br, &bg, &bb );
        }

        vedge_width = hash_lookup( voption, symbol_edge_width );
        edge_width = vedge_width == Qnil ? 2 : NUM2INT( vedge_width ); /* GbW̕ */

        vedge_level = hash_lookup( voption, symbol_edge_level );
        edge_level = vedge_level == Qnil ? 4 : NUM2INT( vedge_level ); /* GbW̋ */
    }

    /* eIvV */
    vshadow = hash_lookup( voption, symbol_shadow );
    if( vshadow == Qnil || vshadow == Qfalse )
    {
        shadow_x = 0;
        shadow_y = 0;
    }
    else
    {
        VALUE vshadow_color, vshadow_x, vshadow_y, vshadow_edge;
        vshadow_color = hash_lookup( voption, symbol_shadow_color );
        if( vshadow_color != Qnil )
        {
            get_color( vshadow_color, &sr, &sg, &sb );
        }

        vshadow_x = hash_lookup( voption, symbol_shadow_x );
        shadow_x = vshadow_x == Qnil ? NUM2INT( Font_getSize( vfont ) ) / 24 + 1 : NUM2INT(vshadow_x);

        vshadow_y = hash_lookup( voption, symbol_shadow_y );
        shadow_y = vshadow_y == Qnil ? NUM2INT( Font_getSize( vfont ) ) / 24 + 1 : NUM2INT(vshadow_y);

        vshadow_edge = hash_lookup( voption, symbol_shadow_edge );
        if( vshadow_edge == Qnil || vshadow_edge == Qfalse )
        {
            shadow_edge = 0;
        }
        else
        {
            shadow_edge = 1;
        }
    }

    if( x >= image->width || y >= image->height )
    {
        return obj;
    }

    /* `敶UTF16LE */
#ifdef HAVE_RB_ENC_STR_NEW
    if( rb_enc_get_index( vstr ) != 0 )
    {
        vwidestr = rb_funcall( vstr, rb_intern( "encode" ), 1, rb_str_new2( "UTF-16LE" ) );
    }
    else
    {
        char *buf;
        int bufsize;
        bufsize = MultiByteToWideChar(CP_ACP, 0, RSTRING_PTR( vstr ), RSTRING_LEN( vstr ), 0, 0);
        buf = alloca(bufsize * 2);
        MultiByteToWideChar(CP_ACP, 0, RSTRING_PTR( vstr ), RSTRING_LEN( vstr ), (LPWSTR)buf, bufsize);
        vwidestr = rb_str_new( buf, bufsize*2 );
    }
#else
    {
        char *buf;
        int bufsize;
        bufsize = MultiByteToWideChar(CP_ACP, 0, RSTRING_PTR( vstr ), RSTRING_LEN( vstr ), 0, 0);
        buf = alloca(bufsize * 2);
        MultiByteToWideChar(CP_ACP, 0, RSTRING_PTR( vstr ), RSTRING_LEN( vstr ), (LPWSTR)buf, bufsize);
        vwidestr = rb_str_new( buf, bufsize*2 );
    }
#endif
    widestr = alloca( RSTRING_LEN( vwidestr ) + 2 );
    ZeroMemory( widestr, RSTRING_LEN( vwidestr ) + 2 );
    memcpy( widestr, RSTRING_PTR( vwidestr ), RSTRING_LEN( vwidestr ) );

    hDC = GetDC( g_hWnd );
    SelectObject( hDC, font->hFont );
    GetTextMetrics( hDC, &tm );

    dstrect.left = image->x;
    dstrect.top = image->y;
    dstrect.right = image->x + image->width;
    dstrect.bottom = image->y + image->height;

    image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &dsttrect, &dstrect, 0 );

    for( i = 0; i < RSTRING_LEN( vwidestr ) / 2; i++ )
    {
        int bufsize = GetGlyphOutlineW( hDC, *(widestr + i), GGO_GRAY8_BITMAP,
                                        &gm, 0, NULL, &mat2 );
        if( bufsize > 0 )
        {
            unsigned char *buf = alloca( bufsize );
            int v, u;

            GetGlyphOutlineW( hDC, *(widestr + i), GGO_GRAY8_BITMAP, 
                              &gm, bufsize, (LPVOID)buf, &mat2 );

            if( edge_width > 0 && edge_level > 0 )
            { /* GbWBgg2̃\[XQlɂĂB */
                int edge_pitch  = ((gm.gmBlackBoxX + edge_width * 2 - 1) >> 2) + 1 << 2;
                unsigned char *blurbuf = alloca( edge_pitch * (gm.gmBlackBoxY + edge_width * 2) ); /* obt@ */
                int lvsum = 0;
                memset( blurbuf, 0, edge_pitch * (gm.gmBlackBoxY + edge_width * 2) ); /* obt@̃NA */

                for( v = -edge_width; v <= edge_width; v++ )
                {
                    for( u = -edge_width; u <= edge_width; u++ )
                    {
                        int len = fast_int_hypot(u, v);
                        if(len <= edge_width)
                            lvsum += (edge_width - len + 1);
                    }
                }

                if( lvsum )
                {
                    lvsum = (1<<18) / lvsum;
                }
                else
                {
                    lvsum = (1<<18);
                }

                for( v = -edge_width; v <= edge_width; v++ )
                {
                    for( u = -edge_width; u <= edge_width; u++ )
                    {
                        int len = fast_int_hypot(u, v);
                        if( len <= edge_width )
                        {
                            int sx, sy;
                            for( sy = 0; sy < gm.gmBlackBoxY; sy++ )
                            {
                                for( sx = 0; sx < gm.gmBlackBoxX; sx++ )
                                {
                                    int temp;
                                    temp = blurbuf[(v + sy + edge_width) * edge_pitch + u + sx + edge_width] + ((buf[ sx + sy * ((gm.gmBlackBoxX + 3) & 0xfffc) ] * lvsum * (edge_width - len + 1) * edge_level) >> 18);
                                    if( temp > 64 ) temp = 64;
                                    blurbuf[(v + sy + edge_width) * edge_pitch + u + sx + edge_width] = temp;
                                }
                            }
                        }
                    }
                }

                if( shadow_x != 0 || shadow_y != 0 )
                {
                    /* GbWꍇ̉e̕` */
                    if( shadow_edge == 1 )
                    {
                        drawfont_sub( gm.gmBlackBoxX + edge_width * 2, gm.gmBlackBoxY + edge_width * 2, x + gm.gmptGlyphOrigin.x - edge_width + shadow_x, y + tm.tmAscent - gm.gmptGlyphOrigin.y - edge_width + shadow_y, edge_pitch, blurbuf, &dsttrect, sr, sg, sb, image->width, image->height );
                    }
                    /* GbW邯ǃGbWe̕` */
                    else
                    {
                        drawfont_sub( gm.gmBlackBoxX, gm.gmBlackBoxY, x + gm.gmptGlyphOrigin.x + shadow_x, y + tm.tmAscent - gm.gmptGlyphOrigin.y + shadow_y, (gm.gmBlackBoxX + 3) & 0xfffc, buf, &dsttrect, sr, sg, sb, image->width, image->height );
                    }
                }

                /* GbW̕` */
                drawfont_sub( gm.gmBlackBoxX + edge_width * 2, gm.gmBlackBoxY + edge_width * 2, x + gm.gmptGlyphOrigin.x - edge_width, y + tm.tmAscent - gm.gmptGlyphOrigin.y - edge_width, edge_pitch, blurbuf, &dsttrect, br, bg, bb, image->width, image->height );

            }
            else if( shadow_x != 0 || shadow_y != 0 ) /* GbWȂꍇ̉e̕` */
            {
                drawfont_sub( gm.gmBlackBoxX, gm.gmBlackBoxY, x + gm.gmptGlyphOrigin.x + shadow_x, y + tm.tmAscent - gm.gmptGlyphOrigin.y + shadow_y, (gm.gmBlackBoxX + 3) & 0xfffc, buf, &dsttrect, sr, sg, sb, image->width, image->height );
            }

            /* ̕` */
            drawfont_sub( gm.gmBlackBoxX, gm.gmBlackBoxY, x + gm.gmptGlyphOrigin.x, y + tm.tmAscent - gm.gmptGlyphOrigin.y, (gm.gmBlackBoxX + 3) & 0xfffc, buf, &dsttrect, cr, cg, cb, image->width, image->height );

        }
        x += gm.gmCellIncX;
        if( x >= image->width )
        {
            break;
        }
    }

    image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );

    ReleaseDC( g_hWnd, hDC );
    return obj;
}


/*--------------------------------------------------------------------
   C[Wt@CɕۑB
 ---------------------------------------------------------------------*/
VALUE Image_save( int argc, VALUE *argv, VALUE self )
{
    HRESULT hr;
    struct DXRubyImage *image;
    VALUE vfilename, vformat, vsjisstr, vdowncase;
    char ext[5][6] = {".jpeg", ".jpg", ".png", ".bmp", ".dds"};
    char len[5] = {4, 3, 3, 3, 3};
    int format[5] = {FORMAT_JPG, FORMAT_JPG, FORMAT_PNG, FORMAT_BMP, FORMAT_DDS};
    int i, j, k, f;
    VALUE obj;

    rb_scan_args( argc, argv, "11", &vfilename, &vformat );

    Data_Get_Struct( self, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    /* ImagẽeNX`𕔕Rs[ */
    obj = Image_initialize_copy( Image_allocate( cImage ), self );
    Data_Get_Struct( obj, struct DXRubyImage, image );

    #ifdef HAVE_RB_ENC_STR_NEW
    if( rb_enc_get_index( vfilename ) != 0 )
    {
        vsjisstr = rb_funcall( vfilename, rb_intern( "encode" ), 1, rb_str_new2( sys_encode ) );
    }
    else
    {
        vsjisstr = vfilename;
    }
#else
    vsjisstr = vfilename;
#endif

    vdowncase = rb_funcall( vsjisstr, rb_intern("downcase"), 0, Qnil );
    if( vformat == Qnil )
    {
        for( i = 0; i < 5; i++ )
        {
            for( j = RSTRING_LEN(vdowncase) - 1, k = len[i]; k >= 0 && j >= 0; k--, j-- )
            {
                if( RSTRING_PTR(vdowncase)[j] != ext[i][k] )
                {
                    break;
                }
            }

            if( ext[i][k + 1] == '.' && RSTRING_PTR(vdowncase)[j + 1] == '.' )
            {
                f = format[i];
                break;
            }
        }
        if( i == 5 )
        {
            f = FORMAT_PNG;
        }
    }
    else
    {
        f = FIX2INT( vformat );
    }

    hr = D3DXSaveTextureToFile(
            RSTRING_PTR( vsjisstr ),                            /* ۑt@C */
            f,                                                  /* t@CtH[}bg */
            (IDirect3DBaseTexture9*)image->texture->pD3DTexture,/* ۑT[tFX */
            NULL);                                              /* pbg */
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "t@C̕ۑɎs܂ - Image_save" );
    }

    return self;
}


/*--------------------------------------------------------------------
   C[W̊JnʒuxԂB
 ---------------------------------------------------------------------*/
static VALUE Image_getX( VALUE obj )
{
    struct DXRubyImage *image;

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    return INT2FIX( image->x );
}


/*--------------------------------------------------------------------
   C[W̊JnʒuyԂB
 ---------------------------------------------------------------------*/
static VALUE Image_getY( VALUE obj )
{
    struct DXRubyImage *image;

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    return INT2FIX( image->y );
}


/*--------------------------------------------------------------------
   C[W̃TCYijԂB
 ---------------------------------------------------------------------*/
static VALUE Image_getWidth( VALUE obj )
{
    struct DXRubyImage *image;

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    return INT2FIX( image->width );
}


/*--------------------------------------------------------------------
   C[W̃TCYijԂB
 ---------------------------------------------------------------------*/
static VALUE Image_getHeight( VALUE obj )
{
    struct DXRubyImage *image;

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    return INT2FIX( image->height );
}


/*--------------------------------------------------------------------
   C[W̊Jnʒuxݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Image_setX( VALUE obj, VALUE vx )
{
    struct DXRubyImage *image;
    int x = NUM2INT( vx );

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    if( x < 0 || x + image->width > image->texture->width )
    {
        rb_raise( eDXRubyError, "bad value of x - Image#x=" );
    }

    image->x = x;
    return vx;
}


/*--------------------------------------------------------------------
   C[W̊Jnʒuyݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Image_setY( VALUE obj, VALUE vy )
{
    struct DXRubyImage *image;
    int y = NUM2INT( vy );

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    if( y < 0 || y + image->height > image->texture->height )
    {
        rb_raise( eDXRubyError, "bad value of y - Image#y=" );
    }

    image->y = y;
    return vy;
}


/*--------------------------------------------------------------------
   C[W̃TCYijݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Image_setWidth( VALUE obj, VALUE vwidth )
{
    struct DXRubyImage *image;
    int width = NUM2INT( vwidth );

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    if( width < 1 || width + image->x > image->texture->width )
    {
        rb_raise( eDXRubyError, "bad value of width - Image#width=" );
    }

    image->width = width;
    return vwidth;
}


/*--------------------------------------------------------------------
   C[W̃TCYijݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Image_setHeight( VALUE obj, VALUE vheight )
{
    struct DXRubyImage *image;
    int height = NUM2INT( vheight );

    Data_Get_Struct( obj, struct DXRubyImage, image );
    DXRUBY_CHECK_DISPOSE( image, texture );

    if( height < 1 || height + image->y > image->texture->height )
    {
        rb_raise( eDXRubyError, "bad value of height - Image#height=" );
    }

    image->height = height;
    return vheight;
}


void Init_dxruby_Image()
{
    /* ImageNX` */
    cImage = rb_define_class_under( mDXRuby, "Image", rb_cObject );

    /* ImageNXɃNX\bho^*/
    rb_define_singleton_method( cImage, "load", Image_load, -1 );
    rb_define_singleton_method( cImage, "load_to_array", Image_loadToArray, -1 );
    rb_define_singleton_method( cImage, "loadToArray", Image_loadToArray, -1 );
    rb_define_singleton_method( cImage, "create_from_array", Image_createFromArray, 3 );
    rb_define_singleton_method( cImage, "createFromArray", Image_createFromArray, 3 );
    rb_define_singleton_method( cImage, "load_from_file_in_memory", Image_loadFromFileInMemory, 1 );
    rb_define_singleton_method( cImage, "loadFromFileInMemory", Image_loadFromFileInMemory, 1 );

    /* ImageNXɃ\bho^*/
    rb_define_private_method( cImage, "initialize", Image_initialize, -1 );
    rb_define_method( cImage, "dispose"   , Image_dispose   , 0 );
    rb_define_method( cImage, "disposed?" , Image_check_disposed, 0 );
    rb_define_method( cImage, "delayed_dispose"   , Image_delayed_dispose   , 0 );
    rb_define_method( cImage, "width"     , Image_getWidth  , 0 );
    rb_define_method( cImage, "height"    , Image_getHeight , 0 );
//    rb_define_method( cImage, "width="    , Image_setWidth  , 1 );
//    rb_define_method( cImage, "height="   , Image_setHeight , 1 );
    rb_define_method( cImage, "[]="       , Image_setPixel  , 3 );
    rb_define_method( cImage, "[]"        , Image_getPixel  , 2 );
    rb_define_method( cImage, "box"       , Image_box       , 5 );
    rb_define_method( cImage, "box_fill"  , Image_boxFill   , 5 );
    rb_define_method( cImage, "boxFill"   , Image_boxFill   , 5 );
    rb_define_method( cImage, "fill"      , Image_fill      , 1 );
    rb_define_method( cImage, "clear"     , Image_clear     , 0 );
    rb_define_method( cImage, "line"      , Image_line      , 5 );
    rb_define_method( cImage, "triangle"  , Image_triangle  , 7 );
    rb_define_method( cImage, "triangle_fill", Image_triangle_fill, 7 );
    rb_define_method( cImage, "triangleFill" , Image_triangle_fill, 7 );
    rb_define_method( cImage, "circle"    , Image_circle    , 4 );
    rb_define_method( cImage, "circle_fill", Image_circleFill, 4 );
    rb_define_method( cImage, "circleFill", Image_circleFill, 4 );
    rb_define_method( cImage, "compare"   , Image_compare   , 3 );
    rb_define_method( cImage, "copy_rect" , Image_copyRect  , -1 );
    rb_define_method( cImage, "copyRect"  , Image_copyRect  , -1 );
    rb_define_method( cImage, "draw"      , Image_draw      , -1 );
    rb_define_method( cImage, "draw_font" , Image_drawFont  , -1 );
    rb_define_method( cImage, "drawFont"  , Image_drawFont  , -1 );
    rb_define_method( cImage, "save"      , Image_save      , -1 );
    rb_define_method( cImage, "slice"     , Image_slice_instance, -1);
    rb_define_method( cImage, "set_color_key", Image_setColorKey , 1 );
    rb_define_method( cImage, "setColorKey", Image_setColorKey , 1 );
    rb_define_method( cImage, "slice_to_array", Image_sliceToArray , -1 );
    rb_define_method( cImage, "sliceToArray", Image_sliceToArray , -1 );
    rb_define_method( cImage, "initialize_copy", Image_initialize_copy , 1 );
    rb_define_method( cImage, "draw_font_ex" , Image_drawFontEx  , -1 );
    rb_define_method( cImage, "drawFontEx"   , Image_drawFontEx  , -1 );

    /* ImageIuWFNg𐶐initializȇOɌĂ΂郁蓖Ċ֐o^ */
    rb_define_alloc_func( cImage, Image_allocate );
}


