#include "dxlibp.h"
#include "dxparchive.h"
#include <stdio.h>
#include <string.h>

// 񓯊ǂݍݏ
#define DXARC_STREAM_ASYNCSTATE_IDLE			(0)				// ĂȂ
#define DXARC_STREAM_ASYNCSTATE_PRESSREAD		(1)				// kꂽt@Cǂݍݒ
#define DXARC_STREAM_ASYNCSTATE_READ			(2)				// f[^ǂݍݒ

//dxparc_decode.c
int		DXA_Decode( void *Src, void *Dest );

/** t@C|C^ύX
 *
 *
 */
int		DXA_STREAM_Seek( DXARC_STREAM *DXAStream, int SeekPoint, int SeekMode )
{
	// 񓯊ǂݍ݂ŏԂ܂ҋ@Ԃł͂Ȃҋ@ԂɂȂ܂ő҂
	if( DXAStream->UseASyncReadFlag == TRUE && DXAStream->ASyncState != DXARC_STREAM_ASYNCSTATE_IDLE )
	{
		while( DXA_STREAM_IdleCheck( DXAStream ) == FALSE ) Sleep(1);
	}
	// V[N^Cvɂď𕪊
	switch( SeekMode )
	{
	case SEEK_SET : break ;		
	case SEEK_CUR : SeekPoint += DXAStream->FilePoint ; break ;
	case SEEK_END :	SeekPoint = DXAStream->FileHead->DataSize + SeekPoint ; break ;
	}
	// ␳
	if( SeekPoint > (int)DXAStream->FileHead->DataSize ) SeekPoint = DXAStream->FileHead->DataSize ;
	if( SeekPoint < 0 ) SeekPoint = 0 ;
	// Zbg
	DXAStream->FilePoint = SeekPoint ;
	// EOFtO|
	DXAStream->EOFFlag = FALSE ;
	return 0 ;
}

/** ݂̃t@C|C^𓾂
 *
 *
 */
int		DXA_STREAM_Tell( DXARC_STREAM *DXAStream )
{
	// 񓯊ǂݍ݂ŏԂ܂ҋ@Ԃł͂Ȃҋ@ԂɂȂ܂ő҂
	if( DXAStream->UseASyncReadFlag == TRUE && DXAStream->ASyncState != DXARC_STREAM_ASYNCSTATE_IDLE )
	{
		while( DXA_STREAM_IdleCheck( DXAStream ) == FALSE ) Sleep(1);
	}
	return DXAStream->FilePoint ;
}

/** t@C̏I[ɗĂ邩ÃtO𓾂
 *
 *
 */
int		DXA_STREAM_Eof( DXARC_STREAM *DXAStream )
{
	// 񓯊ǂݍ݂ŏԂ܂ҋ@Ԃł͂Ȃҋ@ԂɂȂ܂ő҂
	if( DXAStream->UseASyncReadFlag == TRUE && DXAStream->ASyncState != DXARC_STREAM_ASYNCSTATE_IDLE )
	{
		while( DXA_STREAM_IdleCheck( DXAStream ) == FALSE ) Sleep(1);
	}
	return DXAStream->EOFFlag ? EOF : 0 ;
}

/** ǂݍݏĂ邩ǂ𒲂ׂ
 *
 *
 */
int		DXA_STREAM_IdleCheck( DXARC_STREAM *DXAStream )
{
	// 񓯊ǂݍ݂ł͂Ȃꍇ͉ TRUE Ԃ
	if( DXAStream->UseASyncReadFlag == FALSE ) return TRUE ;
	// Ԃɂď𕪊
	switch( DXAStream->ASyncState )
	{
	case DXARC_STREAM_ASYNCSTATE_IDLE:			// ҋ@
		return TRUE;
	case DXARC_STREAM_ASYNCSTATE_PRESSREAD:		// kf[^ǂݍݑ҂
		// ǂݍݏI҂
		//if( WinFileAccessIdleCheck( DXAStream->Archive->FilePointer ) == FALSE ) return FALSE;
		// ǂݍݏI܂O
		DXA_KeyConv( DXAStream->DecodeTempBuffer, DXAStream->FileHead->PressDataSize, DXAStream->ASyncReadFileAddress, DXAStream->Archive->Key ) ;
		// 
		DXA_Decode( DXAStream->DecodeTempBuffer, DXAStream->DecodeDataBuffer ) ;
		// ̉
		DXFREE( DXAStream->DecodeTempBuffer ) ;
		DXAStream->DecodeTempBuffer = NULL ;
		// Ԃҋ@Ԃɂ
		DXAStream->ASyncState = DXARC_STREAM_ASYNCSTATE_IDLE;
		return TRUE;
	case DXARC_STREAM_ASYNCSTATE_READ:			// ǂݍݑ҂
		// ǂݍݏI҂
		//if( WinFileAccessIdleCheck( DXAStream->Archive->FilePointer ) == FALSE ) return FALSE;
		// ǂݍݏI献O
		DXA_KeyConv( DXAStream->ReadBuffer, DXAStream->ReadSize, DXAStream->ASyncReadFileAddress, DXAStream->Archive->Key ) ;
		// Ԃҋ@Ԃɂ
		DXAStream->ASyncState = DXARC_STREAM_ASYNCSTATE_IDLE;
		return TRUE;
	}
	return TRUE ;
}

/** t@C̃TCY擾
 *
 *
 */
int		DXA_STREAM_Size( DXARC_STREAM *DXAStream )
{
	return DXAStream->FileHead->DataSize ;
}

/** t@C̓eǂݍ
 *
 *
 */
int		DXA_STREAM_Read( DXARC_STREAM *DXAStream, void *Buffer, int ReadLength )
{
	int ReadSize ;
	// 񓯊ǂݍ݂ŏԂ܂ҋ@Ԃł͂Ȃҋ@ԂɂȂ܂ő҂
	if( DXAStream->UseASyncReadFlag == TRUE && DXAStream->ASyncState != DXARC_STREAM_ASYNCSTATE_IDLE )
	{
		while( DXA_STREAM_IdleCheck( DXAStream ) == FALSE ) Sleep(1);
	}
	// EOF tOĂOԂ
	if( DXAStream->EOFFlag == TRUE ) return 0 ;
	// EOF o
	if( DXAStream->FileHead->DataSize == DXAStream->FilePoint )
	{
		DXAStream->EOFFlag = TRUE ;
		return 0 ;
	}
	// f[^ǂݍޗʂݒ肷
	ReadSize = ReadLength < (int)( DXAStream->FileHead->DataSize - DXAStream->FilePoint ) ? ReadLength : DXAStream->FileHead->DataSize - DXAStream->FilePoint ;
	// f[^kĂǂŏ𕪊
	if( DXAStream->DecodeDataBuffer != NULL )
	{
		// f[^Rs[
		memcpy( Buffer, (BYTE *)DXAStream->DecodeDataBuffer + DXAStream->FilePoint, ReadSize ) ;
	}
	else
	{
		// Ƀf[^邩ǂŏ𕪊
		if( DXAStream->Archive->MemoryOpenFlag == TRUE )
		{
			// ɂꍇ
			// f[^Rs[
			memcpy( Buffer, (BYTE *)DXAStream->Archive->FilePointer + DXAStream->Archive->Head.DataStartAddress + DXAStream->FileHead->DataAddress + DXAStream->FilePoint, ReadSize ) ;
		}
		else
		{
			// t@Cǂݍłꍇ
			// A[JCut@C|C^ƁAzt@C|C^vĂ邩ׂ
			// vĂȂA[JCut@C|C^ړ
			DXAStream->ASyncReadFileAddress = (int)( DXAStream->FileHead->DataAddress + DXAStream->Archive->Head.DataStartAddress + DXAStream->FilePoint );
			//if( WinFileAccessTell( DXAStream->Archive->FilePointer ) != DXAStream->ASyncReadFileAddress )
			{
			//	WinFileAccessSeek( DXAStream->Archive->FilePointer, DXAStream->ASyncReadFileAddress, SEEK_SET ) ;
			}
			// 񓯊ǂݍ݂̏ꍇƓǂݍ݂̏ꍇŏ𕪊
			if( DXAStream->UseASyncReadFlag )
			{
				// t@Cǂݍ
				//WinFileAccessRead( Buffer, ReadSize, 1, DXAStream->Archive->FilePointer ) ;
				DXAStream->ReadBuffer = Buffer;
				DXAStream->ReadSize = ReadSize;
				DXAStream->ASyncState = DXARC_STREAM_ASYNCSTATE_READ ;
			}
			else
			{
				// f[^ǂݍ
				DXA_KeyConvFileRead( Buffer, ReadSize, DXAStream->Archive->FilePointer, DXAStream->Archive->Key,-1 ) ;
			}
		}
	}
	// EOF tO|
	DXAStream->EOFFlag = FALSE ;
	// ǂݍ񂾕t@C|C^ړ
	DXAStream->FilePoint += ReadSize ;
	return ReadSize ;// ǂݍ񂾗eʂԂ
}
	
/** A[JCut@C̃t@C
 *
 *
 */
int		DXA_STREAM_Terminate( DXARC_STREAM *DXAStream )
{
	// 񓯊ǂݍ݂ŏԂ܂ҋ@Ԃł͂Ȃҋ@ԂɂȂ܂ő҂
	if( DXAStream->UseASyncReadFlag == TRUE && DXAStream->ASyncState != DXARC_STREAM_ASYNCSTATE_IDLE )
	{
		while( DXA_STREAM_IdleCheck( DXAStream ) == FALSE ) Sleep(1);
	}
	// ̉
	if( DXAStream->DecodeDataBuffer != NULL )
	{
		DXFREE( DXAStream->DecodeDataBuffer ) ;
		DXAStream->DecodeDataBuffer = NULL ;
	}
	if( DXAStream->DecodeTempBuffer != NULL )
	{
		DXFREE( DXAStream->DecodeTempBuffer ) ;
		DXAStream->DecodeTempBuffer = NULL ;
	}
	// [
	memset( DXAStream, 0, sizeof( DXARC_STREAM ) ) ;
	return 0 ;
}

/** A[JCut@C̃t@CJ(t@CƂ͕KvȂ)
 *
 *
 */
int		DXA_STREAM_Initialize( DXARC_STREAM *DXAStream, DXARC *DXA, const char *FilePath)//, int UseASyncReadFlag )
{
	DXARC_FILEHEAD *FileH ;
	// 񓯊I[v̏ꍇ͂ŊJÎ҂
	if( DXA->ASyncOpenFlag == TRUE )
	{
		while( DXA_CheckIdle( DXA ) == FALSE ) Sleep(0);
	}
	// w̃t@C̏𓾂
	FileH = DXA_GetFileInfo( DXA, FilePath ) ;
	if( FileH == NULL ) return -1 ;
	// f[^̃Zbg
	DXAStream->Archive          = DXA ;
	DXAStream->FileHead         = FileH ;
	DXAStream->EOFFlag          = FALSE ;
	DXAStream->FilePoint        = 0 ;
	DXAStream->DecodeDataBuffer = NULL ;
	DXAStream->DecodeTempBuffer = NULL ;
	DXAStream->UseASyncReadFlag = UseASyncReadFlag ;
	DXAStream->ASyncState       = DXARC_STREAM_ASYNCSTATE_IDLE ;
	// t@CkĂꍇ͂œǂݍŉ𓀂Ă܂
	if( DXA->Head.Version >= 0x0002 && FileH->PressDataSize != 0xffffffff )
	{
		// 𓀃f[^܂郁̈̊m
		DXAStream->DecodeDataBuffer = DXALLOC( FileH->DataSize ) ;
		// ɓǂݍ܂Ă邩ǂŏ𕪊
		if( DXA->MemoryOpenFlag == TRUE )
		{
			// 
			DXA_Decode( (BYTE *)DXA->FilePointer + DXA->Head.DataStartAddress + FileH->DataAddress, DXAStream->DecodeDataBuffer ) ;
		}
		else
		{
			// kf[^܂郁̈̊m
			DXAStream->DecodeTempBuffer = DXALLOC( FileH->PressDataSize ) ;
			// kf[^̓ǂݍ
			DXAStream->ASyncReadFileAddress = DXA->Head.DataStartAddress + FileH->DataAddress;
			//WinFileAccessSeek( DXA->FilePointer, DXAStream->ASyncReadFileAddress, SEEK_SET ) ;
			// 񓯊̏ꍇ͓ǂݍ݂ƌʁXɍs
			if( DXAStream->UseASyncReadFlag == TRUE )
			{
				// t@Cǂݍ
				//WinFileAccessRead( DXAStream->DecodeTempBuffer, FileH->PressDataSize, 1, DXA->FilePointer ) ;
				DXAStream->ASyncState = DXARC_STREAM_ASYNCSTATE_PRESSREAD ;
			}
			else
			{
				DXA_KeyConvFileRead( DXAStream->DecodeTempBuffer, FileH->PressDataSize, DXA->FilePointer, DXA->Key,-1 ) ;
				// 
				DXA_Decode( DXAStream->DecodeTempBuffer, DXAStream->DecodeDataBuffer ) ;
				// ̉
				DXFREE( DXAStream->DecodeTempBuffer ) ;
				DXAStream->DecodeTempBuffer = NULL ;
			}
		}
	}
	return 0 ;
}

