#include "dxlibp.h"
#include "dxparchive.h"
typedef void *HANDLE;
// t@CANZXpXbhp\
typedef struct tagFILEACCESSTHREAD
{
	DWORD					ThreadID ;							// Xbhhc
	HANDLE					ThreadHandle ;						// Xbhnh
	HANDLE					Handle ;							// t@CANZXpnh
	HANDLE					FuncEvent ;							// wߎ󂯎pnh
	HANDLE					CompEvent ;							// wߊpnh
	int						Function ;							// w( FILEACCESSTHREAD_FUNCTION_OPEN  )

	int						EndFlag ;							// IAtO
	int						ErrorFlag ;							// G[tO

	char					FilePath[MAX_PATH] ;				// t@CpX
	void					*ReadBuffer ;						// ǂݍރf[^i[obt@[
	DWORD					ReadPosition ;						// ǂݍރf[^̈ʒu
	DWORD					ReadSize ;							// ǂݍރf[^̃TCY(ǂݍ߂f[^̃TCY)
	long					SeekPoint ;							// t@C|C^ړʒu 

	BYTE					*CacheBuffer ;						// LbVobt@ւ̃|C^
	DWORD					CachePosition ;						// LbVĂt@Cʒu
	int						CacheSize ;							// LbVobt@̗Lf[^TCY
} FILEACCESSTHREAD ;

// t@CANZXp\
typedef struct tagWINFILEACCESS
{
	HANDLE					Handle ;							// t@CANZXpnh
	int						UseThread ;							// Xbhgp邩ǂ
	int						UseCacheFlag ;						// LbVgp邩ǂ
	int						UseASyncReadFlag ;					// 񓯊ǂݍ݂sǂ
	int						EofFlag ;							// I[`FbNtO
	DWORD					Position ;							// ANZXʒu
	DWORD					Size ;								// TCY

	FILEACCESSTHREAD		ThreadData ;						// ǂݍݐpXbh̃f[^
} WINFILEACCESS ;

extern char *_STRCHR( const char *Str1, char Char );
extern void _MEMSET( void *Memory, unsigned char Char, int Size );
extern void _MEMCPY( void *Buffer1, const void *Buffer2, int Size );
extern void _STRCPY( char *Dest, const char *Src );
extern void _STRCAT( char *Dest, const char *Src );
extern int _STRCMP( const char *Str1, const char *Str2 );
extern char *_STRUPR( char *Str );
extern int _STRNCMP( const char *Str1, const char *Str2, int Size );



extern int WinFileAccessOpen( const char *Path, int UseCacheFlag, int BlockReadFlag, int UseASyncReadFlag )
{
	WINFILEACCESS *FileAccess ;
	DWORD Code;
	
//	UseCacheFlag = UseCacheFlag ;
	BlockReadFlag = BlockReadFlag ;

	FileAccess = (WINFILEACCESS *)DXALLOC( sizeof( WINFILEACCESS ) ) ;
	//if( FileAccess == NULL ) return NULL ;
	if( FileAccess == NULL ) return -1;

	_MEMSET( FileAccess, 0, sizeof( WINFILEACCESS ) ) ;

//	// LbVgp邩ǂXbhgp邩ǂɂĂ܂
//	FileAccess->UseThread = UseCacheFlag ;

	// LbVgp邩ǂ̃tOZbg
	FileAccess->UseCacheFlag = UseCacheFlag ;
	FileAccess->ThreadData.CacheBuffer = NULL;

	// 񓯊ǂݏtOZbg
	FileAccess->UseASyncReadFlag = UseASyncReadFlag ;

	// LbVAႵ͔񓯊ǂݏsꍇ̓Xbhgp
	FileAccess->UseThread = FileAccess->UseCacheFlag || FileAccess->UseASyncReadFlag ;

	// XbhgpꍇƂȂꍇŏ𕪊
	if( FileAccess->UseThread == TRUE )
	{
		// Xbhgpꍇ̓t@CANZXpXbh𗧂Ă

		// ŏɃt@CJ邩ǂm߂Ă
		//FileAccess->Handle = CreateFile( Path, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL ) ;
		//if( FileAccess->Handle == INVALID_HANDLE_VALUE )
		{
			DXFREE( FileAccess ) ;
			//return NULL ;
			return -1;
		}
		//FileAccess->Size = GetFileSize( FileAccess->Handle, NULL ) ;
		//CloseHandle( FileAccess->Handle ) ;
		FileAccess->Handle = NULL ;

		// LbVp̊m
		if( FileAccess->UseCacheFlag )
		{
			FileAccess->ThreadData.CacheBuffer = (BYTE *)DXALLOC( FILEACCESSTHREAD_DEFAULT_CACHESIZE );
			if( FileAccess->ThreadData.CacheBuffer == NULL )
			{
				DXFREE( FileAccess->ThreadData.CacheBuffer ) ;
				DXFREE( FileAccess ) ;
				DXST_ERRORLOG_ADD( "t@Cǂݍ݃LbVp̊mۂɎs܂\n" ) ;
				//return NULL ;
				return -1;
			}
		}

		// pXbhf[^
		FileAccess->ThreadData.Handle = NULL ;
		FileAccess->ThreadData.ThreadHandle = NULL ;
		FileAccess->ThreadData.FuncEvent = CreateEvent( NULL, TRUE, FALSE, NULL ) ;
		FileAccess->ThreadData.CompEvent = CreateEvent( NULL, TRUE, TRUE, NULL ) ;

		FileAccess->ThreadData.ThreadHandle = CreateThread(
												NULL,
												0,
												(LPTHREAD_START_ROUTINE)FileAccessThreadFunction, 
												&FileAccess->ThreadData,
												0,
												&FileAccess->ThreadData.ThreadID ) ;
		if( FileAccess->ThreadData.ThreadHandle == NULL )
		{
			if( FileAccess->ThreadData.CacheBuffer ) DXFREE( FileAccess->ThreadData.CacheBuffer ) ;
			CloseHandle( FileAccess->ThreadData.FuncEvent ) ;
			CloseHandle( FileAccess->ThreadData.CompEvent ) ;
			DXFREE( FileAccess ) ;
			DXST_ERRORLOG_ADD( "t@CANZXpXbh̍쐬Ɏs܂\n" ) ;
			//return NULL ;
			return -1;
		}

		// t@CI[vw߂͂ŊĂ܂
		FileAccess->ThreadData.Function = FILEACCESSTHREAD_FUNCTION_OPEN ;
		_STRCPY( FileAccess->ThreadData.FilePath, Path ) ;
		ResetEvent( FileAccess->ThreadData.CompEvent ) ;
		SetEvent( FileAccess->ThreadData.FuncEvent ) ;

		// w߂I܂ő҂
		WaitForSingleObject( FileAccess->ThreadData.CompEvent, INFINITE ) ;
		if( FileAccess->ThreadData.ErrorFlag == TRUE )
		{
			if( FileAccess->ThreadData.CacheBuffer ) DXFREE( FileAccess->ThreadData.CacheBuffer ) ;
			CloseHandle( FileAccess->ThreadData.FuncEvent ) ;
			CloseHandle( FileAccess->ThreadData.CompEvent ) ;
			do
			{
				Sleep(0);
				GetExitCodeThread( FileAccess->ThreadData.ThreadHandle, &Code );
			}while( Code == STILL_ACTIVE );
			CloseHandle( FileAccess->ThreadData.ThreadHandle ) ;
			DXFREE( FileAccess ) ;
			DXST_ERRORLOG_ADD( "t@C̃I[vɎs܂\n" ) ;
			//return NULL ;
			return -1;
		}
	}
	else
	{
		// XbhgpȂꍇ͂̏Ńt@CJ
		FileAccess->Handle = CreateFile( Path, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL ) ;
		//if( FileAccess->Handle == INVALID_HANDLE_VALUE )
		{
			DXFREE( FileAccess ) ;
			//return NULL ;
			return -1;
		}
		//FileAccess->Size = GetFileSize( FileAccess->Handle, NULL ) ;
	}
	FileAccess->EofFlag = FALSE ;
	FileAccess->Position = 0 ;

	return (int)FileAccess ;
}

extern int WinFileAccessClose( int Handle )
{
	WINFILEACCESS *FileAccess = ( WINFILEACCESS * )Handle ;
	BOOL Result;
	DWORD Code ;

	// XbhgpꍇƂȂꍇŏ𕪊
	if( FileAccess->UseThread == TRUE )
	{
		// ȑO̎w߂oĂꍇׂ̈ɎwߊCxgVOiԂɂȂ܂ő҂
		WaitForSingleObject( FileAccess->ThreadData.CompEvent, INFINITE ) ;

		// XbhɏIw߂o
		FileAccess->ThreadData.Function = FILEACCESSTHREAD_FUNCTION_EXIT ;
		ResetEvent( FileAccess->ThreadData.CompEvent ) ;
		SetEvent( FileAccess->ThreadData.FuncEvent ) ;

		// w߂I܂ő҂
		WaitForSingleObject( FileAccess->ThreadData.CompEvent, INFINITE ) ;

		// XbhÎ҂
		do
		{
			Sleep(0);
			GetExitCodeThread( FileAccess->ThreadData.ThreadHandle, &Code );
		}while( Code == STILL_ACTIVE );

		// LbVgpĂꍇ̓LbVpJ
		if( FileAccess->ThreadData.CacheBuffer )
			DXFREE( FileAccess->ThreadData.CacheBuffer ) ;

		// CxgXbh
		CloseHandle( FileAccess->ThreadData.ThreadHandle ) ;
		CloseHandle( FileAccess->ThreadData.CompEvent ) ;
		CloseHandle( FileAccess->ThreadData.FuncEvent ) ;
		Result = 0 ;
	}
	else
	{
		// gpĂȂꍇ͂̏ŃnhďI
		Result = CloseHandle( FileAccess->Handle ) ;
	}
	DXFREE( FileAccess ) ;

	return Result != 0 ? 0 : -1/*EOF*/ ;
}

extern long WinFileAccessTell( int Handle )
{
	WINFILEACCESS *FileAccess = ( WINFILEACCESS * )Handle ;

	return FileAccess->Position ;
}

extern int WinFileAccessSeek( int Handle, long SeekPoint, int SeekType )
{
	WINFILEACCESS *FileAccess = ( WINFILEACCESS * )Handle ;
	LONG Pos ;
	DWORD Result ;

	switch( SeekType )
	{
	case SEEK_CUR : Pos = ( LONG )FileAccess->Position + SeekPoint ; break ;
	case SEEK_END : Pos = ( LONG )FileAccess->Size + SeekPoint ; break ;
	case SEEK_SET : Pos = SeekPoint ; break ;
	}

	// XbhgpĂ邩ǂŏ𕪊
	if( FileAccess->UseThread == TRUE )
	{
		// ȑO̎w߂oĂꍇׂ̈ɎwߊCxgVOiԂɂȂ܂ő҂
		WaitForSingleObject( FileAccess->ThreadData.CompEvent, INFINITE ) ;

		// XbhɃt@CʒuύXw߂o
		FileAccess->ThreadData.Function = FILEACCESSTHREAD_FUNCTION_SEEK ;
		FileAccess->ThreadData.SeekPoint = Pos ;
		ResetEvent( FileAccess->ThreadData.CompEvent ) ;
		SetEvent( FileAccess->ThreadData.FuncEvent ) ;
	}
	else
	{
		// t@CANZXʒuύX
		Result = SetFilePointer( FileAccess->Handle, Pos, NULL, FILE_BEGIN ) ;
		if( Result == 0xFFFFFFFF ) return -1 ;
	}

	// ʒuۑĂ
	FileAccess->Position = (DWORD)Pos ;

	// I[`FbNtO|
	FileAccess->EofFlag = FALSE ;

	// I
	return 0 ;
}

extern size_t WinFileAccessRead( void *Buffer, size_t BlockSize, size_t DataNum, int Handle )
{
	WINFILEACCESS *FileAccess = ( WINFILEACCESS * )Handle ;
	DWORD Result, BytesRead ;

	if( BlockSize == 0 ) return 0 ;

	// I[`FbN
	if( FileAccess->Position == FileAccess->Size )
	{
		FileAccess->EofFlag = TRUE ;
		return 0 ;
	}

	// ڐ
	if( BlockSize * DataNum + FileAccess->Position > FileAccess->Size )
	{
		DataNum = ( FileAccess->Size - FileAccess->Position ) / BlockSize ;
	}
	
	if( DataNum == 0 )
	{
		FileAccess->EofFlag = TRUE ;
		return 0 ;
	}

	// XbhgpĂ邩ǂŏ𕪊
	if( FileAccess->UseThread == TRUE )
	{
		// ȑO̎w߂oĂꍇׂ̈ɎwߊCxgVOiԂɂȂ܂ő҂
		WaitForSingleObject( FileAccess->ThreadData.CompEvent, INFINITE ) ;

		// XbhɃt@Cǂݍݎw߂o
		FileAccess->ThreadData.Function = FILEACCESSTHREAD_FUNCTION_READ ;
		FileAccess->ThreadData.ReadBuffer = Buffer ;
		FileAccess->ThreadData.ReadPosition = FileAccess->Position ;
		FileAccess->ThreadData.ReadSize = BlockSize * DataNum ;
		ResetEvent( FileAccess->ThreadData.CompEvent ) ;
		SetEvent( FileAccess->ThreadData.FuncEvent ) ;

		// 񓯊ǂŏ𕪊
		if( FileAccess->UseASyncReadFlag == FALSE )
		{
			// ǂݍ݂̏ꍇ͎w߂܂ő҂
			WaitForSingleObject( FileAccess->ThreadData.CompEvent, INFINITE ) ;
		}

		BytesRead = BlockSize * DataNum ;
		Result = 1 ;
	}
	else
	{
		Result = ReadFile( FileAccess->Handle, Buffer, BlockSize * DataNum, &BytesRead, NULL ) ;
	}

	FileAccess->Position += DataNum * BlockSize ;
	return Result != 0 ? BytesRead / BlockSize : 0 ;
}

extern int WinFileAccessEof( int Handle )
{
	WINFILEACCESS *FileAccess = (WINFILEACCESS *)Handle ;

	return FileAccess->EofFlag ? EOF : 0 ;
}

extern int WinFileAccessIdleCheck( int Handle )
{
	WINFILEACCESS *FileAccess = (WINFILEACCESS *)Handle ;

	if( FileAccess->UseThread == TRUE )
	{
		return WaitForSingleObject( FileAccess->ThreadData.CompEvent, 0 ) == WAIT_TIMEOUT ? FALSE : TRUE ;
	}
	else
	{
		return TRUE ;
	}
}

extern int WinFileAccessChDir( const char *Path )
{
	return SetCurrentDirectory( Path ) ;
}

extern int WinFileAccessGetDir( char *Buffer )
{
	return GetCurrentDirectory( MAX_PATH, Buffer ) ;
}

static void _WIN32_FIND_DATA_To_FILEINFO( WIN32_FIND_DATA *FindData, FILEINFO *FileInfo )
{
	// t@C̃Rs[
	_STRCPY( FileInfo->Name, FindData->cFileName );

	// fBNgǂ̃tOZbg
	FileInfo->DirFlag = (FindData->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0 ? TRUE : FALSE;

	// t@C̃TCYZbg
	((DWORD *)&FileInfo->Size)[0] = FindData->nFileSizeLow;
	((DWORD *)&FileInfo->Size)[1] = FindData->nFileSizeHigh;

	// t@C^Cۑ
	_FileTimeToLocalDateData( &FindData->ftCreationTime, &FileInfo->CreationTime );
	_FileTimeToLocalDateData( &FindData->ftLastWriteTime, &FileInfo->LastWriteTime );
}

// ߂l: -1=G[  -1ȊO=FindHandle
extern int WinFileAccessFindFirst( const char *FilePath, FILEINFO *Buffer )
{
	WIN32_FIND_DATA FindData;
	HANDLE FindHandle;

	FindHandle = FindFirstFile( FilePath, &FindData );
	if( FindHandle == INVALID_HANDLE_VALUE ) return -1;

	if( Buffer ) _WIN32_FIND_DATA_To_FILEINFO( &FindData, Buffer );

	return (int)FindHandle;
}

// ߂l: -1=G[  0=
extern int WinFileAccessFindNext( int FindHandle, FILEINFO *Buffer )
{
	WIN32_FIND_DATA FindData;

	if( FindNextFile( (HANDLE)FindHandle, &FindData ) == 0 ) return -1;

	if( Buffer ) _WIN32_FIND_DATA_To_FILEINFO( &FindData, Buffer );

	return 0;
}

// ߂l: -1=G[  0=
extern int WinFileAccessFindClose( int FindHandle )
{
	// OȊOԂĂ琬
	return FindClose( (HANDLE)FindHandle ) != 0 ? 0 : -1;
}



// e|t@C쐬
extern HANDLE CreateTemporaryFile( char *TempFileNameBuffer )
{
	char String1[MAX_PATH], String2[MAX_PATH] ;
	HANDLE FileHandle ;
	int Length ;

	// e|t@C̃fBNgpX擾
	if( GetTempPath( 256, String1 ) == NULL ) return NULL ;

	// ̍ŌɁ}[N
	Length = lstrlen( String1 ) ;
	if( String1[Length-1] != '\\' ) 
	{
		String1[Length] = '\\' ;
		String1[Length+1] = '\0' ;
	}

	// e|t@C̃t@C쐬
	if( GetTempFileName( String1, "tmp", 0, String2 ) == 0 ) return NULL ;

	// tpXɕϊ
	_ConvertFullPath( String2, String1, NULL ) ;

	// e|t@CJ
	DeleteFile( String1 ) ;
	FileHandle = CreateFile( String1, GENERIC_WRITE, 0, NULL, CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL ) ;
	if( FileHandle == NULL ) return NULL ;

	// e|t@Cۑ
	if( TempFileNameBuffer != NULL ) lstrcpy( TempFileNameBuffer, String1 ) ;

	// nhԂ
	return FileHandle ;
}

// t@CANZXpXbhp֐
DWORD WINAPI FileAccessThreadFunction( void *FileAccessThreadData )
{
	FILEACCESSTHREAD *dat = (FILEACCESSTHREAD *)FileAccessThreadData ;
	DWORD res, ReadSize ;

	for(;;)
	{
		for(;;)
		{
			// LbVgpǂŏ𕪊
			if( dat->CacheBuffer )
			{
				// w߂܂łƑ҂
				res = WaitForSingleObject( dat->FuncEvent, 100 ) ;

				// w߂ĂꍇŃt@CJĂꍇ̓LbVOs
				if( res == WAIT_TIMEOUT && dat->Handle != NULL )
				{
					// LbVt牽Ȃ
					if( dat->CacheSize != FILEACCESSTHREAD_DEFAULT_CACHESIZE )
					{
						// ǂݍ݊JnʒuZbg
						SetFilePointer( dat->Handle, dat->CachePosition + dat->CacheSize, NULL, FILE_BEGIN ) ;

						// ǂݍ
						ReadFile( dat->Handle, &dat->CacheBuffer[dat->CacheSize], FILEACCESSTHREAD_DEFAULT_CACHESIZE - dat->CacheSize, &ReadSize, NULL ) ;
						
						// LȃTCY𑝂₷
						dat->CacheSize += ReadSize ;
					}
				}
				else
				{
					break ;
				}
			}
			else
			{
				// w߂܂ő҂
				res = WaitForSingleObject( dat->FuncEvent, INFINITE ) ;
				if( res == WAIT_TIMEOUT && dat->Handle != NULL ) continue;
				break;
			}
		}

//		WaitForSingleObject( dat->FuncEvent, INFINITE ) ;

		// Cxg̃VOiԂ
		ResetEvent( dat->FuncEvent ) ;
		ResetEvent( dat->CompEvent ) ;

		// w߂画f
		switch( dat->Function )
		{
		case FILEACCESSTHREAD_FUNCTION_OPEN :
			dat->Handle = CreateFile( dat->FilePath, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL ) ;
			if( dat->Handle == INVALID_HANDLE_VALUE )
			{
				dat->ErrorFlag = TRUE ;
				goto END ;
			}
			break ;

		case FILEACCESSTHREAD_FUNCTION_CLOSE :
			CloseHandle( dat->Handle ) ;
			dat->Handle = NULL ;
			break ;

		case FILEACCESSTHREAD_FUNCTION_READ :
			// LbVƓǂݍ݈ʒuvĂꍇ̓LbVf[^]
			if( dat->CacheBuffer && dat->ReadPosition == dat->CachePosition && dat->CacheSize != 0 )
			{
				DWORD MoveSize ;

				// ]TCY𒲐
				MoveSize = dat->ReadSize ;
				if( MoveSize > (DWORD)dat->CacheSize ) MoveSize = dat->CacheSize ;

				// ]
				_MEMCPY( dat->ReadBuffer, dat->CacheBuffer, MoveSize ) ;

				// ǂݍ݃TCYƓǂݍ݈ʒuړ
				dat->ReadBuffer = (void *)( (BYTE *)dat->ReadBuffer + MoveSize ) ;
				dat->ReadPosition += MoveSize ;
				dat->ReadSize -= MoveSize ;
				
				// LbV̏XV
				dat->CachePosition += MoveSize ;
				dat->CacheSize     -= MoveSize ;
				if( dat->CacheSize != 0 ) _MEMMOVE( &dat->CacheBuffer[0], &dat->CacheBuffer[MoveSize], dat->CacheSize ) ;
			}

			// ]̃f[^Sēǂ߂ĂȂꍇ͍XɃt@Cǂݍ
			if( dat->ReadSize != 0 )
			{
				SetFilePointer( dat->Handle, dat->ReadPosition, NULL, FILE_BEGIN ) ;
				ReadFile( dat->Handle, dat->ReadBuffer, dat->ReadSize, &dat->ReadSize, NULL ) ;

				// LbV
				if( dat->CacheBuffer )
				{
					dat->CachePosition = dat->ReadPosition + dat->ReadSize ;
					dat->CacheSize = 0 ;
				}
			}
			break ;

		case FILEACCESSTHREAD_FUNCTION_SEEK :
			SetFilePointer( dat->Handle, dat->SeekPoint, NULL, FILE_BEGIN ) ;

			// LbV
			if( dat->CacheBuffer )
			{
				dat->CachePosition = (DWORD)dat->SeekPoint ;
				dat->CacheSize = 0 ;
			}
			break ;

		case FILEACCESSTHREAD_FUNCTION_EXIT :
			if( dat->Handle != NULL ) CloseHandle( dat->Handle ) ;
			dat->Handle = NULL ;
			goto END ;
		}

		// w߂犮CxgVOiԂɂ
		SetEvent( dat->CompEvent ) ;
	}

END:
	// G[ׂ̈ɊCxgVOiԂɂ
	SetEvent( dat->CompEvent ) ;
	dat->EndFlag = TRUE ;
	ExitThread( 1 ) ;

	return 0 ;
}
