/*
PMDt@Cǂݍ݃[`forWindows
̃R[h͈ȉ̃TCg̏ɍĂ܂B
http://blog.goo.ne.jp/torisu_tetosuki/e/209ad341d3ece2b1b4df24abf619d6e4
*/


#ifndef PMDREADER_H__
#define PMDREADER_H__

#ifdef	__cplusplus
extern "C" {
#endif

#ifdef WIN32
typedef unsigned __int16	u16;
typedef unsigned __int8		u8;
typedef unsigned __int32	u32;
#else
#include <psptypes.h>
#endif

typedef struct sPmdHeader
{
	char	magic[3]; // "Pmd"
	float	version; // 00 00 80 3F == 1.00
	char	model_name[20];
	char	comment[256];
}sPmdHeader;

typedef struct sPmdVertex
{
	float	pos[3]; // x, y, z // W
	float	normal_vec[3]; // nx, ny, nz // @xNg
	float	uv[2]; // u, v // UVW // MMD͒_UV
	u16		bone_num[2]; // {[ԍ1Aԍ2 // fό`(_ړ)ɉe
	u8		bone_weight; // {[1ɗ^ex // min:0 max:100 // {[2ւ̉ex́A(100 - bone_weight)
	u8		edge_flag; // 0:ʏA1:GbW // GbW(֊s)L̏ꍇ
}sPmdVertex;

typedef struct sPmdFace
{
	u16 vertexIndex[3];//ʂ`钸_R
}sPmdFace;

typedef struct sPmdMaterial
{
	float diffuse_color[3]; // dr, dg, db // F
	float alpha;
	float specularity;
	float specular_color[3]; // sr, sg, sb // F
	float mirror_color[3]; // mr, mg, mb // F(ambient)
	u8 toon_index; // toon??.bmp // 0.bmp:0xFF, 1(01).bmp:0x00 EEE 10.bmp:0x09
	u8 edge_flag; // ֊sAe
	u32 face_vert_count; // ʒ_ // CfbNXɕϊꍇ́Aގ0珇ɉZ
	char texture_file_name[21]; //eNX`t@CiPMDt@C͂QOoCgۑȂA0I[Ƃ̂1₵Ăj
}sPmdMaterial;

typedef struct sPmdBone
{
	char bone_name[20]; // {[
	u16 parent_bone_index; // e{[ԍ(Ȃꍇ0xFFFF)
	u16 tail_pos_bone_index; // tailʒũ{[ԍ(`F[[̏ꍇ0xFFFF) // eFq1FȂ̂ŁAɈʒuߗp
	u8 bone_type; // {[̎
	u16 ik_parent_bone_index; // IK{[ԍ(eIK{[BȂꍇ0)
	float bone_head_pos[3]; // x, y, z // {[̃wbḧʒu
}sPmdBone;

typedef struct sPmdIkData
{
	u16 ik_bone_index; // IK{[ԍ
	u16 ik_target_bone_index; // IK^[Qbg{[ԍ // IK{[ŏɐڑ{[
	u8 ik_chain_length; // IK`F[̒(q̐)
	u16 iterations; // ċAZ // IKl1
	float control_weight; // IK̉ex // IKl2
	u16 *ik_child_bone_index; // IKẽ{[ԍ
}sPmdIkData;

typedef struct sPmdSkinVertex
{
	u32 skin_vert_index; // \p̒_̔ԍ(_Xgɂԍ)
	union
	{
		float skin_vert_pos[3]; // x, y, z // \p̒_̍W(_̂̍W)
		float skin_vert_pos_offset[3]; // x, y, z // \p̒_̍WItZbgl(baseɑ΂ItZbg)
	};
}sPmdSkinVertex;

typedef struct sPmdSkin
{
	char skin_name[20]; //@\
	u32 skin_vert_count; // \p̒_
	u8 skin_type; // \̎ // 0FbaseA1F܂A2FځA3FbvA4F̑
	sPmdSkinVertex *skin_vert_data; // \p̒_̃f[^(16Bytes/vert)
}sPmdSkin;

typedef struct sPmdBoneDispName
{
	char name[50];
}sPmdBoneDispName;

typedef struct sPmdBoneDispList
{
	u16 bone_index; // gp{[ԍ
	u8 bone_disp_frame_index; // \gԍ
}sPmdBoneDispList;

typedef struct sPmdEnglishHeader
{
	char model_name_eg[20]; // f(p)
	char comment_eg[256]; // Rg(p)
}sPmdEnglishHeader;

typedef struct sPmdEnglishBoneName
{
	char name[20];
}sPmdEnglishBoneName;

typedef struct sPmdEnglishSkinName
{
	char name[20];
}sPmdEnglishSkinName;

typedef struct sPmdEnglishBoneDispName
{
	char name[50];
}sPmdEnglishBoneDispName;

typedef struct sPmdToonFileName
{
	char name[100];
}sPmdToonFileName;

typedef struct sPmdRigidBody
{
	char rigidbody_name[20]; // f[^F // 
	u16 rigidbody_rel_bone_index; // f[^F֘A{[ԍ // 03 00 == 3 // 
	u8 rigidbody_group_index; // f[^FO[v // 00
	u16 rigidbody_group_target; // f[^FO[vFΏ // 0xFFFFƂ̍ // 38 FE
	u8 shape_type; // `F^Cv(0:A1:A2:JvZ) // 00 // 
	float shape_w; // `Fa() // CD CC CC 3F // 1.6
	float shape_h; // `F // CD CC CC 3D // 0.1
	float shape_d; // `Fs // CD CC CC 3D // 0.1
	float pos_pos[3]; // ʒuFʒu(x, y, z)
	float pos_rot[3]; // ʒuF](rad(x), rad(y), rad(z))
	float rigidbody_weight; // f[^F // 00 00 80 3F // 1.0
	float rigidbody_pos_dim; // f[^Fړ // 00 00 00 00
	float rigidbody_rot_dim; // f[^F] // 00 00 00 00
	float rigidbody_recoil; // f[^F // 00 00 00 00
	float rigidbody_friction; // f[^FC // 00 00 00 00
	u8 rigidbody_type; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
}sPmdRigidBody;

typedef struct sPmdJoint
{
	char joint_name[20]; // f[^F // E1
	u32 joint_rigidbody_a; // f[^FA
	u32 joint_rigidbody_b; // f[^FB
	float joint_pos[3]; // f[^Fʒu(x, y, z) // f[^Fʒułݒ
	float joint_rot[3]; // f[^F](rad(x), rad(y), rad(z))
	float constrain_pos_1[3]; // Fړ1(x, y, z)
	float constrain_pos_2[3]; // Fړ2(x, y, z)
	float constrain_rot_1[3]; // F]1(rad(x), rad(y), rad(z))
	float constrain_rot_2[3]; // F]2(rad(x), rad(y), rad(z))
	float spring_pos[3]; // ΂ˁFړ(x, y, z)
	float spring_rot[3]; // ΂ˁF](rad(x), rad(y), rad(z))
}sPmdJoint;

typedef struct sPmdFile
{
	sPmdHeader header;

	u32 vertexNum;
	sPmdVertex *vertex;

	u32 faceNum;
	sPmdFace *face;

	u32 materialNum;
	sPmdMaterial *material;

	u16 boneNum;
	sPmdBone *bone;

	u16 ikDataNum;
	sPmdIkData *ikData;

	u16 skinNum;
	sPmdSkin *skin;

	u8 skinIndexNum;
	u16 *skinIndex;

	u8 boneDispNameNum;
	sPmdBoneDispName *boneDispName;

	u16 boneDispListNum;
	sPmdBoneDispList *boneDispList;

	u8 englishExpansionFlag;
	sPmdEnglishHeader englishHeader;
	sPmdEnglishBoneName *englishBoneName;
	sPmdEnglishSkinName *englishSkinName;
	sPmdEnglishBoneDispName *englishBoneDispName;

	sPmdToonFileName toonFileName[10];

	u16 rigidBodyNum;
	sPmdRigidBody *rigidBody;

	u32 jointNum;
	sPmdJoint *joint;
}sPmdFile;

sPmdFile* PmdPerse(const char *filename);
void PmdDestruct(sPmdFile *pmd);

#ifdef __cplusplus
}
#endif


#endif
