﻿#pragma once
#include<Multimedia/SDX.h>
#include<Multimedia/Screen.h>

namespace SDX
{
/** ウィンドウを表すクラス.*/
/**	\include WindowSample.h*/
class Window
{
	friend class System;
    friend class Mouse;
    friend class Input;
private:
	bool isFullScreen = false;
	int width;
	int height;
    double aspect;

	Window(){}
	WindowHandle handle = 0;

public:

	static Window& Single()
	{
		static Window single;
		return single;		
	}

	/** スクリーンモードを設定する.*/
	/** DXLIBでは色々な設定が初期化される上、アスペクトが無視されます*/
	static bool SetFullScreen(bool フルスクリーンフラグ)
	{
		Single().isFullScreen = フルスクリーンフラグ;
	#ifdef DXLIB
        DxLib::ChangeWindowMode(!フルスクリーンフラグ);
        Screen::SetBack();
        return true;
	#elif defined(SDL)
        if (Single().isFullScreen)
        {
            SDL_RenderSetLogicalSize(Screen::GetHandle() , GetWidth() , GetHeight() );
            SDL_SetWindowFullscreen(Single().handle, SDL_WINDOW_FULLSCREEN_DESKTOP);
        }
        else
        {
            SDL_SetWindowFullscreen(Single().handle, 0);
            SDL_SetWindowSize(Single().handle, GetWidth(), GetHeight());
        }
		return false;
	#endif
	}
	
	/** ウィンドウタイトルを設定.*/
	static bool SetTitle(const char *タイトル名)
	{
	#ifdef DXLIB
		return !DxLib::SetMainWindowText(タイトル名);
	#elif defined(SDL)
        SDL_SetWindowTitle( Single().handle , タイトル名 );
		return true;
	#endif
	}
	
	/** アイコンIDの設定[DXLIB].*/
	static bool SetIconID(int アイコンID)
	{
	#ifdef DXLIB
		return !DxLib::SetWindowIconID( アイコンID );
	#elif defined(SDL)        
		return false;
	#endif
	}
	
	/** ウィンドウの拡大縮小可否設定[DXLIB].*/
	static bool SetSizeChangeEnable(bool 拡大縮小可能フラグ)
	{
	#ifdef DXLIB
		return !DxLib::SetWindowSizeChangeEnableFlag(拡大縮小可能フラグ);
	#elif defined(SDL)
		return false;
	#endif
	}
	
	/** ウィンドウサイズの設定.*/
	static bool SetSize(int 幅,int 高さ )
	{
        Window::Single().width  = 幅;
        Window::Single().height = 高さ;
	#ifdef DXLIB
		return !DxLib::SetWindowSize(幅, 高さ);
	#elif defined(SDL)
        SDL_RenderSetLogicalSize(Screen::GetHandle(), 幅, 高さ);
        SDL_SetWindowSize( Single().handle , 幅, 高さ);
		return true;
	#endif
	}
	
	/** ウィンドウ幅の取得.*/
	static int GetWidth()
	{
		return Single().width;
	}

	/** ウィンドウ高さの取得.*/
	static int GetHeight()
	{
		return Single().height;
	}
};
}