﻿/*!
@page howtoWindows SDXの導入方法(Windows)

SDXFrameWorkの使用には\n
「SDXFramework_DXIB」または｢SDXFramework_SDL2｣\n
「VisualStudio2013」\n
が必要です。\n
Windows環境の場合、コンパイラは「VisualC++ 2013 Express Edition for Desktop」を推奨しています。\n
識別子にUnicodeを使用している関係で、gccでコンパイルする事は出来ないと思われます。\n
VisualStudio2013以外の環境については、現在サポートしていません。
<HR>
<B>1 VisualStudioをインストールする</B>\n
C++の文法準拠の関係で、VisualStudio2012以前のコンパイラは使用できません。\n
<a href="http://www.visualstudio.com/downloads/download-visual-studio-vs" target="_blank"><B>Visual Studio のダウンロード</B></a>\n
「Visual Studio Express 2013 for Windows」と\n
「Visual Studio Express 2013 for Windows Desktop」がありますが\n
Desktopの方しか使えないので、注意して下さい。\n
また使用しているOSがWindowsXPやVistaの場合、VisualStudio2013がインストール出来ないため、SDXは使用できません。
\n
詳細なインストール方法やライセンス登録については、「VisualStudio 2013 インストール」でGoogle検索するといくつかキャプチャ付きの記事が見つかると思うので\n
それらを参考にしてください\n
<HR>
<B>2 SDXFrameWorkをダウンロードする</B>\n
下記サイトで最新版を配布しているので、リンク先からダウンロードして下さい\n
<a href="https://sourceforge.jp/projects/dxframework/" target="_blank"><B>SorceForge</B></a>\n
　解凍すると「SDXFramework_DXLIB」と言うフォルダが出来るので、適当な場所において下さい。\n
SDL版を使う場合は｢SDXFramework_SDL2｣を使って下さい。\n
<HR>
<B>3.1 新規プロジェクトの作成、DXLIB版</B>\n
DXLIB版は3.1、SDL版は3.2の設定をして下さい。\n
\n
VisualStudioを起動したら新規プロジェクトを作成します。\n
大体DXライブラリと似た方法になるので、そちらも参考にして下さい。\n
\n
参考:
<a href="http://homepage2.nifty.com/natupaji/DxLib/use/dxuse_vc2013express.html" target="_blank"><B>ＶｉｓｕａｌＳｔｕｄｉｏ Ｅｘｐｒｅｓｓ ２０１３ ｆｏｒ Ｗｉｎｄｏｗｓ Ｄｅｓｋｔｏｐ を使用した場合のＤＸライブラリの使い方</B></a>\n
\n
<B>新規プロジェクトを作成する</B>\n
①上部メニューの「ファイル」の「新しいプロジェクト」からWin32アプリケーションのプロジェクトを作成します。プロジェクト名は好きなように付けて下さい\n
\n
②Win32アプリケーション ウィザードが開くので、一回「次へ」をクリックします。\n
空のプロジェクトにチェックを入れて、完了をクリックして下さい。\n
\n
<B>プロジェクトを設定</B>\n
①上部メニューの「プロジェクト」をクリックし「プロパティ」をクリックし、設定ダイアログを開きます。\n
\n
②ダイアログ左上の構成を「アクティブ(Debug)」から「全ての構成」に変更します\n
\n
③ダイアログ左の「構成プロパティ」→「全般」を選びます\n
右の「文字セット」の項目を、「マルチ バイト文字セットを使用する」にして、ダイアログ右下の「適用」ボタンをクリックします。\n
\n
④ダイアログ左の「構成プロパティ」→「C/C++」→「全般」を選びます。\n
追加のインクルードディレクトリに先ほど解凍した「SDXFramework_DXLIB」を追加し、「適用」ボタンをクリックします。\n
\n
⑤ダイアログ左の「構成プロパティ」→「リンカー」→「全般」を選びます。\n
追加のライブラリディレクトリに先ほど解凍した「SDXFramework_DXLIB」の中にある「DXLib」のフォルダを追加し、「適用」ボタンをクリックします。\n
\n
⑥ダイアログ左上の構成を「全ての構成」から「Release」に変更します。\n
\n
⑦ダイアログ左の「構成プロパティ」→「C/C++」→「コード生成」を選びます。\n
右の「ランタイム ライブラリ」の項目を、「マルチスレッド (/MT)」に変更して、ダイアログ右下の「適用」ボタンをクリックします。\n
\n
⑧ダイアログ左上の構成を「Release」から「Debug」に変更します。\n
右の「ランタイム ライブラリ」の項目を、「マルチスレッド デバッグ (/MTd)」に変更してダイアログ右下の「適用」ボタンをクリックします。\n
\n
⑨最後にダイアログの右下にある「OK」を押してダイアログを閉じます。\n
<HR>
<B>3.2 新規プロジェクトの作成、SDL2版</B>\n
<B>プロジェクトの作成</B>\n
①上部メニューの「ファイル」の「新しいプロジェクト」からWin32アプリケーションのプロジェクトを作成します。プロジェクト名は好きなように付けて下さい\n
\n
②Win32アプリケーション ウィザードが開くので、一回「次へ」をクリックします。\n
空のプロジェクトにチェックを入れて、完了をクリックして下さい。\n
\n
<B>プロジェクトを設定</B>\n
①上部メニューの「プロジェクト」をクリックし「プロパティ」をクリックし、設定ダイアログを開きます。\n
\n
②ダイアログ左上の構成を「アクティブ(Debug)」から「全ての構成」に変更します\n
\n
③ダイアログ左の「構成プロパティ」→「C/C++」→「全般」を選びます。\n
追加のインクルードディレクトリに先ほど解凍した「SDXFramework_SDL2/jni/SDL/include」を追加し、「適用」ボタンをクリックします。\n
\n
④ダイアログ左の「構成プロパティ」→「リンカー」→「全般」を選びます。\n
追加のライブラリディレクトリに先ほど解凍した「SDXFrameWork_SDL2/Windows/lib/x86」を追加し、「適用」ボタンをクリックします。\n
\n
⑤ダイアログ左上の構成を「全ての構成」から「Release」に変更します。\n
\n
⑥最後にダイアログの右下にある「OK」を押してダイアログを閉じます。\n
\n
<B>dllのコピー</B>\n
SDXFrameWork_SDL2/Windows/dll/x86の中にあるdllファイルを実行ファイルが作成されるフォルダと同じ場所にコピーします\n
<HR>
<B>4 サンプルソースのビルド</B>\n
画面左側の「ソリューションエクスプローラー」の「ソースファイル」フォルダを、\n
右クリックして「追加」→「新しい項目」から.cppファイルを追加して下さい。\n
ファイル名は何でもかまいませんが「main.cpp」にして下さい。\n
追加したcppファイルに以下のコードをコピペして、コンパイルして実行して下さい。\n
@code
#define DXLIB //SDL版の場合 #define SDL
#include <SDXFrameWork.h>
#include <SDXafx.h>

using namespace SDX;

int main(int argc, char* argv[])
{
	System::Initialise("sample", 640, 480);//ライブラリの初期化

	int x = 320;
	int y = 240;

	while (System::Update())
	{
		if (Input::pad.Down.hold) y += 5;
		if (Input::pad.Up.hold) y -= 5;
		if (Input::pad.Right.hold) x += 5;
		if (Input::pad.Left.hold) x -= 5;

		Drawing::Rect(x-10, y-10, 20, 20, Color::White, true);
	}

	System::End();//ライブラリの終了処理

return 0;
}
@endcode

　画面に白い□が表示され、カーソルで移動出来れば導入成功です。\n
失敗した場合は、もう一度手順を確認して下さい。\n
よくわからない場合は、掲示板で「新しい話題を始める」をクリックして質問して下さい。\n
<a href="http://sourceforge.jp/projects/dxframework/forums/31378/" target="_blank"><B>SDXFrameWork：ヘルプフォーラム</B></a>\n

<HR>
<B>5 プリコンパイル済みヘッダーを利用する</B>\n
SDXは色々な理由があって、大半のコードをヘッダーに実装しており、普通にコンパイルすると時間が余計にかかります。\n
そのため、プリコンパイル済みヘッダーを使う事を推奨しています（使わなくても動作はします）\n
\n
<B>ファイルを追加する</B>\n
画面左側の「ソリューションエクスプローラー」の「ソースファイル」フォルダを右クリックして\n
「追加」→「新しい項目」から.cppファイルを追加して下さい。\n
ファイル名は「pre_compile.cpp」にして下さい。\n
\n
次に画面左側の「ソリューションエクスプローラー」の「ヘッダーファイル」フォルダを右クリックして\n
「追加」→「新しい項目」から.hファイルを追加して下さい。\n
ファイル名は「stdafx.h」にして下さい。\n
\n
<B>ファイルを編集する</B>\n
pre_compile.cpp（cppとhを間違えないで下さい）には\n
@code
#include "stdafx.h"
#include <SDXafx.h>
@endcode
と入力して下さい。\n
\n
stdafx.hには\n
@code
#define DXLIB //SDL版の場合 #define SDL
#include <SDXFrameWork.h>
@endcode
と入力して下さい。\n
\n
先ほどの「main.cpp」の\n
@code
#define DXLIB
#include <SDXFrameWork.h>
#include <SDXafx.h>
@endcode
の三行を\n
@code
#include "stdafx.h"
@endcode
に変更します。\n
\n
<B>プリコンパイル済みヘッダーの作成と使用設定</B>\n
　画面左側の「ソリューションエクスプローラー」の「main.cpp」を右クリックし「プロパティ」を開きます。\n
ダイアログ左の「構成プロパティ」→「C/C++」→「プリコンパイル済みヘッダー」を選択します。\n
画面右の「プリコンパイル済みヘッダー」を「使用 (/Yu)」に変更し、画面右下の「OK」をクリックします。\n
\n
　次は「ソリューションエクスプローラー」の「pre_compile.cpp」を右クリックし「プロパティ」を開きます。\n
ダイアログ左の「構成プロパティ」→「C/C++」→「プリコンパイル済みヘッダー」を選択します。\n
画面右の「プリコンパイル済みヘッダー」を「作成 (/Yc)」に変更し、画面右下の「OK」をクリックします。\n
\n
これで、コンパイルが通る事を確認して下さい。\n
\n
もし「main.cpp」以外に他の.cppファイルを追加する場合は、そのファイルも「main.cpp」と同じ設定をして、\n
@code
#include "stdafx.h"
@endcode
をファイルの先頭に書いて下さい。\n
<HR>
<B>6 プリコンパイル済みヘッダーだけ最適化する</B>\n
※この設定は必須ではありません\n
デバッグビルドが遅い場合は、プリコンパイル済みヘッダーのみ最適化する事が出来ます。\n
デバッグビルドで処理落ちしない場合は、この設定をする必要はありません。\n
\n
※VC++のバグなのか、１項目ずつ適用しないと、フリーズする事があります。\n
①画面左側の「ソリューションエクスプローラー」の「stdafx.cpp」を右クリックし「プロパティ」を開きます。\n
\n
②ダイアログ左上の構成を「アクティブ(Debug)」か「Debug」にします。\n
\n
③ダイアログ左の「構成プロパティ」→「C/C++」→「全般」を選択します。\n
画面右の「デバッグ情報の形式」を「プログラム データベース (/Zi)」に変更し、画面右下の「適用」をクリックします。\n
\n
④ダイアログ左の「構成プロパティ」→「C/C++」→「最適化」を選択します。\n
画面右の「最適化」を「実行速度の最大化 (/O2)」に変更し、画面右下の「適用」をクリックします。\n
\n
⑤ダイアログ左の「構成プロパティ」→「C/C++」→「コード生成」を選択します。\n
画面右の「基本ランタイムチェック」を「既定」に変更し、画面右下の「適用」をクリックします。\n
その後、隣の「OK」をクリックして、設定を完了させます。\n
\n
これで、ある程度処理が早くなります。\n
コンパイル時に警告メッセージが表示されますが、無視して下さい。\n
<HR>
<B>7 エディットコンティニュを有効にする</B>\n
　※この設定は必須ではありません\n
　ゲーム開発の場合、例えば敵キャラの動きを少し変えるとか、キャラクターの台詞を少し変えるとかする度に\n
プログラムを終了して、再コンパイルし実行するのは非常に手間がかかり面倒です。\n
lua等のスクリプトを使ったり、外部のリソースにしても良いのですが、それはそれで手間です。\n
\n
　VisualStudioを使う場合、エディットコンティニュを使えば、実行中に差分コンパイルが可能です。\n
多少制約はあるものの、使いこなせば相応に強力なのでVisualStudioを使うなら、是非とも使いましょう。\n
\n
<B>設定方法</B>\n
①上部メニューの「デバッグ」を開き「オプションと設定」をクリックしダイアログを開きます。\n
\n
②一覧から「デバッグ」→「エディットコンティニュ」を選択します。\n
\n
③「ネイティブのエディットコンティニュを有効にする」にチェックを入れ、画面右下の「OK」をクリックします。
\n
<B>エディットコンティニュの利用</B>\n
①先ほど書いたサンプルをデバッグ実行します。\n
\n
②実行中にソースを編集します。xやyに足したり引く値を5から15に増やして下さい。\n
\n
③上部メニューの「デバッグ」→「コード変更を適用」をクリックします。\n
\n
④差分コンパイルが開始しすぐに終わります。カーソルキーでの移動速度が３倍になっていれば成功です。\n
\n
　開発初期の全体的な設計の段階では、エディットコンティニューはそこまで便利ではないですし、\n
複数人で開発していて、スキル差が大きいのでスクリプトを使う場合や、スクリプトで追加データを配布したい場合等\n
エディットコンティニュが万能かと言うと、そうではないですが、VisualStudioを使うなら抑えておきたい機能です。\n
\n
<HR>
<B>8 プロジェクトのテンプレートを作成する。</B>\n
　VisualStudioでは一度作成したプロジェクトを雛形として保存する事が出来ます。\n
テンプレートを作成しておけば、次回以降のプロジェクト新規作成が楽になります。\n
\n
①画面上部の「ファイル」から、「テンプレートのエクスポート」を選択します。\n
\n
②ダイアログが開くので、プロジェクトテンプレートが選択されているのを確認して「次へ」をクリックします。\n
\n
③テンプレート名と、テンプレートの説明を書いて、「完了」をクリックします。\n
テンプレート名は「SDXテンプレート」等として下さい。\n
\n
④画面上部の「ファイル」から、「あたらしいプロジェクト」を選択します。\n
C++用のテンプレートが追加されていれば成功です。次回以降はこれを選択してプロジェクトを作成する事が出来ます。
<HR>
<B>9 完成したソフトを配布する。</B>\n
DXLib版の場合Releaseビルドして、exeファイルと必要なリソースを配布して下さい\n
SDL版の場合Releaseビルドして、exeファイルとdllファイルと必要なリソースを配布して下さい
*/