/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
package test.dvi;

import java.awt.Rectangle;

import junit.framework.Assert;

import org.junit.Test;

import dvi.DviRect;

public class DviRectTest {
//  private static final Logger LOGGER = Logger.getLogger(DviRectTest.class
//      .getName());

  @Test
  public void testToRectangle() {
    DviRect r = new DviRect(8, 3, 4, 2);
    Rectangle rect = r.toRectangle();
    Assert.assertEquals(r.x(), rect.x);
    Assert.assertEquals(r.y(), rect.y);
    Assert.assertEquals(r.width(), rect.width + 1);
    Assert.assertEquals(r.height(), rect.height + 1);
  }

  @Test
  public void testFromRectangle() {
    Rectangle rect = new Rectangle(-2, 4, 0, 8);
    DviRect r = DviRect.fromRectangle(rect);
    Assert.assertEquals(r.x(), rect.x);
    Assert.assertEquals(r.y(), rect.y);
    Assert.assertEquals(r.width(), rect.width + 1);
    Assert.assertEquals(r.height(), rect.height + 1);
  }
}
