/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.browser.v2.list;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.DefaultListModel;

import dvi.DviException;
import dvi.api.DviDocument;
import dvi.api.DviPage;
import dvi.util.DviUtils;

public class DviDocumentListModel
extends DefaultListModel
{
  private static final long serialVersionUID = -5921826330908247513L;
  private static final Logger LOGGER = Logger
      .getLogger(DviDocumentListModel.class.getName());
  private final DviDocument doc;
  
  public DviDocumentListModel(DviDocument doc)
  {
    this.doc = doc;
  }
  
  @Override
  public int getSize() {
    if (doc == null) return 0;
    try {
      return doc.getTotalPages();
    } catch (DviException e) {
      DviUtils.logStackTrace(LOGGER, Level.WARNING, e);
      return 0;
    }
  }
  
  public void invalidate(DviPage page)
  {
	try {
		int idx = page.getPageNumber();
		this.fireContentsChanged(this, idx, idx);
	} catch (DviException e) {
		DviUtils.logStackTrace(LOGGER, Level.WARNING, e);
	}  
  }

  @Override
  public Object getElementAt(int idx) {
    if (doc == null) return null;
    try {
      return doc.getPage(idx);
    } catch (DviException e) {
      DviUtils.logStackTrace(LOGGER, Level.WARNING, e);
      return null;
    }
  }


  public DviDocument getDviDocument() {
    return doc;
  }
}
