/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.v2.xdoc.dvi;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;

import dvi.DviException;
import dvi.DviResolution;
import dvi.DviSize;
import dvi.api.DviContext;
import dvi.api.DviDocument;
import dvi.ctx.DefaultDviContext;
import dvi.gui.swing.DragToScroll;
import dvi.gui.swing.ViewSpec;
import dvi.util.DviUtils;
import dvi.v2.xdoc.XDocument;
import dvi.v2.xdoc.XDocumentCanvas;
public class DviXDocumentTest {
  private static final Logger LOGGER = Logger
      .getLogger(DviXDocumentTest.class.getName());

  public static void main(final String[] args) throws Exception {
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        startGUI(args);
      }
    });
  }

  protected static void startGUI(final String [] args) {
    try {
      try{
        UIManager.getInstalledLookAndFeels();
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
      }catch(Exception e) {e.printStackTrace();}
      
      Toolkit.getDefaultToolkit().setDynamicLayout(true);
      
      JFileChooser chooser = new JFileChooser();
      int returnVal = chooser.showOpenDialog(null);
      if(returnVal != JFileChooser.APPROVE_OPTION) {
        return;
      }
      
      final DviContext ctx = new DefaultDviContext();
      final ViewSpec vs = new ViewSpec(ctx);
      final File file = chooser.getSelectedFile();
      final DviDocument dviDoc = ctx.openDviDocument(file);
      final XDocument xdoc = new DviXDocument(ctx, dviDoc, ctx.getDefaultPaperSize(), vs);
      final XDocumentCanvas canvas = new XDocumentCanvas(ctx, xdoc, new DviSize(256, 256));
      ViewSpec viewSpec = new ViewSpec(ctx);
      viewSpec.setResolution(new DviResolution(400, 4));
      canvas.setViewSpec(viewSpec);
      canvas.setPageNumber(0);
      
      final JScrollPane scroll = new JScrollPane(canvas);
      DragToScroll dragToScroll = new DragToScroll(scroll);
      dragToScroll.add(canvas);
      final JFrame frame = new JFrame();
      frame.setSize(800, 600);
      frame.setLocationRelativeTo(null);
      frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
      frame.getContentPane().add(scroll);
      frame.setVisible(true);
      frame.addKeyListener(new KeyListener() {
        public void keyPressed(KeyEvent e) {
          int code = e.getKeyCode();
          if (code == KeyEvent.VK_DOWN) {
            int pageNum = canvas.getPageNum() + 1;
            if (pageNum <= canvas.getMaxPageNum()) {
              canvas.setPageNumber(pageNum);
            }
          } else if (code == KeyEvent.VK_UP) {
            int pageNum = canvas.getPageNum() - 1;
            if (pageNum >= canvas.getMinPageNum()) {
              canvas.setPageNumber(pageNum);
            }
          }
        }
        public void keyReleased(KeyEvent e) {
        }
        public void keyTyped(KeyEvent e) {
        }
      });
      LOGGER.info("start up.");

    } catch (DviException e) {
      DviUtils.logStackTrace(LOGGER, Level.WARNING, e);
    }
  }
}
