/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
package dvi.v2.xdoc.dvi;

import java.util.ArrayList;
import java.util.logging.Logger;

import dvi.DviException;
import dvi.DviObject;
import dvi.DviPaperSize;
import dvi.api.DviContextSupport;
import dvi.api.DviDocument;
import dvi.api.DviPage;
import dvi.gui.swing.ViewSpec;
import dvi.v2.xdoc.XDocument;
import dvi.v2.xdoc.XPage;

public class DviXDocument
extends DviObject
implements XDocument
{
  private static final Logger LOGGER = Logger.getLogger(DviXDocument.class
      .getName());
  
  private final ArrayList<XPage> pages = new ArrayList<XPage>();

  private final DviDocument dviDoc;

  private final DviPaperSize paperSize;

  private boolean initialized;

  private final ViewSpec viewSpec;

  public DviXDocument(DviContextSupport dcs, DviDocument dviDoc,
      DviPaperSize paperSize, ViewSpec viewSpec
      ) {
    super(dcs);
    this.dviDoc = dviDoc;
    this.paperSize = paperSize;
    this.viewSpec = viewSpec;
    this.initialized = false;
  }

  public synchronized void initPages() throws DviException
  {
    if (!initialized) {
      doInitPages();
      initialized = true;
    }
  }
  
  private void doInitPages() throws DviException {
    for (DviPage page : dviDoc.getPages()) {
      pages.add(new DviXPage(this, page));
    }
  }

  public XPage getPage(int page) throws DviException {
    doInitPages();
    return pages.get(page);
  }

  public XPage[] getPages() throws DviException {
    doInitPages();
    return pages.toArray(new XPage[pages.size()]);
  }

  public int getTotalPages() throws DviException {
    doInitPages();
    return pages.size();
  }

  public DviDocument getDviDocument() {
    return dviDoc;
  }

  public DviPaperSize getPaperSize() {
    return paperSize;
  }

  public ViewSpec getViewSpec() {
    return viewSpec;
  }
}
