/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.render;

import dvi.DviException;
import dvi.DviFontSpec;
import dvi.api.DviContextSupport;

public class VirtualFontGeometer 
extends BasicGeometer
{
  private final DviFontSpec fs;
  private final double factor;
  public VirtualFontGeometer(DviContextSupport dcs, DviFontSpec fs) {
    super(dcs);
    this.fs = fs;
    factor = (double) fs.spaceSize() / (double)(1 << 20);
  }
  
  public DviFontSpec getFontSpec() {
	  return fs;
  }

  private int scale(int a) {
    return (int)(a * factor);
  }

  public void doSetRule(int width, int height) throws DviException {
    super.doSetRule(
      scale(width), scale(height)
    );
  }

  public void doPutRule(int width, int height) throws DviException {
    super.doPutRule(
      scale(width), scale(height)
    );
  }

  public void doRight(int by) throws DviException {
    super.doRight(scale(by));
  }
  public void doW(int by) throws DviException {
    super.doW(scale(by));
  }
  public void doX(int by) throws DviException {
    super.doX(scale(by));
  }

  public void doDown(int by) throws DviException {
    super.doDown(scale(by));
  }
  public void doY(int by) throws DviException {
    super.doY(scale(by));
  }
  public void doZ(int by) throws DviException {
    super.doZ(scale(by));
  }
}
