/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.render;

import java.util.Stack;

import dvi.DviColor;
import dvi.DviException;
import dvi.DviPoint;
import dvi.DviResolution;
import dvi.api.Device;

public abstract class AbstractDevice
implements Device
{
  private final DviResolution res;
  public AbstractDevice(DviResolution res) {
    this.res = res;
  }
  public DviResolution getResolution()
  throws DviException {
    return res;
  }

  protected DviPoint point = DviPoint.ORIGIN;
  public DviPoint getReferencePoint() throws DviException {
    return point;
  }
  public void setReferencePoint(DviPoint point) throws DviException {
    this.point = point;
  }

  public void translate(DviPoint p) throws DviException {
    point = point.translate(p);
  }
  public void translate(int dx, int dy) throws DviException {
    point = point.translate(dx, dy);
  }

  private DviColor color = new DviColor(0, 0, 0);
  public void setColor(DviColor color) throws DviException
  {
    this.color = color;
  }
  public DviColor getColor() throws DviException
  {
    return color;
  }

  protected final Stack<StackItem> stack = new Stack<StackItem>();

  public void save() throws DviException {
    stack.push(new StackItem(color, point));
  }
  public void restore() throws DviException {
    if (stack.empty())
      throw new IllegalStateException
        ("stack underflow");

    StackItem it = stack.pop();
    color = it.color;
    point = it.point;
  }

  private static class StackItem
  {
    private final DviColor color;
    private final DviPoint point;
    public StackItem(DviColor color, DviPoint point)
    {
      this.color = color;
      this.point = point;
    }
  }
}
