/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.plat.cygwin;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

import dvi.DviException;
import dvi.util.CommandShell;
import dvi.util.CommandShellHandler;
import dvi.util.DviUtils;
public class CygwinUtils {
  private static final Logger LOGGER = Logger.getLogger(CygwinUtils.class
      .getName());
  
  public static String posixPathToJavaPath(String posixPath)
  throws IOException, InterruptedException, DviException
  {
    CommandShell cs = new CommandShell();
    ArrayList<String> list = new ArrayList<String>();
    list.add("cygpath");
    list.add("-w");
    list.add(posixPath);
    cs.setCommandLine(list);
    final ArrayList<String> outputs = new ArrayList<String>();
    cs.setHandler(new CommandShellHandler() {
      public void handleStderr(InputStream in) throws IOException {
        DviUtils.logLinesFromStream("cygpath stderr", in, LOGGER, Level.FINE);
      }
      public void handleStdout(InputStream in) throws IOException {
        String [] lines = DviUtils.readLinesFromStream(in);
        for (String line : lines) {
          outputs.add(line);
        }
      }
      public void handleStdin(OutputStream out) throws IOException {
        out.close();
      }
    });
    int ret = cs.execute();
    if (ret != 0) {
      LOGGER.warning("command failed: " + DviUtils.join(" ", list));
      return null;
    } else {
      if (outputs.size() > 0) {
        return outputs.get(0);
      } else {
        return null;
      }
    }
  }
}
