/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.doc;
import java.io.IOException;
import java.net.URL;

import dvi.DviException;
import dvi.DviFontTable;
import dvi.DviObject;
import dvi.DviUnit;
import dvi.api.DviContextSupport;
import dvi.api.DviDocument;
import dvi.api.DviInput;
import dvi.api.DviPage;
import dvi.api.HasURL;
import dvi.cmd.DviPostPost;
import dvi.cmd.DviPostamble;
import dvi.cmd.DviPreamble;
import dvi.util.DviUtils;

// TODO: make URLDviDocument a subclass of StreamDviDocument
public class URLDviDocument extends DviObject implements DviDocument, HasURL {
//  private static final Logger LOGGER = Logger.getLogger(URLDviDocument.class
//      .getName());
  
  private final URL url;
  private final DviDocument streamDoc;
  
  public URLDviDocument(DviContextSupport dcs, URL url)
  throws DviException
  {
    super(dcs);
    this.url = url;
    try {
      this.streamDoc = new StreamDviDocument(this, url.openStream()) {
        @Override
        protected DviPage createPage(int pageNum, long bop, long eop) {
          return new DefaultDviPage(URLDviDocument.this, pageNum, bop, eop);
        }
      };
    } catch (IOException e) {
      throw new DviException(e);
    }
  }

  public DviPage getPage(int p) throws DviException
  {
    return streamDoc.getPage(p);
  }

  public DviPage[] getPages() throws DviException
  {
    return streamDoc.getPages();
  }

  public DviPostPost getPostPost() throws DviException
  {
    return streamDoc.getPostPost();
  }

  public DviPostamble getPostamble() throws DviException
  {
    return streamDoc.getPostamble();
  }

  public DviPreamble getPreamble() throws DviException
  {
    return streamDoc.getPreamble();
  }

  public int getTotalPages() throws DviException
  {
    return streamDoc.getTotalPages();
  }

  public long getDataSize() throws DviException
  {
    return streamDoc.getDataSize();
  }

  public DviUnit getDviUnit() throws DviException
  {
    return streamDoc.getDviUnit();
  }

  public DviFontTable getFontTable() throws DviException
  {
    return streamDoc.getFontTable();
  }

  public DviInput getInput() throws DviException
  {
    return streamDoc.getInput();
  }

  public DviInput getInput(long start, long end) throws DviException
  {
    return streamDoc.getInput(start, end);
  }

  public String getCacheKey()
  {
    return getClass().getName() + "--" + DviUtils.md5Hex(url.toExternalForm())
         + streamDoc.getCacheKey();
  }

  public URL getURL() throws DviException
  {
    return url;
  }
}
