/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.browser;

import java.util.logging.Logger;

import javax.swing.JLabel;
import javax.swing.SwingUtilities;

import dvi.api.DviContext;
import dvi.api.DviContextSupport;
import dvi.util.progress.ProgressEvent;
import dvi.util.progress.ProgressItem;
import dvi.util.progress.ProgressListener;
import dvi.util.progress.ProgressReporter;

public class DviProgressView extends JLabel
implements DviContextSupport, ProgressListener
{
  private static final Logger LOGGER = Logger.getLogger(DviProgressView.class.getName());
  private static final long serialVersionUID = -7549779069712448783L;
  private ProgressReporter reporter;
  
  private DviContextSupport dcs;
  public DviProgressView(DviContextSupport dcs)
  {
    this.dcs = dcs;
  }
  
  public DviContext getDviContext() { return dcs.getDviContext(); }

  protected void update(ProgressItem item)
  {
    if (item != null) {
      final String text = item.toString();
      LOGGER.finer("Schedule message: " + text);
      SwingUtilities.invokeLater(new Runnable() {
        public void run() {
          setText(text);
          LOGGER.finer("Set progress message: " + text);
        }
      });
    }
  }
  protected void update()
  {
    ProgressReporter reporter = getProgressReporter();
    if (reporter != null) {
      update(reporter.getMostRecentItem());
    }
  }
  
  public void progressClose(ProgressEvent e)
  {
    update(e.getItem());
  }

  public void progressOpen(ProgressEvent e)
  {
    update(e.getItem());
  }

  public void progressUpdate(ProgressEvent e)
  {
    update(e.getItem());
  }

  public void setProgressReporter(ProgressReporter reporter)
  {
    if (this.reporter != null)
      this.reporter.removeProgressListener(this);
    this.reporter = reporter;
    if (this.reporter != null)
      this.reporter.addProgressListener(this);
    update();
  }

  public ProgressReporter getProgressReporter()
  {
    return reporter;
  }
}
