/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

import dvi.DviObject;
import dvi.api.DviContextSupport;

public class DviDirectoryIndexCellRenderer
extends DviObject
implements ListCellRenderer
{
  public DviDirectoryIndexCellRenderer(DviContextSupport dcs)
  {
    super(dcs);
  }

  JLabel label = new JLabel();
  public Component getListCellRendererComponent(final JList list, Object value,
      final int index, boolean isSelected, boolean cellHasFocus)
  {
    label.setFont(new Font(null, Font.PLAIN, 14));
    label.setOpaque(true);
    label.setBackground(getDefaultBackgroundColor(index));
    label.setForeground(Color.black);
    label.setIcon(null);
    
    if (value instanceof File) {
      File file = (File) value;
      label.setText(file.getName());
      if (file.isDirectory()) {
        Icon icon = UIManager.getIcon("FileView.directoryIcon");
        label.setIcon(icon);
      } else {
        Icon icon = UIManager.getIcon("FileView.fileIcon");
        label.setIcon(icon);
      }
    } else {
      label.setText(String.valueOf(value));
    }
    if (isSelected) {
      if (cellHasFocus) {
        label.setForeground(Color.white);
        label.setBackground(new Color(0x2c, 0x2c, 0xff));
      } else {
        label.setForeground(Color.white);
        label.setBackground(Color.gray);
      }
    }
    return label;
  }
  
  private Color getDefaultBackgroundColor(int index)
  {
    if ((index % 2) == 0) return new Color(0xf0, 0xff, 0xff);
    return null;
  }
}
