/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
package dvi.browser;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

import dvi.DviException;
import dvi.util.DviUtils;

public class DviBrowserDropTarget
extends DropTarget
{
  private static final long serialVersionUID = -5644441005445615293L;
  private static final Logger LOGGER = Logger
      .getLogger(DviBrowserDropTarget.class.getName());
  private final DviBrowserMain mainWindow;
  
  public DviBrowserDropTarget(DviBrowserMain mainWindow)
  {
    this.mainWindow = mainWindow;
  }
  
  public void drop(DropTargetDropEvent e) {
    Transferable t = e.getTransferable();
    if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
      e.acceptDrop(DnDConstants.ACTION_REFERENCE);
      try {
        List<?> list = (List<?>) t.getTransferData(DataFlavor.javaFileListFlavor);
          for (int i = 0; i < list.size(); i++) {
            File file = (File) list.get(i);
            LOGGER.fine("Drop by file: " + file);
            try {
              mainWindow.open(file);
            } catch (DviException e1) {
              DviUtils.logStackTrace(LOGGER, Level.WARNING, e1);
            }
          }
          e.dropComplete(true);
      } catch (UnsupportedFlavorException e1) {
        DviUtils.logStackTrace(LOGGER, Level.WARNING, e1);
      } catch (IOException e1) {
        DviUtils.logStackTrace(LOGGER, Level.WARNING, e1);
      }
    } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
      e.acceptDrop(DnDConstants.ACTION_COPY);
      try {
        String s = (String) t.getTransferData(DataFlavor.stringFlavor);
        
        StringTokenizer st = new StringTokenizer(s, "\n");
  
        while(st.hasMoreTokens()){
          try {
            String item = st.nextToken();
            LOGGER.fine("Drop by string: " + item);
            File file = new File(item);
            if (file.exists()) {
              mainWindow.open(file);
            }
          } catch (DviException e1) {
            DviUtils.logStackTrace(LOGGER, Level.WARNING, e1);
          }
        }
        e.dropComplete(true);
      } catch (UnsupportedFlavorException e1) {
        DviUtils.logStackTrace(LOGGER, Level.WARNING, e1);
      } catch (IOException e1) {
        DviUtils.logStackTrace(LOGGER, Level.WARNING, e1);
      }
    }
  }

  public DviBrowserMain getMainWindow() {
    return mainWindow;
  }
}
