/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.browser;

import java.awt.BorderLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;

import dvi.api.DviContext;
import dvi.api.DviContextSupport;

public class DviAddressBar
extends JPanel
implements DviContextSupport
{
  private static final long serialVersionUID = 1L;
  private final DviContextSupport dcs;
  private JTextField addressEdit;
  
  public DviAddressBar(DviContextSupport dcs)
  {
    this.dcs = dcs;
    initializeComponents();
  }
  
  private void initializeComponents()
  {
    JToolBar toolbar = new JToolBar("Navigator");
    
    addressEdit = new JTextField(32);
    addressEdit.addFocusListener(new FocusListener() {
      public void focusGained(FocusEvent e)
      {
        addressEdit.selectAll();
      }
      public void focusLost(FocusEvent e)
      {
      }
    });
    toolbar.add(addressEdit);
    toolbar.setFloatable(false);
    setLayout(new BorderLayout());
    add(toolbar, BorderLayout.CENTER);
  }

  public DviContext getDviContext()
  {
    return dcs.getDviContext();
  }

  public JTextField getAddressEdit()
  {
    return addressEdit;
  }
}
